/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.structure;

import java.util.List;
import java.util.Random;
import lotr.common.LOTRFoods;
import lotr.common.LOTRMod;
import lotr.common.block.LOTRBlockPlate;
import lotr.common.entity.npc.LOTREntityRohanMeadhost;
import lotr.common.entity.npc.LOTREntityRohirrim;
import lotr.common.entity.npc.LOTRNames;
import lotr.common.world.biome.LOTRBiome;
import lotr.common.world.structure.LOTRWorldGenStructureBase;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class LOTRWorldGenMeadHall
extends LOTRWorldGenStructureBase {
    private Block plankBlock;
    private int plankMeta;
    private Block woodBlock;
    private int woodMeta;
    private Block stairBlock;
    private Block halfBlock;
    private int halfMeta;
    private Block floorBlock;
    private int floorMeta;
    private String[] meadHallName;

    public LOTRWorldGenMeadHall(boolean flag) {
        super(flag);
    }

    public boolean func_76484_a(World world, Random random, int i, int j, int k) {
        if (this.restrictions) {
            if (world.func_72807_a(i, k) != LOTRBiome.rohan) {
                return false;
            }
            if (world.func_147439_a(i, j - 1, k) != Blocks.field_150349_c) {
                return false;
            }
        }
        --j;
        int rotation = random.nextInt(4);
        if (!this.restrictions && this.usingPlayer != null) {
            rotation = this.usingPlayerRotation();
        }
        int xOffset = 0;
        int zOffset = 0;
        switch (rotation) {
            case 0: {
                zOffset = 11;
                break;
            }
            case 1: {
                xOffset = -11;
                break;
            }
            case 2: {
                zOffset = -11;
                break;
            }
            case 3: {
                xOffset = 11;
            }
        }
        int randomWood = random.nextInt(2);
        switch (randomWood) {
            case 0: {
                this.plankBlock = Blocks.field_150344_f;
                this.plankMeta = 0;
                this.woodBlock = Blocks.field_150364_r;
                this.woodMeta = 0;
                this.stairBlock = Blocks.field_150476_ad;
                this.halfBlock = Blocks.field_150376_bx;
                this.halfMeta = 0;
                break;
            }
            case 1: {
                this.plankBlock = Blocks.field_150344_f;
                this.plankMeta = 1;
                this.woodBlock = Blocks.field_150364_r;
                this.woodMeta = 1;
                this.stairBlock = Blocks.field_150485_bF;
                this.halfBlock = Blocks.field_150376_bx;
                this.halfMeta = 1;
            }
        }
        int randomFloor = random.nextInt(3);
        switch (randomFloor) {
            case 0: {
                this.floorBlock = Blocks.field_150417_aV;
                this.floorMeta = 0;
                break;
            }
            case 1: {
                this.floorBlock = Blocks.field_150336_V;
                this.floorMeta = 0;
                break;
            }
            case 2: {
                this.floorBlock = LOTRMod.brick;
                this.floorMeta = 4;
            }
        }
        this.meadHallName = LOTRNames.getRandomRohanMeadHallName(random);
        boolean flag = false;
        switch (rotation) {
            case 0: {
                flag = this.generateFacingSouth(world, random, i, j, k);
                break;
            }
            case 1: {
                flag = this.generateFacingWest(world, random, i, j, k);
                break;
            }
            case 2: {
                flag = this.generateFacingNorth(world, random, i, j, k);
                break;
            }
            case 3: {
                flag = this.generateFacingEast(world, random, i, j, k);
            }
        }
        if (flag) {
            LOTREntityRohanMeadhost meadHost = new LOTREntityRohanMeadhost(world);
            meadHost.func_70012_b((double)(i + xOffset) + 0.5, (double)j + 3.0, (double)(k + zOffset) + 0.5, 0.0f, 0.0f);
            meadHost.func_110161_a(null);
            meadHost.func_110171_b(i + xOffset, j + 1, k + zOffset, 4);
            meadHost.setSpecificLocationName(this.meadHallName[0] + " " + this.meadHallName[1]);
            world.func_72838_d((Entity)meadHost);
            int men = 3 + random.nextInt(5);
            for (int l = 0; l < men; ++l) {
                LOTREntityRohirrim man = new LOTREntityRohirrim(world);
                man.func_70012_b((double)(i + xOffset) + 0.5, (double)j + 3.0, (double)(k + zOffset) + 0.5, 0.0f, 0.0f);
                man.spawnRidingHorse = false;
                man.func_110161_a(null);
                man.func_70062_b(4, null);
                if (random.nextInt(3) == 0) {
                    man.func_70062_b(0, new ItemStack(LOTRMod.mug));
                } else {
                    man.func_70062_b(0, new ItemStack(LOTRMod.mugMead, 1, 1 + random.nextInt(3)));
                }
                man.isNPCPersistent = true;
                man.func_110171_b(i + xOffset, j + 1, k + zOffset, 16);
                world.func_72838_d((Entity)man);
            }
        }
        return flag;
    }

    private boolean generateFacingSouth(World world, Random random, int i, int j, int k) {
        int j1;
        int i1;
        int k1;
        if (this.restrictions) {
            for (int k12 = k + 1; k12 <= k + 24; ++k12) {
                for (int i12 = i - 5; i12 <= i + 5; ++i12) {
                    int j12 = world.func_72825_h(i12, k12) - 1;
                    if (world.func_147439_a(i12, j12, k12) == Blocks.field_150349_c) continue;
                    return false;
                }
            }
            List intersectingCreatures = world.func_72872_a(EntityLiving.class, AxisAlignedBB.func_72332_a().func_72299_a((double)i, (double)j, (double)k, (double)i + 1.0, (double)j + 1.0, (double)k + 1.0).func_72317_d(0.0, 3.0, 12.0).func_72314_b(5.0, 3.0, 12.0));
            for (Object obj : intersectingCreatures) {
                ((EntityLiving)obj).func_70106_y();
            }
        }
        for (k1 = k + 1; k1 <= k + 24; ++k1) {
            for (int i13 = i - 5; i13 <= i + 5; ++i13) {
                int j13;
                for (j13 = j; !(j13 != j && LOTRMod.isOpaque(world, i13, j13, k1) || j13 < 0); --j13) {
                    if (Math.abs(i13 - i) == 5 && (k1 == k + 1 || k1 == k + 23)) {
                        this.func_150516_a(world, i13, j13, k1, this.woodBlock, this.woodMeta);
                    } else if (Math.abs(i13 - i) == 5 || k1 == k + 1 || k1 == k + 24) {
                        this.func_150516_a(world, i13, j13, k1, this.plankBlock, this.plankMeta);
                    } else if (j13 == j) {
                        this.func_150516_a(world, i13, j13, k1, this.floorBlock, this.floorMeta);
                    } else {
                        this.func_150516_a(world, i13, j13, k1, Blocks.field_150346_d, 0);
                    }
                    if (world.func_147439_a(i13, j13 - 1, k1) != Blocks.field_150349_c) continue;
                    this.func_150516_a(world, i13, j13 - 1, k1, Blocks.field_150346_d, 0);
                }
                for (j13 = j + 1; j13 <= j + 5; ++j13) {
                    this.func_150516_a(world, i13, j13, k1, Blocks.field_150350_a, 0);
                }
            }
        }
        for (k1 = k + 2; k1 <= k + 22; ++k1) {
            for (int j14 = j + 1; j14 <= j + 3; ++j14) {
                this.func_150516_a(world, i - 5, j14, k1, this.plankBlock, this.plankMeta);
                this.func_150516_a(world, i + 5, j14, k1, this.plankBlock, this.plankMeta);
            }
        }
        for (k1 = k; k1 <= k + 24; ++k1) {
            this.func_150516_a(world, i - 5, j + 4, k1, this.woodBlock, this.woodMeta | 8);
            this.func_150516_a(world, i + 5, j + 4, k1, this.woodBlock, this.woodMeta | 8);
            this.func_150516_a(world, i, j + 6, k1, this.woodBlock, this.woodMeta | 8);
        }
        for (i1 = i - 4; i1 <= i + 4; ++i1) {
            for (int j15 = j + 1; j15 <= j + 4; ++j15) {
                this.func_150516_a(world, i1, j15, k + 1, this.plankBlock, this.plankMeta);
                this.func_150516_a(world, i1, j15, k + 23, this.plankBlock, this.plankMeta);
            }
        }
        for (j1 = j + 1; j1 <= j + 3; ++j1) {
            this.func_150516_a(world, i - 5, j1, k + 1, this.woodBlock, this.woodMeta);
            this.func_150516_a(world, i - 5, j1, k + 23, this.woodBlock, this.woodMeta);
            this.func_150516_a(world, i + 5, j1, k + 1, this.woodBlock, this.woodMeta);
            this.func_150516_a(world, i + 5, j1, k + 23, this.woodBlock, this.woodMeta);
        }
        for (k1 = k + 1; k1 <= k + 23; ++k1) {
            this.func_150516_a(world, i - 4, j + 5, k1, this.halfBlock, this.halfMeta);
            this.func_150516_a(world, i - 3, j + 5, k1, this.halfBlock, this.halfMeta | 8);
            this.func_150516_a(world, i - 2, j + 6, k1, this.halfBlock, this.halfMeta);
            this.func_150516_a(world, i - 1, j + 6, k1, this.halfBlock, this.halfMeta | 8);
            this.func_150516_a(world, i, j + 7, k1, this.halfBlock, this.halfMeta);
            this.func_150516_a(world, i + 1, j + 6, k1, this.halfBlock, this.halfMeta | 8);
            this.func_150516_a(world, i + 2, j + 6, k1, this.halfBlock, this.halfMeta);
            this.func_150516_a(world, i + 3, j + 5, k1, this.halfBlock, this.halfMeta | 8);
            this.func_150516_a(world, i + 4, j + 5, k1, this.halfBlock, this.halfMeta);
        }
        this.func_150516_a(world, i - 5, j + 5, k + 1, this.stairBlock, 1);
        this.func_150516_a(world, i - 3, j + 4, k + 1, this.woodBlock, this.woodMeta);
        this.func_150516_a(world, i - 3, j + 5, k + 1, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i - 2, j + 5, k + 1, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i - 1, j + 5, k + 1, this.woodBlock, this.woodMeta);
        this.func_150516_a(world, i - 1, j + 6, k + 1, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i, j + 5, k + 1, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i + 1, j + 6, k + 1, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i + 1, j + 5, k + 1, this.woodBlock, this.woodMeta);
        this.func_150516_a(world, i + 2, j + 5, k + 1, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i + 3, j + 5, k + 1, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i + 3, j + 4, k + 1, this.woodBlock, this.woodMeta);
        this.func_150516_a(world, i + 5, j + 5, k + 1, this.stairBlock, 0);
        for (i1 = i - 3; i1 <= i + 3; ++i1) {
            this.func_150516_a(world, i1, j + 5, k + 23, this.plankBlock, this.plankMeta);
        }
        this.func_150516_a(world, i - 5, j + 5, k + 23, this.stairBlock, 1);
        this.func_150516_a(world, i - 1, j + 6, k + 23, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i + 1, j + 6, k + 23, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i + 5, j + 5, k + 23, this.stairBlock, 0);
        for (j1 = j + 5; j1 >= j + 1; --j1) {
            this.func_150516_a(world, i - (j - j1) - 5, j1, k + 23, this.woodBlock, this.woodMeta);
            this.func_150516_a(world, i + (j - j1) + 5, j1, k + 23, this.woodBlock, this.woodMeta);
        }
        for (i1 = i - 5; i1 <= i + 5; ++i1) {
            this.func_150516_a(world, i1, j + 1, k + 24, this.halfBlock, this.halfMeta);
        }
        for (j1 = j + 3; j1 >= j + 1; --j1) {
            for (int i14 = i - (j - j1) - 3; i14 <= i + (j - j1) + 3; ++i14) {
                this.func_150516_a(world, i14, j1, k + 24, this.plankBlock, this.plankMeta);
            }
        }
        this.func_150516_a(world, i, j, k + 1, this.floorBlock, this.floorMeta);
        this.func_150516_a(world, i, j + 1, k + 1, Blocks.field_150466_ao, 1);
        this.func_150516_a(world, i, j + 2, k + 1, Blocks.field_150466_ao, 8);
        this.func_150516_a(world, i - 1, j + 2, k, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i + 1, j + 2, k, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i, j + 5, k + 5, LOTRMod.chandelier, 1);
        this.func_150516_a(world, i, j + 5, k + 11, LOTRMod.chandelier, 1);
        this.func_150516_a(world, i, j + 5, k + 17, LOTRMod.chandelier, 1);
        this.func_150516_a(world, i - 3, j + 3, k + 2, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i, j + 3, k + 2, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i + 3, j + 3, k + 2, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i - 4, j + 1, k + 2, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i - 3, j + 1, k + 2, this.halfBlock, this.halfMeta | 8);
        this.func_150516_a(world, i - 2, j + 1, k + 2, this.plankBlock, this.plankMeta);
        this.placeBarrel(world, random, i - 4, j + 2, k + 2, 3, LOTRMod.mugMead);
        this.placeBarrel(world, random, i - 3, j + 2, k + 2, 3, LOTRMod.mugMead);
        this.placeMug(world, random, i - 2, j + 2, k + 2, 2, LOTRMod.mugMead);
        this.func_150516_a(world, i + 4, j + 1, k + 2, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i + 3, j + 1, k + 2, this.halfBlock, this.halfMeta | 8);
        this.func_150516_a(world, i + 2, j + 1, k + 2, this.plankBlock, this.plankMeta);
        this.placeBarrel(world, random, i + 4, j + 2, k + 2, 3, LOTRMod.mugMead);
        this.placeBarrel(world, random, i + 3, j + 2, k + 2, 3, LOTRMod.mugMead);
        this.placeMug(world, random, i + 2, j + 2, k + 2, 2, LOTRMod.mugMead);
        for (k1 = k + 6; k1 <= k + 16; k1 += 2) {
            this.func_150516_a(world, i - 3, j + 1, k1, this.stairBlock, 1);
            this.func_150516_a(world, i + 3, j + 1, k1, this.stairBlock, 0);
        }
        for (k1 = k + 4; k1 <= k + 20; k1 += 2) {
            this.func_150516_a(world, i - 4, j + 3, k1, Blocks.field_150478_aa, 1);
            this.func_150516_a(world, i + 4, j + 3, k1, Blocks.field_150478_aa, 2);
        }
        for (k1 = k + 5; k1 <= k + 21; k1 += 4) {
            for (int j16 = j + 1; j16 <= j + 4; ++j16) {
                this.func_150516_a(world, i - 4, j16, k1, this.woodBlock, this.woodMeta);
                this.func_150516_a(world, i + 4, j16, k1, this.woodBlock, this.woodMeta);
            }
        }
        for (k1 = k + 7; k1 <= k + 15; k1 += 4) {
            this.placeItemFrame(world, i - 5, j + 2, k1, 3, random);
            this.placeItemFrame(world, i + 5, j + 2, k1, 1, random);
        }
        for (k1 = k + 5; k1 <= k + 17; ++k1) {
            for (int i15 = i - 1; i15 <= i + 1; ++i15) {
                this.func_150516_a(world, i15, j + 1, k1, (Block)Blocks.field_150376_bx, 10);
            }
            if ((k1 - k + 3) % 4 != 0) continue;
            this.func_150516_a(world, i - 1, j + 1, k1, Blocks.field_150344_f, 2);
            this.func_150516_a(world, i + 1, j + 1, k1, Blocks.field_150344_f, 2);
            this.func_150516_a(world, i, j + 2, k1, Blocks.field_150478_aa, 5);
        }
        for (k1 = k + 5; k1 <= k + 17; ++k1) {
            for (int i16 = i - 1; i16 <= i + 1; ++i16) {
                if (!world.func_147437_c(i16, j + 2, k1)) continue;
                this.placePlate(world, i16, j + 2, k1, random, LOTRFoods.ROHAN);
                if (!world.func_147437_c(i16, j + 2, k1) && (world.func_147439_a(i16, j + 2, k1) != LOTRMod.plateBlock || LOTRBlockPlate.getFoodItem(world, i16, j + 2, k1) != null)) continue;
                this.placePlate(world, i16, j + 2, k1, random, LOTRFoods.ROHAN);
            }
        }
        for (i1 = i - 2; i1 <= i + 2; ++i1) {
            for (int j17 = j + 1; j17 <= j + 5; ++j17) {
                this.func_150516_a(world, i1, j17, k + 21, this.floorBlock, this.floorMeta);
            }
        }
        for (i1 = i - 4; i1 <= i + 4; ++i1) {
            for (int j18 = j + 1; j18 <= j + 4; ++j18) {
                this.func_150516_a(world, i1, j18, k + 22, this.floorBlock, this.floorMeta);
            }
        }
        for (i1 = i - 2; i1 <= i + 2; ++i1) {
            this.func_150516_a(world, i1, j + 5, k + 22, this.floorBlock, this.floorMeta);
        }
        for (i1 = i - 1; i1 <= i + 1; ++i1) {
            for (int j19 = j + 1; j19 <= j + 2; ++j19) {
                this.func_150516_a(world, i1, j19, k + 23, this.floorBlock, this.floorMeta);
            }
        }
        for (i1 = i - 1; i1 <= i + 1; ++i1) {
            this.func_150516_a(world, i1, j + 1, k + 21, Blocks.field_150411_aY, 0);
            this.func_150516_a(world, i1, j + 2, k + 21, Blocks.field_150411_aY, 0);
            this.func_150516_a(world, i1, j, k + 22, LOTRMod.hearth, 0);
            this.func_150516_a(world, i1, j + 1, k + 22, (Block)Blocks.field_150480_ab, 0);
            this.func_150516_a(world, i1, j + 2, k + 22, Blocks.field_150350_a, 0);
        }
        this.func_150516_a(world, i - 3, j + 3, k + 21, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i + 3, j + 3, k + 21, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i - 3, j + 5, k + 22, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i - 1, j + 6, k + 21, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i + 1, j + 6, k + 21, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i + 3, j + 5, k + 22, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i, j + 3, k, Blocks.field_150444_as, 2);
        TileEntity tileentity = world.func_147438_o(i, j + 3, k);
        if (tileentity != null && tileentity instanceof TileEntitySign) {
            TileEntitySign sign = (TileEntitySign)tileentity;
            sign.field_145915_a[1] = this.meadHallName[0];
            sign.field_145915_a[2] = this.meadHallName[1];
        }
        return true;
    }

    private boolean generateFacingWest(World world, Random random, int i, int j, int k) {
        int j1;
        int k1;
        int i1;
        if (this.restrictions) {
            for (int i12 = i - 1; i12 >= i - 24; --i12) {
                for (int k12 = k - 5; k12 <= k + 5; ++k12) {
                    int j12 = world.func_72825_h(i12, k12) - 1;
                    if (world.func_147439_a(i12, j12, k12) == Blocks.field_150349_c) continue;
                    return false;
                }
            }
            List intersectingCreatures = world.func_72872_a(EntityLiving.class, AxisAlignedBB.func_72332_a().func_72299_a((double)i, (double)j, (double)k, (double)i + 1.0, (double)j + 1.0, (double)k + 1.0).func_72317_d(-12.0, 3.0, 0.0).func_72314_b(12.0, 3.0, 5.0));
            for (Object obj : intersectingCreatures) {
                ((EntityLiving)obj).func_70106_y();
            }
        }
        for (i1 = i - 1; i1 >= i - 24; --i1) {
            for (int k13 = k - 5; k13 <= k + 5; ++k13) {
                int j13;
                for (j13 = j; !(j13 != j && LOTRMod.isOpaque(world, i1, j13, k13) || j13 < 0); --j13) {
                    if (Math.abs(k13 - k) == 5 && (i1 == i - 1 || i1 == i - 23)) {
                        this.func_150516_a(world, i1, j13, k13, this.woodBlock, this.woodMeta);
                    } else if (Math.abs(k13 - k) == 5 || i1 == i - 1 || i1 == i - 24) {
                        this.func_150516_a(world, i1, j13, k13, this.plankBlock, this.plankMeta);
                    } else if (j13 == j) {
                        this.func_150516_a(world, i1, j13, k13, this.floorBlock, this.floorMeta);
                    } else {
                        this.func_150516_a(world, i1, j13, k13, Blocks.field_150346_d, 0);
                    }
                    if (world.func_147439_a(i1, j13 - 1, k13) != Blocks.field_150349_c) continue;
                    this.func_150516_a(world, i1, j13 - 1, k13, Blocks.field_150346_d, 0);
                }
                for (j13 = j + 1; j13 <= j + 5; ++j13) {
                    this.func_150516_a(world, i1, j13, k13, Blocks.field_150350_a, 0);
                }
            }
        }
        for (i1 = i - 2; i1 >= i - 22; --i1) {
            for (int j14 = j + 1; j14 <= j + 3; ++j14) {
                this.func_150516_a(world, i1, j14, k - 5, this.plankBlock, this.plankMeta);
                this.func_150516_a(world, i1, j14, k + 5, this.plankBlock, this.plankMeta);
            }
        }
        for (i1 = i; i1 >= i - 24; --i1) {
            this.func_150516_a(world, i1, j + 4, k - 5, this.woodBlock, this.woodMeta | 4);
            this.func_150516_a(world, i1, j + 4, k + 5, this.woodBlock, this.woodMeta | 4);
            this.func_150516_a(world, i1, j + 6, k, this.woodBlock, this.woodMeta | 4);
        }
        for (k1 = k - 4; k1 <= k + 4; ++k1) {
            for (int j15 = j + 1; j15 <= j + 4; ++j15) {
                this.func_150516_a(world, i - 1, j15, k1, this.plankBlock, this.plankMeta);
                this.func_150516_a(world, i - 23, j15, k1, this.plankBlock, this.plankMeta);
            }
        }
        for (j1 = j + 1; j1 <= j + 3; ++j1) {
            this.func_150516_a(world, i - 1, j1, k - 5, this.woodBlock, this.woodMeta);
            this.func_150516_a(world, i - 23, j1, k - 5, this.woodBlock, this.woodMeta);
            this.func_150516_a(world, i - 1, j1, k + 5, this.woodBlock, this.woodMeta);
            this.func_150516_a(world, i - 23, j1, k + 5, this.woodBlock, this.woodMeta);
        }
        for (i1 = i - 1; i1 >= i - 23; --i1) {
            this.func_150516_a(world, i1, j + 5, k - 4, this.halfBlock, this.halfMeta);
            this.func_150516_a(world, i1, j + 5, k - 3, this.halfBlock, this.halfMeta | 8);
            this.func_150516_a(world, i1, j + 6, k - 2, this.halfBlock, this.halfMeta);
            this.func_150516_a(world, i1, j + 6, k - 1, this.halfBlock, this.halfMeta | 8);
            this.func_150516_a(world, i1, j + 7, k, this.halfBlock, this.halfMeta);
            this.func_150516_a(world, i1, j + 6, k + 1, this.halfBlock, this.halfMeta | 8);
            this.func_150516_a(world, i1, j + 6, k + 2, this.halfBlock, this.halfMeta);
            this.func_150516_a(world, i1, j + 5, k + 3, this.halfBlock, this.halfMeta | 8);
            this.func_150516_a(world, i1, j + 5, k + 4, this.halfBlock, this.halfMeta);
        }
        this.func_150516_a(world, i - 1, j + 5, k - 5, this.stairBlock, 3);
        this.func_150516_a(world, i - 1, j + 4, k - 3, this.woodBlock, this.woodMeta);
        this.func_150516_a(world, i - 1, j + 5, k - 3, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i - 1, j + 5, k - 2, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i - 1, j + 5, k - 1, this.woodBlock, this.woodMeta);
        this.func_150516_a(world, i - 1, j + 6, k - 1, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i - 1, j + 5, k, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i - 1, j + 6, k + 1, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i - 1, j + 5, k + 1, this.woodBlock, this.woodMeta);
        this.func_150516_a(world, i - 1, j + 5, k + 2, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i - 1, j + 5, k + 3, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i - 1, j + 4, k + 3, this.woodBlock, this.woodMeta);
        this.func_150516_a(world, i - 1, j + 5, k + 5, this.stairBlock, 2);
        for (k1 = k - 3; k1 <= k + 3; ++k1) {
            this.func_150516_a(world, i - 23, j + 5, k1, this.plankBlock, this.plankMeta);
        }
        this.func_150516_a(world, i - 23, j + 5, k - 5, this.stairBlock, 3);
        this.func_150516_a(world, i - 23, j + 6, k - 1, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i - 23, j + 6, k + 1, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i - 23, j + 5, k + 5, this.stairBlock, 2);
        for (j1 = j + 5; j1 >= j + 1; --j1) {
            this.func_150516_a(world, i - 23, j1, k - (j - j1) - 5, this.woodBlock, this.woodMeta);
            this.func_150516_a(world, i - 23, j1, k + (j - j1) + 5, this.woodBlock, this.woodMeta);
        }
        for (k1 = k - 5; k1 <= k + 5; ++k1) {
            this.func_150516_a(world, i - 24, j + 1, k1, this.halfBlock, this.halfMeta);
        }
        for (j1 = j + 3; j1 >= j + 1; --j1) {
            for (int k14 = k - (j - j1) - 3; k14 <= k + (j - j1) + 3; ++k14) {
                this.func_150516_a(world, i - 24, j1, k14, this.plankBlock, this.plankMeta);
            }
        }
        this.func_150516_a(world, i - 1, j, k, this.floorBlock, this.floorMeta);
        this.func_150516_a(world, i - 1, j + 1, k, Blocks.field_150466_ao, 2);
        this.func_150516_a(world, i - 1, j + 2, k, Blocks.field_150466_ao, 8);
        this.func_150516_a(world, i, j + 2, k - 1, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i, j + 2, k + 1, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i - 5, j + 5, k, LOTRMod.chandelier, 1);
        this.func_150516_a(world, i - 11, j + 5, k, LOTRMod.chandelier, 1);
        this.func_150516_a(world, i - 17, j + 5, k, LOTRMod.chandelier, 1);
        this.func_150516_a(world, i - 2, j + 3, k - 3, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i - 2, j + 3, k, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i - 2, j + 3, k + 3, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i - 2, j + 1, k - 4, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i - 2, j + 1, k - 3, this.halfBlock, this.halfMeta | 8);
        this.func_150516_a(world, i - 2, j + 1, k - 2, this.plankBlock, this.plankMeta);
        this.placeBarrel(world, random, i - 2, j + 2, k - 4, 4, LOTRMod.mugMead);
        this.placeBarrel(world, random, i - 2, j + 2, k - 3, 4, LOTRMod.mugMead);
        this.placeMug(world, random, i - 2, j + 2, k - 2, 3, LOTRMod.mugMead);
        this.func_150516_a(world, i - 2, j + 1, k + 4, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i - 2, j + 1, k + 3, this.halfBlock, this.halfMeta | 8);
        this.func_150516_a(world, i - 2, j + 1, k + 2, this.plankBlock, this.plankMeta);
        this.placeBarrel(world, random, i - 2, j + 2, k + 4, 4, LOTRMod.mugMead);
        this.placeBarrel(world, random, i - 2, j + 2, k + 3, 4, LOTRMod.mugMead);
        this.placeMug(world, random, i - 2, j + 2, k + 2, 3, LOTRMod.mugMead);
        for (i1 = i - 6; i1 >= i - 16; i1 -= 2) {
            this.func_150516_a(world, i1, j + 1, k - 3, this.stairBlock, 3);
            this.func_150516_a(world, i1, j + 1, k + 3, this.stairBlock, 2);
        }
        for (i1 = i - 4; i1 >= i - 20; i1 -= 2) {
            this.func_150516_a(world, i1, j + 3, k - 4, Blocks.field_150478_aa, 3);
            this.func_150516_a(world, i1, j + 3, k + 4, Blocks.field_150478_aa, 4);
        }
        for (i1 = i - 5; i1 >= i - 21; i1 -= 4) {
            for (int j16 = j + 1; j16 <= j + 4; ++j16) {
                this.func_150516_a(world, i1, j16, k - 4, this.woodBlock, this.woodMeta);
                this.func_150516_a(world, i1, j16, k + 4, this.woodBlock, this.woodMeta);
            }
        }
        for (i1 = i - 7; i1 >= i - 15; i1 -= 4) {
            this.placeItemFrame(world, i1, j + 2, k - 5, 0, random);
            this.placeItemFrame(world, i1, j + 2, k + 5, 2, random);
        }
        for (i1 = i - 5; i1 >= i - 17; --i1) {
            for (int k15 = k - 1; k15 <= k + 1; ++k15) {
                this.func_150516_a(world, i1, j + 1, k15, (Block)Blocks.field_150376_bx, 10);
            }
            if ((i1 - i - 3) % 4 != 0) continue;
            this.func_150516_a(world, i1, j + 1, k - 1, Blocks.field_150344_f, 2);
            this.func_150516_a(world, i1, j + 1, k + 1, Blocks.field_150344_f, 2);
            this.func_150516_a(world, i1, j + 2, k, Blocks.field_150478_aa, 5);
        }
        for (i1 = i - 5; i1 >= i - 17; --i1) {
            for (int k16 = k - 1; k16 <= k + 1; ++k16) {
                if (!world.func_147437_c(i1, j + 2, k16)) continue;
                this.placePlate(world, i1, j + 2, k16, random, LOTRFoods.ROHAN);
                if (!world.func_147437_c(i1, j + 2, k16) && (world.func_147439_a(i1, j + 2, k16) != LOTRMod.plateBlock || LOTRBlockPlate.getFoodItem(world, i1, j + 2, k16) != null)) continue;
                this.placePlate(world, i1, j + 2, k16, random, LOTRFoods.ROHAN);
            }
        }
        for (k1 = k - 2; k1 <= k + 2; ++k1) {
            for (int j17 = j + 1; j17 <= j + 5; ++j17) {
                this.func_150516_a(world, i - 21, j17, k1, this.floorBlock, this.floorMeta);
            }
        }
        for (k1 = k - 4; k1 <= k + 4; ++k1) {
            for (int j18 = j + 1; j18 <= j + 4; ++j18) {
                this.func_150516_a(world, i - 22, j18, k1, this.floorBlock, this.floorMeta);
            }
        }
        for (k1 = k - 2; k1 <= k + 2; ++k1) {
            this.func_150516_a(world, i - 22, j + 5, k1, this.floorBlock, this.floorMeta);
        }
        for (k1 = k - 1; k1 <= k + 1; ++k1) {
            for (int j19 = j + 1; j19 <= j + 2; ++j19) {
                this.func_150516_a(world, i - 23, j19, k1, this.floorBlock, this.floorMeta);
            }
        }
        for (k1 = k - 1; k1 <= k + 1; ++k1) {
            this.func_150516_a(world, i - 21, j + 1, k1, Blocks.field_150411_aY, 0);
            this.func_150516_a(world, i - 21, j + 2, k1, Blocks.field_150411_aY, 0);
            this.func_150516_a(world, i - 22, j, k1, LOTRMod.hearth, 0);
            this.func_150516_a(world, i - 22, j + 1, k1, (Block)Blocks.field_150480_ab, 0);
            this.func_150516_a(world, i - 22, j + 2, k1, Blocks.field_150350_a, 0);
        }
        this.func_150516_a(world, i - 21, j + 3, k - 3, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i - 21, j + 3, k + 3, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i - 22, j + 5, k - 3, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i - 21, j + 6, k - 1, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i - 21, j + 6, k + 1, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i - 22, j + 5, k + 3, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i, j + 3, k, Blocks.field_150444_as, 5);
        TileEntity tileentity = world.func_147438_o(i, j + 3, k);
        if (tileentity != null && tileentity instanceof TileEntitySign) {
            TileEntitySign sign = (TileEntitySign)tileentity;
            sign.field_145915_a[1] = this.meadHallName[0];
            sign.field_145915_a[2] = this.meadHallName[1];
        }
        return true;
    }

    private boolean generateFacingNorth(World world, Random random, int i, int j, int k) {
        int j1;
        int i1;
        int k1;
        if (this.restrictions) {
            for (int k12 = k - 1; k12 >= k - 24; --k12) {
                for (int i12 = i - 5; i12 <= i + 5; ++i12) {
                    int j12 = world.func_72825_h(i12, k12) - 1;
                    if (world.func_147439_a(i12, j12, k12) == Blocks.field_150349_c) continue;
                    return false;
                }
            }
            List intersectingCreatures = world.func_72872_a(EntityLiving.class, AxisAlignedBB.func_72332_a().func_72299_a((double)i, (double)j, (double)k, (double)i + 1.0, (double)j + 1.0, (double)k + 1.0).func_72317_d(0.0, 3.0, -12.0).func_72314_b(5.0, 3.0, 12.0));
            for (Object obj : intersectingCreatures) {
                ((EntityLiving)obj).func_70106_y();
            }
        }
        for (k1 = k - 1; k1 >= k - 24; --k1) {
            for (int i13 = i - 5; i13 <= i + 5; ++i13) {
                int j13;
                for (j13 = j; !(j13 != j && LOTRMod.isOpaque(world, i13, j13, k1) || j13 < 0); --j13) {
                    if (Math.abs(i13 - i) == 5 && (k1 == k - 1 || k1 == k - 23)) {
                        this.func_150516_a(world, i13, j13, k1, this.woodBlock, this.woodMeta);
                    } else if (Math.abs(i13 - i) == 5 || k1 == k - 1 || k1 == k - 24) {
                        this.func_150516_a(world, i13, j13, k1, this.plankBlock, this.plankMeta);
                    } else if (j13 == j) {
                        this.func_150516_a(world, i13, j13, k1, this.floorBlock, this.floorMeta);
                    } else {
                        this.func_150516_a(world, i13, j13, k1, Blocks.field_150346_d, 0);
                    }
                    if (world.func_147439_a(i13, j13 - 1, k1) != Blocks.field_150349_c) continue;
                    this.func_150516_a(world, i13, j13 - 1, k1, Blocks.field_150346_d, 0);
                }
                for (j13 = j + 1; j13 <= j + 5; ++j13) {
                    this.func_150516_a(world, i13, j13, k1, Blocks.field_150350_a, 0);
                }
            }
        }
        for (k1 = k - 2; k1 >= k - 22; --k1) {
            for (int j14 = j + 1; j14 <= j + 3; ++j14) {
                this.func_150516_a(world, i - 5, j14, k1, this.plankBlock, this.plankMeta);
                this.func_150516_a(world, i + 5, j14, k1, this.plankBlock, this.plankMeta);
            }
        }
        for (k1 = k; k1 >= k - 24; --k1) {
            this.func_150516_a(world, i - 5, j + 4, k1, this.woodBlock, this.woodMeta | 8);
            this.func_150516_a(world, i + 5, j + 4, k1, this.woodBlock, this.woodMeta | 8);
            this.func_150516_a(world, i, j + 6, k1, this.woodBlock, this.woodMeta | 8);
        }
        for (i1 = i - 4; i1 <= i + 4; ++i1) {
            for (int j15 = j + 1; j15 <= j + 4; ++j15) {
                this.func_150516_a(world, i1, j15, k - 1, this.plankBlock, this.plankMeta);
                this.func_150516_a(world, i1, j15, k - 23, this.plankBlock, this.plankMeta);
            }
        }
        for (j1 = j + 1; j1 <= j + 3; ++j1) {
            this.func_150516_a(world, i - 5, j1, k - 1, this.woodBlock, this.woodMeta);
            this.func_150516_a(world, i - 5, j1, k - 23, this.woodBlock, this.woodMeta);
            this.func_150516_a(world, i + 5, j1, k - 1, this.woodBlock, this.woodMeta);
            this.func_150516_a(world, i + 5, j1, k - 23, this.woodBlock, this.woodMeta);
        }
        for (k1 = k - 1; k1 >= k - 23; --k1) {
            this.func_150516_a(world, i - 4, j + 5, k1, this.halfBlock, this.halfMeta);
            this.func_150516_a(world, i - 3, j + 5, k1, this.halfBlock, this.halfMeta | 8);
            this.func_150516_a(world, i - 2, j + 6, k1, this.halfBlock, this.halfMeta);
            this.func_150516_a(world, i - 1, j + 6, k1, this.halfBlock, this.halfMeta | 8);
            this.func_150516_a(world, i, j + 7, k1, this.halfBlock, this.halfMeta);
            this.func_150516_a(world, i + 1, j + 6, k1, this.halfBlock, this.halfMeta | 8);
            this.func_150516_a(world, i + 2, j + 6, k1, this.halfBlock, this.halfMeta);
            this.func_150516_a(world, i + 3, j + 5, k1, this.halfBlock, this.halfMeta | 8);
            this.func_150516_a(world, i + 4, j + 5, k1, this.halfBlock, this.halfMeta);
        }
        this.func_150516_a(world, i - 5, j + 5, k - 1, this.stairBlock, 1);
        this.func_150516_a(world, i - 3, j + 4, k - 1, this.woodBlock, this.woodMeta);
        this.func_150516_a(world, i - 3, j + 5, k - 1, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i - 2, j + 5, k - 1, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i - 1, j + 5, k - 1, this.woodBlock, this.woodMeta);
        this.func_150516_a(world, i - 1, j + 6, k - 1, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i, j + 5, k - 1, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i + 1, j + 6, k - 1, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i + 1, j + 5, k - 1, this.woodBlock, this.woodMeta);
        this.func_150516_a(world, i + 2, j + 5, k - 1, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i + 3, j + 5, k - 1, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i + 3, j + 4, k - 1, this.woodBlock, this.woodMeta);
        this.func_150516_a(world, i + 5, j + 5, k - 1, this.stairBlock, 0);
        for (i1 = i - 3; i1 <= i + 3; ++i1) {
            this.func_150516_a(world, i1, j + 5, k - 23, this.plankBlock, this.plankMeta);
        }
        this.func_150516_a(world, i - 5, j + 5, k - 23, this.stairBlock, 1);
        this.func_150516_a(world, i - 1, j + 6, k - 23, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i + 1, j + 6, k - 23, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i + 5, j + 5, k - 23, this.stairBlock, 0);
        for (j1 = j + 5; j1 >= j + 1; --j1) {
            this.func_150516_a(world, i - (j - j1) - 5, j1, k - 23, this.woodBlock, this.woodMeta);
            this.func_150516_a(world, i + (j - j1) + 5, j1, k - 23, this.woodBlock, this.woodMeta);
        }
        for (i1 = i - 5; i1 <= i + 5; ++i1) {
            this.func_150516_a(world, i1, j + 1, k - 24, this.halfBlock, this.halfMeta);
        }
        for (j1 = j + 3; j1 >= j + 1; --j1) {
            for (int i14 = i - (j - j1) - 3; i14 <= i + (j - j1) + 3; ++i14) {
                this.func_150516_a(world, i14, j1, k - 24, this.plankBlock, this.plankMeta);
            }
        }
        this.func_150516_a(world, i, j, k - 1, this.floorBlock, this.floorMeta);
        this.func_150516_a(world, i, j + 1, k - 1, Blocks.field_150466_ao, 3);
        this.func_150516_a(world, i, j + 2, k - 1, Blocks.field_150466_ao, 8);
        this.func_150516_a(world, i - 1, j + 2, k, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i + 1, j + 2, k, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i, j + 5, k - 5, LOTRMod.chandelier, 1);
        this.func_150516_a(world, i, j + 5, k - 11, LOTRMod.chandelier, 1);
        this.func_150516_a(world, i, j + 5, k - 17, LOTRMod.chandelier, 1);
        this.func_150516_a(world, i - 3, j + 3, k - 2, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i, j + 3, k - 2, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i + 3, j + 3, k - 2, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i - 4, j + 1, k - 2, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i - 3, j + 1, k - 2, this.halfBlock, this.halfMeta | 8);
        this.func_150516_a(world, i - 2, j + 1, k - 2, this.plankBlock, this.plankMeta);
        this.placeBarrel(world, random, i - 4, j + 2, k - 2, 2, LOTRMod.mugMead);
        this.placeBarrel(world, random, i - 3, j + 2, k - 2, 2, LOTRMod.mugMead);
        this.placeMug(world, random, i - 2, j + 2, k - 2, 0, LOTRMod.mugMead);
        this.func_150516_a(world, i + 4, j + 1, k - 2, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i + 3, j + 1, k - 2, this.halfBlock, this.halfMeta | 8);
        this.func_150516_a(world, i + 2, j + 1, k - 2, this.plankBlock, this.plankMeta);
        this.placeBarrel(world, random, i + 4, j + 2, k - 2, 2, LOTRMod.mugMead);
        this.placeBarrel(world, random, i + 3, j + 2, k - 2, 2, LOTRMod.mugMead);
        this.placeMug(world, random, i + 2, j + 2, k - 2, 0, LOTRMod.mugMead);
        for (k1 = k - 6; k1 >= k - 16; k1 -= 2) {
            this.func_150516_a(world, i - 3, j + 1, k1, this.stairBlock, 1);
            this.func_150516_a(world, i + 3, j + 1, k1, this.stairBlock, 0);
        }
        for (k1 = k - 4; k1 >= k - 20; k1 -= 2) {
            this.func_150516_a(world, i - 4, j + 3, k1, Blocks.field_150478_aa, 1);
            this.func_150516_a(world, i + 4, j + 3, k1, Blocks.field_150478_aa, 2);
        }
        for (k1 = k - 5; k1 >= k - 21; k1 -= 4) {
            for (int j16 = j + 1; j16 <= j + 4; ++j16) {
                this.func_150516_a(world, i - 4, j16, k1, this.woodBlock, this.woodMeta);
                this.func_150516_a(world, i + 4, j16, k1, this.woodBlock, this.woodMeta);
            }
        }
        for (k1 = k - 7; k1 >= k - 15; k1 -= 4) {
            this.placeItemFrame(world, i - 5, j + 2, k1, 3, random);
            this.placeItemFrame(world, i + 5, j + 2, k1, 1, random);
        }
        for (k1 = k - 5; k1 >= k - 17; --k1) {
            for (int i15 = i - 1; i15 <= i + 1; ++i15) {
                this.func_150516_a(world, i15, j + 1, k1, (Block)Blocks.field_150376_bx, 10);
            }
            if ((k1 - k - 3) % 4 != 0) continue;
            this.func_150516_a(world, i - 1, j + 1, k1, Blocks.field_150344_f, 2);
            this.func_150516_a(world, i + 1, j + 1, k1, Blocks.field_150344_f, 2);
            this.func_150516_a(world, i, j + 2, k1, Blocks.field_150478_aa, 5);
        }
        for (k1 = k - 5; k1 >= k - 17; --k1) {
            for (int i16 = i - 1; i16 <= i + 1; ++i16) {
                if (!world.func_147437_c(i16, j + 2, k1)) continue;
                this.placePlate(world, i16, j + 2, k1, random, LOTRFoods.ROHAN);
                if (!world.func_147437_c(i16, j + 2, k1) && (world.func_147439_a(i16, j + 2, k1) != LOTRMod.plateBlock || LOTRBlockPlate.getFoodItem(world, i16, j + 2, k1) != null)) continue;
                this.placePlate(world, i16, j + 2, k1, random, LOTRFoods.ROHAN);
            }
        }
        for (i1 = i - 2; i1 <= i + 2; ++i1) {
            for (int j17 = j + 1; j17 <= j + 5; ++j17) {
                this.func_150516_a(world, i1, j17, k - 21, this.floorBlock, this.floorMeta);
            }
        }
        for (i1 = i - 4; i1 <= i + 4; ++i1) {
            for (int j18 = j + 1; j18 <= j + 4; ++j18) {
                this.func_150516_a(world, i1, j18, k - 22, this.floorBlock, this.floorMeta);
            }
        }
        for (i1 = i - 2; i1 <= i + 2; ++i1) {
            this.func_150516_a(world, i1, j + 5, k - 22, this.floorBlock, this.floorMeta);
        }
        for (i1 = i - 1; i1 <= i + 1; ++i1) {
            for (int j19 = j + 1; j19 <= j + 2; ++j19) {
                this.func_150516_a(world, i1, j19, k - 23, this.floorBlock, this.floorMeta);
            }
        }
        for (i1 = i - 1; i1 <= i + 1; ++i1) {
            this.func_150516_a(world, i1, j + 1, k - 21, Blocks.field_150411_aY, 0);
            this.func_150516_a(world, i1, j + 2, k - 21, Blocks.field_150411_aY, 0);
            this.func_150516_a(world, i1, j, k - 22, LOTRMod.hearth, 0);
            this.func_150516_a(world, i1, j + 1, k - 22, (Block)Blocks.field_150480_ab, 0);
            this.func_150516_a(world, i1, j + 2, k - 22, Blocks.field_150350_a, 0);
        }
        this.func_150516_a(world, i - 3, j + 3, k - 21, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i + 3, j + 3, k - 21, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i - 3, j + 5, k - 22, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i - 1, j + 6, k - 21, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i + 1, j + 6, k - 21, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i + 3, j + 5, k - 22, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i, j + 3, k, Blocks.field_150444_as, 3);
        TileEntity tileentity = world.func_147438_o(i, j + 3, k);
        if (tileentity != null && tileentity instanceof TileEntitySign) {
            TileEntitySign sign = (TileEntitySign)tileentity;
            sign.field_145915_a[1] = this.meadHallName[0];
            sign.field_145915_a[2] = this.meadHallName[1];
        }
        return true;
    }

    private boolean generateFacingEast(World world, Random random, int i, int j, int k) {
        int j1;
        int k1;
        int i1;
        if (this.restrictions) {
            for (int i12 = i + 1; i12 <= i + 24; ++i12) {
                for (int k12 = k - 5; k12 <= k + 5; ++k12) {
                    int j12 = world.func_72825_h(i12, k12) - 1;
                    if (world.func_147439_a(i12, j12, k12) == Blocks.field_150349_c) continue;
                    return false;
                }
            }
            List intersectingCreatures = world.func_72872_a(EntityLiving.class, AxisAlignedBB.func_72332_a().func_72299_a((double)i, (double)j, (double)k, (double)i + 1.0, (double)j + 1.0, (double)k + 1.0).func_72317_d(12.0, 3.0, 0.0).func_72314_b(12.0, 3.0, 5.0));
            for (Object obj : intersectingCreatures) {
                ((EntityLiving)obj).func_70106_y();
            }
        }
        for (i1 = i + 1; i1 <= i + 24; ++i1) {
            for (int k13 = k - 5; k13 <= k + 5; ++k13) {
                int j13;
                for (j13 = j; !(j13 != j && LOTRMod.isOpaque(world, i1, j13, k13) || j13 < 0); --j13) {
                    if (Math.abs(k13 - k) == 5 && (i1 == i + 1 || i1 == i + 23)) {
                        this.func_150516_a(world, i1, j13, k13, this.woodBlock, this.woodMeta);
                    } else if (Math.abs(k13 - k) == 5 || i1 == i + 1 || i1 == i + 24) {
                        this.func_150516_a(world, i1, j13, k13, this.plankBlock, this.plankMeta);
                    } else if (j13 == j) {
                        this.func_150516_a(world, i1, j13, k13, this.floorBlock, this.floorMeta);
                    } else {
                        this.func_150516_a(world, i1, j13, k13, Blocks.field_150346_d, 0);
                    }
                    if (world.func_147439_a(i1, j13 - 1, k13) != Blocks.field_150349_c) continue;
                    this.func_150516_a(world, i1, j13 - 1, k13, Blocks.field_150346_d, 0);
                }
                for (j13 = j + 1; j13 <= j + 5; ++j13) {
                    this.func_150516_a(world, i1, j13, k13, Blocks.field_150350_a, 0);
                }
            }
        }
        for (i1 = i + 2; i1 <= i + 22; ++i1) {
            for (int j14 = j + 1; j14 <= j + 3; ++j14) {
                this.func_150516_a(world, i1, j14, k - 5, this.plankBlock, this.plankMeta);
                this.func_150516_a(world, i1, j14, k + 5, this.plankBlock, this.plankMeta);
            }
        }
        for (i1 = i; i1 <= i + 24; ++i1) {
            this.func_150516_a(world, i1, j + 4, k - 5, this.woodBlock, this.woodMeta | 4);
            this.func_150516_a(world, i1, j + 4, k + 5, this.woodBlock, this.woodMeta | 4);
            this.func_150516_a(world, i1, j + 6, k, this.woodBlock, this.woodMeta | 4);
        }
        for (k1 = k - 4; k1 <= k + 4; ++k1) {
            for (int j15 = j + 1; j15 <= j + 4; ++j15) {
                this.func_150516_a(world, i + 1, j15, k1, this.plankBlock, this.plankMeta);
                this.func_150516_a(world, i + 23, j15, k1, this.plankBlock, this.plankMeta);
            }
        }
        for (j1 = j + 1; j1 <= j + 3; ++j1) {
            this.func_150516_a(world, i + 1, j1, k - 5, this.woodBlock, this.woodMeta);
            this.func_150516_a(world, i + 23, j1, k - 5, this.woodBlock, this.woodMeta);
            this.func_150516_a(world, i + 1, j1, k + 5, this.woodBlock, this.woodMeta);
            this.func_150516_a(world, i + 23, j1, k + 5, this.woodBlock, this.woodMeta);
        }
        for (i1 = i + 1; i1 <= i + 23; ++i1) {
            this.func_150516_a(world, i1, j + 5, k - 4, this.halfBlock, this.halfMeta);
            this.func_150516_a(world, i1, j + 5, k - 3, this.halfBlock, this.halfMeta | 8);
            this.func_150516_a(world, i1, j + 6, k - 2, this.halfBlock, this.halfMeta);
            this.func_150516_a(world, i1, j + 6, k - 1, this.halfBlock, this.halfMeta | 8);
            this.func_150516_a(world, i1, j + 7, k, this.halfBlock, this.halfMeta);
            this.func_150516_a(world, i1, j + 6, k + 1, this.halfBlock, this.halfMeta | 8);
            this.func_150516_a(world, i1, j + 6, k + 2, this.halfBlock, this.halfMeta);
            this.func_150516_a(world, i1, j + 5, k + 3, this.halfBlock, this.halfMeta | 8);
            this.func_150516_a(world, i1, j + 5, k + 4, this.halfBlock, this.halfMeta);
        }
        this.func_150516_a(world, i + 1, j + 5, k - 5, this.stairBlock, 3);
        this.func_150516_a(world, i + 1, j + 4, k - 3, this.woodBlock, this.woodMeta);
        this.func_150516_a(world, i + 1, j + 5, k - 3, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i + 1, j + 5, k - 2, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i + 1, j + 5, k - 1, this.woodBlock, this.woodMeta);
        this.func_150516_a(world, i + 1, j + 6, k - 1, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i + 1, j + 5, k, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i + 1, j + 6, k + 1, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i + 1, j + 5, k + 1, this.woodBlock, this.woodMeta);
        this.func_150516_a(world, i + 1, j + 5, k + 2, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i + 1, j + 5, k + 3, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i + 1, j + 4, k + 3, this.woodBlock, this.woodMeta);
        this.func_150516_a(world, i + 1, j + 5, k + 5, this.stairBlock, 2);
        for (k1 = k - 3; k1 <= k + 3; ++k1) {
            this.func_150516_a(world, i + 23, j + 5, k1, this.plankBlock, this.plankMeta);
        }
        this.func_150516_a(world, i + 23, j + 5, k - 5, this.stairBlock, 3);
        this.func_150516_a(world, i + 23, j + 6, k - 1, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i + 23, j + 6, k + 1, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i + 23, j + 5, k + 5, this.stairBlock, 2);
        for (j1 = j + 5; j1 >= j + 1; --j1) {
            this.func_150516_a(world, i + 23, j1, k - (j - j1) - 5, this.woodBlock, this.woodMeta);
            this.func_150516_a(world, i + 23, j1, k + (j - j1) + 5, this.woodBlock, this.woodMeta);
        }
        for (k1 = k - 5; k1 <= k + 5; ++k1) {
            this.func_150516_a(world, i + 24, j + 1, k1, this.halfBlock, this.halfMeta);
        }
        for (j1 = j + 3; j1 >= j + 1; --j1) {
            for (int k14 = k - (j - j1) - 3; k14 <= k + (j - j1) + 3; ++k14) {
                this.func_150516_a(world, i + 24, j1, k14, this.plankBlock, this.plankMeta);
            }
        }
        this.func_150516_a(world, i + 1, j, k, this.floorBlock, this.floorMeta);
        this.func_150516_a(world, i + 1, j + 1, k, Blocks.field_150466_ao, 0);
        this.func_150516_a(world, i + 1, j + 2, k, Blocks.field_150466_ao, 8);
        this.func_150516_a(world, i, j + 2, k - 1, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i, j + 2, k + 1, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i + 5, j + 5, k, LOTRMod.chandelier, 1);
        this.func_150516_a(world, i + 11, j + 5, k, LOTRMod.chandelier, 1);
        this.func_150516_a(world, i + 17, j + 5, k, LOTRMod.chandelier, 1);
        this.func_150516_a(world, i + 2, j + 3, k - 3, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i + 2, j + 3, k, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i + 2, j + 3, k + 3, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i + 2, j + 1, k - 4, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i + 2, j + 1, k - 3, this.halfBlock, this.halfMeta | 8);
        this.func_150516_a(world, i + 2, j + 1, k - 2, this.plankBlock, this.plankMeta);
        this.placeBarrel(world, random, i + 2, j + 2, k - 4, 5, LOTRMod.mugMead);
        this.placeBarrel(world, random, i + 2, j + 2, k - 3, 5, LOTRMod.mugMead);
        this.placeMug(world, random, i + 2, j + 2, k - 2, 1, LOTRMod.mugMead);
        this.func_150516_a(world, i + 2, j + 1, k + 4, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i + 2, j + 1, k + 3, this.halfBlock, this.halfMeta | 8);
        this.func_150516_a(world, i + 2, j + 1, k + 2, this.plankBlock, this.plankMeta);
        this.placeBarrel(world, random, i + 2, j + 2, k + 4, 5, LOTRMod.mugMead);
        this.placeBarrel(world, random, i + 2, j + 2, k + 3, 5, LOTRMod.mugMead);
        this.placeMug(world, random, i + 2, j + 2, k + 2, 1, LOTRMod.mugMead);
        for (i1 = i + 6; i1 <= i + 16; i1 += 2) {
            this.func_150516_a(world, i1, j + 1, k - 3, this.stairBlock, 3);
            this.func_150516_a(world, i1, j + 1, k + 3, this.stairBlock, 2);
        }
        for (i1 = i + 4; i1 <= i + 20; i1 += 2) {
            this.func_150516_a(world, i1, j + 3, k - 4, Blocks.field_150478_aa, 3);
            this.func_150516_a(world, i1, j + 3, k + 4, Blocks.field_150478_aa, 4);
        }
        for (i1 = i + 5; i1 <= i + 21; i1 += 4) {
            for (int j16 = j + 1; j16 <= j + 4; ++j16) {
                this.func_150516_a(world, i1, j16, k - 4, this.woodBlock, this.woodMeta);
                this.func_150516_a(world, i1, j16, k + 4, this.woodBlock, this.woodMeta);
            }
        }
        for (i1 = i + 7; i1 <= i + 15; i1 += 4) {
            this.placeItemFrame(world, i1, j + 2, k - 5, 0, random);
            this.placeItemFrame(world, i1, j + 2, k + 5, 2, random);
        }
        for (i1 = i + 5; i1 <= i + 17; ++i1) {
            for (int k15 = k - 1; k15 <= k + 1; ++k15) {
                this.func_150516_a(world, i1, j + 1, k15, (Block)Blocks.field_150376_bx, 10);
            }
            if ((i1 - i + 3) % 4 != 0) continue;
            this.func_150516_a(world, i1, j + 1, k - 1, Blocks.field_150344_f, 2);
            this.func_150516_a(world, i1, j + 1, k + 1, Blocks.field_150344_f, 2);
            this.func_150516_a(world, i1, j + 2, k, Blocks.field_150478_aa, 5);
        }
        for (i1 = i + 5; i1 <= i + 17; ++i1) {
            for (int k16 = k - 1; k16 <= k + 1; ++k16) {
                if (!world.func_147437_c(i1, j + 2, k16)) continue;
                this.placePlate(world, i1, j + 2, k16, random, LOTRFoods.ROHAN);
                if (!world.func_147437_c(i1, j + 2, k16) && (world.func_147439_a(i1, j + 2, k16) != LOTRMod.plateBlock || LOTRBlockPlate.getFoodItem(world, i1, j + 2, k16) != null)) continue;
                this.placePlate(world, i1, j + 2, k16, random, LOTRFoods.ROHAN);
            }
        }
        for (k1 = k - 2; k1 <= k + 2; ++k1) {
            for (int j17 = j + 1; j17 <= j + 5; ++j17) {
                this.func_150516_a(world, i + 21, j17, k1, this.floorBlock, this.floorMeta);
            }
        }
        for (k1 = k - 4; k1 <= k + 4; ++k1) {
            for (int j18 = j + 1; j18 <= j + 4; ++j18) {
                this.func_150516_a(world, i + 22, j18, k1, this.floorBlock, this.floorMeta);
            }
        }
        for (k1 = k - 2; k1 <= k + 2; ++k1) {
            this.func_150516_a(world, i + 22, j + 5, k1, this.floorBlock, this.floorMeta);
        }
        for (k1 = k - 1; k1 <= k + 1; ++k1) {
            for (int j19 = j + 1; j19 <= j + 2; ++j19) {
                this.func_150516_a(world, i + 23, j19, k1, this.floorBlock, this.floorMeta);
            }
        }
        for (k1 = k - 1; k1 <= k + 1; ++k1) {
            this.func_150516_a(world, i + 21, j + 1, k1, Blocks.field_150411_aY, 0);
            this.func_150516_a(world, i + 21, j + 2, k1, Blocks.field_150411_aY, 0);
            this.func_150516_a(world, i + 22, j, k1, LOTRMod.hearth, 0);
            this.func_150516_a(world, i + 22, j + 1, k1, (Block)Blocks.field_150480_ab, 0);
            this.func_150516_a(world, i + 22, j + 2, k1, Blocks.field_150350_a, 0);
        }
        this.func_150516_a(world, i + 21, j + 3, k - 3, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i + 21, j + 3, k + 3, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i + 22, j + 5, k - 3, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i + 21, j + 6, k - 1, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i + 21, j + 6, k + 1, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i + 22, j + 5, k + 3, this.plankBlock, this.plankMeta);
        this.func_150516_a(world, i, j + 3, k, Blocks.field_150444_as, 4);
        TileEntity tileentity = world.func_147438_o(i, j + 3, k);
        if (tileentity != null && tileentity instanceof TileEntitySign) {
            TileEntitySign sign = (TileEntitySign)tileentity;
            sign.field_145915_a[1] = this.meadHallName[0];
            sign.field_145915_a[2] = this.meadHallName[1];
        }
        return true;
    }

    private void placeItemFrame(World world, int i, int j, int k, int direction, Random random) {
        ItemStack item = null;
        int l = random.nextInt(6);
        switch (l) {
            case 0: 
            case 1: 
            case 2: {
                item = new ItemStack(LOTRMod.mug);
                break;
            }
            case 3: {
                item = new ItemStack(Items.field_151041_m);
                break;
            }
            case 4: {
                item = new ItemStack((Item)Items.field_151031_f);
                break;
            }
            case 5: {
                item = new ItemStack(Items.field_151032_g);
            }
        }
        this.spawnItemFrame(world, i, j, k, direction, item);
    }
}

