/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.structure;

import java.util.Random;
import lotr.common.LOTRMod;
import lotr.common.entity.npc.LOTREntityRohirrim;
import lotr.common.entity.npc.LOTREntityRohirrimArcher;
import lotr.common.world.biome.LOTRBiome;
import lotr.common.world.structure.LOTRChestContents;
import lotr.common.world.structure.LOTRWorldGenStructureBase;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class LOTRWorldGenRohanWatchtower
extends LOTRWorldGenStructureBase {
    private Block plankBlock = Blocks.field_150344_f;
    private int plankMeta = 0;
    private Block woodBlock = Blocks.field_150364_r;
    private int woodMeta = 0;
    private Block stairBlock = Blocks.field_150476_ad;

    public LOTRWorldGenRohanWatchtower(boolean flag) {
        super(flag);
    }

    public boolean func_76484_a(World world, Random random, int i, int j, int k) {
        if (this.restrictions && (world.func_147439_a(i, j - 1, k) != Blocks.field_150349_c || world.func_72807_a(i, k) != LOTRBiome.rohan)) {
            return false;
        }
        int height = 5 + random.nextInt(4);
        j += height;
        if (this.restrictions) {
            for (int i1 = i - 4; i1 <= i + 4; ++i1) {
                for (int j1 = j - 3; j1 <= j + 4; ++j1) {
                    for (int k1 = k - 4; k1 <= k + 4; ++k1) {
                        if (world.func_147437_c(i1, j1, k1)) continue;
                        return false;
                    }
                }
            }
        }
        this.generateBasicStructure(world, random, i, j, k);
        int soldiers = 1 + random.nextInt(3);
        for (int l = 0; l < soldiers; ++l) {
            LOTREntityRohirrim rohirrim = random.nextInt(3) == 0 ? new LOTREntityRohirrimArcher(world) : new LOTREntityRohirrim(world);
            rohirrim.isNPCPersistent = true;
            rohirrim.spawnRidingHorse = false;
            rohirrim.func_70012_b((double)i + 0.5, j + 1, (double)k + 0.5, world.field_73012_v.nextFloat(), 0.0f);
            rohirrim.func_110161_a(null);
            world.func_72838_d((Entity)rohirrim);
            rohirrim.func_110171_b(i, j, k, 4);
        }
        int rotation = random.nextInt(4);
        if (!this.restrictions && this.usingPlayer != null) {
            rotation = this.usingPlayerRotation();
        }
        switch (rotation) {
            case 0: {
                return this.generateFacingSouth(world, random, i, j, k);
            }
            case 1: {
                return this.generateFacingWest(world, random, i, j, k);
            }
            case 2: {
                return this.generateFacingNorth(world, random, i, j, k);
            }
            case 3: {
                return this.generateFacingEast(world, random, i, j, k);
            }
        }
        return true;
    }

    private void generateBasicStructure(World world, Random random, int i, int j, int k) {
        int k1;
        int k12;
        int i1;
        int j1;
        for (j1 = j + 3; !LOTRMod.isOpaque(world, i - 3, j1, k - 3) && j1 >= 0; --j1) {
            this.func_150516_a(world, i - 3, j1, k - 3, this.plankBlock, this.plankMeta);
        }
        for (j1 = j + 3; !LOTRMod.isOpaque(world, i - 3, j1, k + 3) && j1 >= 0; --j1) {
            this.func_150516_a(world, i - 3, j1, k + 3, this.plankBlock, this.plankMeta);
        }
        for (j1 = j + 3; !LOTRMod.isOpaque(world, i + 3, j1, k - 3) && j1 >= 0; --j1) {
            this.func_150516_a(world, i + 3, j1, k - 3, this.plankBlock, this.plankMeta);
        }
        for (j1 = j + 3; !LOTRMod.isOpaque(world, i + 3, j1, k + 3) && j1 >= 0; --j1) {
            this.func_150516_a(world, i + 3, j1, k + 3, this.plankBlock, this.plankMeta);
        }
        for (i1 = i - 2; i1 <= i + 2; ++i1) {
            for (k12 = k - 2; k12 <= k + 2; ++k12) {
                this.func_150516_a(world, i1, j, k12, this.plankBlock, this.plankMeta);
            }
        }
        for (i1 = i - 3; i1 <= i + 3; ++i1) {
            for (k12 = k - 3; k12 <= k + 3; ++k12) {
                this.func_150516_a(world, i1, j + 4, k12, this.plankBlock, this.plankMeta);
            }
        }
        for (i1 = i - 2; i1 <= i + 2; ++i1) {
            this.func_150516_a(world, i1, j, k - 3, this.woodBlock, this.woodMeta | 4);
            this.func_150516_a(world, i1, j, k + 3, this.woodBlock, this.woodMeta | 4);
            this.func_150516_a(world, i1, j + 4, k - 3, this.woodBlock, this.woodMeta | 4);
            this.func_150516_a(world, i1, j + 4, k + 3, this.woodBlock, this.woodMeta | 4);
            this.func_150516_a(world, i1, j, k - 4, this.stairBlock, 6);
            this.func_150516_a(world, i1, j, k + 4, this.stairBlock, 7);
            this.func_150516_a(world, i1, j + 1, k - 4, Blocks.field_150422_aJ, 0);
            this.func_150516_a(world, i1, j + 1, k + 4, Blocks.field_150422_aJ, 0);
            this.func_150516_a(world, i1, j + 3, k - 3, Blocks.field_150422_aJ, 0);
            this.func_150516_a(world, i1, j + 3, k + 3, Blocks.field_150422_aJ, 0);
        }
        for (k1 = k - 2; k1 <= k + 2; ++k1) {
            this.func_150516_a(world, i - 3, j, k1, this.woodBlock, this.woodMeta | 8);
            this.func_150516_a(world, i + 3, j, k1, this.woodBlock, this.woodMeta | 8);
            this.func_150516_a(world, i - 3, j + 4, k1, this.woodBlock, this.woodMeta | 8);
            this.func_150516_a(world, i + 3, j + 4, k1, this.woodBlock, this.woodMeta | 8);
            this.func_150516_a(world, i - 4, j, k1, this.stairBlock, 4);
            this.func_150516_a(world, i + 4, j, k1, this.stairBlock, 5);
            this.func_150516_a(world, i - 4, j + 1, k1, Blocks.field_150422_aJ, 0);
            this.func_150516_a(world, i + 4, j + 1, k1, Blocks.field_150422_aJ, 0);
            this.func_150516_a(world, i - 3, j + 3, k1, Blocks.field_150422_aJ, 0);
            this.func_150516_a(world, i + 3, j + 3, k1, Blocks.field_150422_aJ, 0);
        }
        this.func_150516_a(world, i - 3, j + 1, k - 2, Blocks.field_150422_aJ, 0);
        this.func_150516_a(world, i - 3, j + 1, k + 2, Blocks.field_150422_aJ, 0);
        this.func_150516_a(world, i + 3, j + 1, k - 2, Blocks.field_150422_aJ, 0);
        this.func_150516_a(world, i + 3, j + 1, k + 2, Blocks.field_150422_aJ, 0);
        this.func_150516_a(world, i - 2, j + 1, k - 3, Blocks.field_150422_aJ, 0);
        this.func_150516_a(world, i + 2, j + 1, k - 3, Blocks.field_150422_aJ, 0);
        this.func_150516_a(world, i - 2, j + 1, k + 3, Blocks.field_150422_aJ, 0);
        this.func_150516_a(world, i + 2, j + 1, k + 3, Blocks.field_150422_aJ, 0);
        this.func_150516_a(world, i - 3, j + 2, k - 2, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i - 3, j + 2, k + 2, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i + 3, j + 2, k - 2, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i + 3, j + 2, k + 2, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i - 2, j + 2, k - 3, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i + 2, j + 2, k - 3, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i - 2, j + 2, k + 3, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i + 2, j + 2, k + 3, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i - 1, j + 4, k, this.woodBlock, this.woodMeta | 8);
        this.func_150516_a(world, i + 1, j + 4, k, this.woodBlock, this.woodMeta | 8);
        this.func_150516_a(world, i, j + 4, k - 1, this.woodBlock, this.woodMeta | 4);
        this.func_150516_a(world, i, j + 4, k + 1, this.woodBlock, this.woodMeta | 4);
        for (i1 = i - 4; i1 <= i + 4; ++i1) {
            this.func_150516_a(world, i1, j + 4, k - 4, this.stairBlock, 2);
            this.func_150516_a(world, i1, j + 4, k + 4, this.stairBlock, 3);
        }
        for (k1 = k - 4; k1 <= k + 4; ++k1) {
            this.func_150516_a(world, i - 4, j + 4, k1, this.stairBlock, 0);
            this.func_150516_a(world, i + 4, j + 4, k1, this.stairBlock, 1);
        }
    }

    private boolean generateFacingSouth(World world, Random random, int i, int j, int k) {
        int j1;
        for (j1 = j; j1 <= j + 3; ++j1) {
            this.func_150516_a(world, i, j1, k + 3, this.plankBlock, this.plankMeta);
            this.func_150516_a(world, i, j1, k + 2, Blocks.field_150468_ap, 2);
        }
        for (j1 = j - 1; !LOTRMod.isOpaque(world, i, j1, k + 3) && j1 >= 0; --j1) {
            this.func_150516_a(world, i, j1, k + 3, this.plankBlock, this.plankMeta);
        }
        for (j1 = j - 1; !LOTRMod.isOpaque(world, i, j1, k + 2) && j1 >= 0; --j1) {
            this.func_150516_a(world, i, j1, k + 2, Blocks.field_150468_ap, 2);
        }
        this.func_150516_a(world, i - 2, j + 1, k + 2, (Block)Blocks.field_150486_ae, 3);
        LOTRChestContents.fillChest(world, random, i - 2, j + 1, k + 2, LOTRChestContents.ROHAN_WATCHTOWER);
        this.func_150516_a(world, i + 2, j + 1, k + 2, LOTRMod.rohirricTable, 0);
        for (int k1 = k - 2; k1 <= k + 2; ++k1) {
            int j2;
            int j12;
            int k2 = Math.abs(k - k1);
            for (j12 = j - 1; !LOTRMod.isOpaque(world, i - 3, j12, k1) && j12 >= 0; --j12) {
                j2 = j - j12;
                if (!(k2 == 2 && j2 % 4 == 1 || k2 == 1 && j2 % 2 == 0) && (k2 != 0 || j2 % 4 != 3)) continue;
                this.func_150516_a(world, i - 3, j12, k1, this.woodBlock, this.woodMeta);
                if (k2 != 0) continue;
                this.func_150516_a(world, i - 2, j12, k1, Blocks.field_150478_aa, 1);
            }
            for (j12 = j - 1; !LOTRMod.isOpaque(world, i + 3, j12, k1) && j12 >= 0; --j12) {
                j2 = j - j12;
                if (!(k2 == 2 && j2 % 4 == 1 || k2 == 1 && j2 % 2 == 0) && (k2 != 0 || j2 % 4 != 3)) continue;
                this.func_150516_a(world, i + 3, j12, k1, this.woodBlock, this.woodMeta);
                if (k2 != 0) continue;
                this.func_150516_a(world, i + 2, j12, k1, Blocks.field_150478_aa, 2);
            }
        }
        for (j1 = j - 1; !LOTRMod.isOpaque(world, i + 2, j1, k + 2) && j1 >= 0; --j1) {
        }
        this.func_150516_a(world, i + 2, j1 + 1, k + 2, (Block)Blocks.field_150486_ae, 4);
        LOTRChestContents.fillChest(world, random, i + 2, j1 + 1, k + 2, LOTRChestContents.ROHAN_WATCHTOWER);
        for (j1 = j - 1; !LOTRMod.isOpaque(world, i + 2, j1, k) && j1 >= 0; --j1) {
        }
        this.func_150516_a(world, i + 2, j1 + 1, k, this.plankBlock, this.plankMeta);
        this.placeBarrel(world, random, i + 2, j1 + 2, k, 4, LOTRMod.mugMead);
        for (j1 = j - 1; !LOTRMod.isOpaque(world, i - 2, j1, k + 1) && j1 >= 0; --j1) {
        }
        this.func_150516_a(world, i - 2, j1 + 1, k + 1, Blocks.field_150407_cf, 0);
        for (j1 = j - 1; !LOTRMod.isOpaque(world, i - 2, j1, k + 2) && j1 >= 0; --j1) {
        }
        this.func_150516_a(world, i - 2, j1 + 1, k + 2, Blocks.field_150407_cf, 0);
        this.func_150516_a(world, i - 2, j1 + 2, k + 2, Blocks.field_150407_cf, 0);
        for (j1 = j - 1; !LOTRMod.isOpaque(world, i - 1, j1, k + 2) && j1 >= 0; --j1) {
        }
        this.func_150516_a(world, i - 1, j1 + 1, k + 2, Blocks.field_150407_cf, 0);
        return true;
    }

    private boolean generateFacingWest(World world, Random random, int i, int j, int k) {
        int j1;
        for (j1 = j; j1 <= j + 3; ++j1) {
            this.func_150516_a(world, i - 3, j1, k, this.plankBlock, this.plankMeta);
            this.func_150516_a(world, i - 2, j1, k, Blocks.field_150468_ap, 5);
        }
        for (j1 = j - 1; !LOTRMod.isOpaque(world, i - 3, j1, k) && j1 >= 0; --j1) {
            this.func_150516_a(world, i - 3, j1, k, this.plankBlock, this.plankMeta);
        }
        for (j1 = j - 1; !LOTRMod.isOpaque(world, i - 2, j1, k) && j1 >= 0; --j1) {
            this.func_150516_a(world, i - 2, j1, k, Blocks.field_150468_ap, 5);
        }
        this.func_150516_a(world, i - 2, j + 1, k - 2, (Block)Blocks.field_150486_ae, 4);
        LOTRChestContents.fillChest(world, random, i - 2, j + 1, k - 2, LOTRChestContents.ROHAN_WATCHTOWER);
        this.func_150516_a(world, i - 2, j + 1, k + 2, LOTRMod.rohirricTable, 0);
        for (int i1 = i - 2; i1 <= i + 2; ++i1) {
            int j2;
            int j12;
            int i2 = Math.abs(i - i1);
            for (j12 = j - 1; !LOTRMod.isOpaque(world, i1, j12, k - 3) && j12 >= 0; --j12) {
                j2 = j - j12;
                if (!(i2 == 2 && j2 % 4 == 1 || i2 == 1 && j2 % 2 == 0) && (i2 != 0 || j2 % 4 != 3)) continue;
                this.func_150516_a(world, i1, j12, k - 3, this.woodBlock, this.woodMeta);
                if (i2 != 0) continue;
                this.func_150516_a(world, i1, j12, k - 2, Blocks.field_150478_aa, 3);
            }
            for (j12 = j - 1; !LOTRMod.isOpaque(world, i1, j12, k + 3) && j12 >= 0; --j12) {
                j2 = j - j12;
                if (!(i2 == 2 && j2 % 4 == 1 || i2 == 1 && j2 % 2 == 0) && (i2 != 0 || j2 % 4 != 3)) continue;
                this.func_150516_a(world, i1, j12, k + 3, this.woodBlock, this.woodMeta);
                if (i2 != 0) continue;
                this.func_150516_a(world, i1, j12, k + 2, Blocks.field_150478_aa, 4);
            }
        }
        for (j1 = j - 1; !LOTRMod.isOpaque(world, i - 2, j1, k + 2) && j1 >= 0; --j1) {
        }
        this.func_150516_a(world, i - 2, j1 + 1, k + 2, (Block)Blocks.field_150486_ae, 2);
        LOTRChestContents.fillChest(world, random, i - 2, j1 + 1, k + 2, LOTRChestContents.ROHAN_WATCHTOWER);
        for (j1 = j - 1; !LOTRMod.isOpaque(world, i, j1, k + 2) && j1 >= 0; --j1) {
        }
        this.func_150516_a(world, i, j1 + 1, k + 2, this.plankBlock, this.plankMeta);
        this.placeBarrel(world, random, i, j1 + 2, k + 2, 2, LOTRMod.mugMead);
        for (j1 = j - 1; !LOTRMod.isOpaque(world, i - 1, j1, k - 2) && j1 >= 0; --j1) {
        }
        this.func_150516_a(world, i - 1, j1 + 1, k - 2, Blocks.field_150407_cf, 1);
        for (j1 = j - 1; !LOTRMod.isOpaque(world, i - 2, j1, k - 2) && j1 >= 0; --j1) {
        }
        this.func_150516_a(world, i - 2, j1 + 1, k - 2, Blocks.field_150407_cf, 1);
        this.func_150516_a(world, i - 2, j1 + 2, k - 2, Blocks.field_150407_cf, 1);
        for (j1 = j - 1; !LOTRMod.isOpaque(world, i - 2, j1, k - 1) && j1 >= 0; --j1) {
        }
        this.func_150516_a(world, i - 2, j1 + 1, k - 1, Blocks.field_150407_cf, 1);
        return true;
    }

    private boolean generateFacingNorth(World world, Random random, int i, int j, int k) {
        int j1;
        for (j1 = j; j1 <= j + 3; ++j1) {
            this.func_150516_a(world, i, j1, k - 3, this.plankBlock, this.plankMeta);
            this.func_150516_a(world, i, j1, k - 2, Blocks.field_150468_ap, 3);
        }
        for (j1 = j - 1; !LOTRMod.isOpaque(world, i, j1, k - 3) && j1 >= 0; --j1) {
            this.func_150516_a(world, i, j1, k - 3, this.plankBlock, this.plankMeta);
        }
        for (j1 = j - 1; !LOTRMod.isOpaque(world, i, j1, k - 2) && j1 >= 0; --j1) {
            this.func_150516_a(world, i, j1, k - 2, Blocks.field_150468_ap, 3);
        }
        this.func_150516_a(world, i - 2, j + 1, k - 2, (Block)Blocks.field_150486_ae, 3);
        LOTRChestContents.fillChest(world, random, i - 2, j + 1, k - 2, LOTRChestContents.ROHAN_WATCHTOWER);
        this.func_150516_a(world, i + 2, j + 1, k - 2, LOTRMod.rohirricTable, 0);
        for (int k1 = k - 2; k1 <= k + 2; ++k1) {
            int j2;
            int j12;
            int k2 = Math.abs(k - k1);
            for (j12 = j - 1; !LOTRMod.isOpaque(world, i - 3, j12, k1) && j12 >= 0; --j12) {
                j2 = j - j12;
                if (!(k2 == 2 && j2 % 4 == 1 || k2 == 1 && j2 % 2 == 0) && (k2 != 0 || j2 % 4 != 3)) continue;
                this.func_150516_a(world, i - 3, j12, k1, this.woodBlock, this.woodMeta);
                if (k2 != 0) continue;
                this.func_150516_a(world, i - 2, j12, k1, Blocks.field_150478_aa, 1);
            }
            for (j12 = j - 1; !LOTRMod.isOpaque(world, i + 3, j12, k1) && j12 >= 0; --j12) {
                j2 = j - j12;
                if (!(k2 == 2 && j2 % 4 == 1 || k2 == 1 && j2 % 2 == 0) && (k2 != 0 || j2 % 4 != 3)) continue;
                this.func_150516_a(world, i + 3, j12, k1, this.woodBlock, this.woodMeta);
                if (k2 != 0) continue;
                this.func_150516_a(world, i + 2, j12, k1, Blocks.field_150478_aa, 2);
            }
        }
        for (j1 = j - 1; !LOTRMod.isOpaque(world, i + 2, j1, k - 2) && j1 >= 0; --j1) {
        }
        this.func_150516_a(world, i + 2, j1 + 1, k - 2, (Block)Blocks.field_150486_ae, 4);
        LOTRChestContents.fillChest(world, random, i + 2, j1 + 1, k - 2, LOTRChestContents.ROHAN_WATCHTOWER);
        for (j1 = j - 1; !LOTRMod.isOpaque(world, i + 2, j1, k) && j1 >= 0; --j1) {
        }
        this.func_150516_a(world, i + 2, j1 + 1, k, this.plankBlock, this.plankMeta);
        this.placeBarrel(world, random, i + 2, j1 + 2, k, 4, LOTRMod.mugMead);
        for (j1 = j - 1; !LOTRMod.isOpaque(world, i - 2, j1, k - 1) && j1 >= 0; --j1) {
        }
        this.func_150516_a(world, i - 2, j1 + 1, k - 1, Blocks.field_150407_cf, 2);
        for (j1 = j - 1; !LOTRMod.isOpaque(world, i - 2, j1, k - 2) && j1 >= 0; --j1) {
        }
        this.func_150516_a(world, i - 2, j1 + 1, k - 2, Blocks.field_150407_cf, 2);
        this.func_150516_a(world, i - 2, j1 + 2, k - 2, Blocks.field_150407_cf, 2);
        for (j1 = j - 1; !LOTRMod.isOpaque(world, i - 1, j1, k - 2) && j1 >= 0; --j1) {
        }
        this.func_150516_a(world, i - 1, j1 + 1, k - 2, Blocks.field_150407_cf, 2);
        return true;
    }

    private boolean generateFacingEast(World world, Random random, int i, int j, int k) {
        int j1;
        for (j1 = j; j1 <= j + 3; ++j1) {
            this.func_150516_a(world, i + 3, j1, k, this.plankBlock, this.plankMeta);
            this.func_150516_a(world, i + 2, j1, k, Blocks.field_150468_ap, 4);
        }
        for (j1 = j - 1; !LOTRMod.isOpaque(world, i + 3, j1, k) && j1 >= 0; --j1) {
            this.func_150516_a(world, i + 3, j1, k, this.plankBlock, this.plankMeta);
        }
        for (j1 = j - 1; !LOTRMod.isOpaque(world, i + 2, j1, k) && j1 >= 0; --j1) {
            this.func_150516_a(world, i + 2, j1, k, Blocks.field_150468_ap, 4);
        }
        this.func_150516_a(world, i + 2, j + 1, k - 2, (Block)Blocks.field_150486_ae, 4);
        LOTRChestContents.fillChest(world, random, i + 2, j + 1, k - 2, LOTRChestContents.ROHAN_WATCHTOWER);
        this.func_150516_a(world, i + 2, j + 1, k + 2, LOTRMod.rohirricTable, 0);
        for (int i1 = i - 2; i1 <= i + 2; ++i1) {
            int j2;
            int j12;
            int i2 = Math.abs(i - i1);
            for (j12 = j - 1; !LOTRMod.isOpaque(world, i1, j12, k - 3) && j12 >= 0; --j12) {
                j2 = j - j12;
                if (!(i2 == 2 && j2 % 4 == 1 || i2 == 1 && j2 % 2 == 0) && (i2 != 0 || j2 % 4 != 3)) continue;
                this.func_150516_a(world, i1, j12, k - 3, this.woodBlock, this.woodMeta);
                if (i2 != 0) continue;
                this.func_150516_a(world, i1, j12, k - 2, Blocks.field_150478_aa, 3);
            }
            for (j12 = j - 1; !LOTRMod.isOpaque(world, i1, j12, k + 3) && j12 >= 0; --j12) {
                j2 = j - j12;
                if (!(i2 == 2 && j2 % 4 == 1 || i2 == 1 && j2 % 2 == 0) && (i2 != 0 || j2 % 4 != 3)) continue;
                this.func_150516_a(world, i1, j12, k + 3, this.woodBlock, this.woodMeta);
                if (i2 != 0) continue;
                this.func_150516_a(world, i1, j12, k + 2, Blocks.field_150478_aa, 4);
            }
        }
        for (j1 = j - 1; !LOTRMod.isOpaque(world, i + 2, j1, k + 2) && j1 >= 0; --j1) {
        }
        this.func_150516_a(world, i + 2, j1 + 1, k + 2, (Block)Blocks.field_150486_ae, 2);
        LOTRChestContents.fillChest(world, random, i + 2, j1 + 1, k + 2, LOTRChestContents.ROHAN_WATCHTOWER);
        for (j1 = j - 1; !LOTRMod.isOpaque(world, i, j1, k + 2) && j1 >= 0; --j1) {
        }
        this.func_150516_a(world, i, j1 + 1, k + 2, this.plankBlock, this.plankMeta);
        this.placeBarrel(world, random, i, j1 + 2, k + 2, 2, LOTRMod.mugMead);
        for (j1 = j - 1; !LOTRMod.isOpaque(world, i + 1, j1, k - 2) && j1 >= 0; --j1) {
        }
        this.func_150516_a(world, i + 1, j1 + 1, k - 2, Blocks.field_150407_cf, 3);
        for (j1 = j - 1; !LOTRMod.isOpaque(world, i + 2, j1, k - 2) && j1 >= 0; --j1) {
        }
        this.func_150516_a(world, i + 2, j1 + 1, k - 2, Blocks.field_150407_cf, 3);
        this.func_150516_a(world, i + 2, j1 + 2, k - 2, Blocks.field_150407_cf, 3);
        for (j1 = j - 1; !LOTRMod.isOpaque(world, i + 2, j1, k - 1) && j1 >= 0; --j1) {
        }
        this.func_150516_a(world, i + 2, j1 + 1, k - 1, Blocks.field_150407_cf, 3);
        return true;
    }
}

