/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.structure;

import java.util.Random;
import lotr.common.LOTRFoods;
import lotr.common.LOTRMod;
import lotr.common.block.LOTRBlockFlowerPot;
import lotr.common.block.LOTRBlockMug;
import lotr.common.entity.LOTREntities;
import lotr.common.entity.item.LOTREntityBanner;
import lotr.common.entity.item.LOTREntityBannerWall;
import lotr.common.recipe.LOTRBrewingRecipes;
import lotr.common.tileentity.LOTRTileEntityArmorStand;
import lotr.common.tileentity.LOTRTileEntityBarrel;
import lotr.common.tileentity.LOTRTileEntityMobSpawner;
import lotr.common.tileentity.LOTRTileEntityPlate;
import lotr.common.tileentity.LOTRTileEntitySpawnerChest;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public abstract class LOTRWorldGenStructureBase
extends WorldGenerator {
    public boolean restrictions = true;
    public EntityPlayer usingPlayer = null;
    protected boolean notifyChanges;

    public LOTRWorldGenStructureBase(boolean flag) {
        super(flag);
        this.notifyChanges = flag;
    }

    protected int usingPlayerRotation() {
        return MathHelper.func_76128_c((double)((double)(this.usingPlayer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
    }

    protected void setBlockMetadata(World world, int i, int j, int k, int meta) {
        world.func_72921_c(i, j, k, meta, this.notifyChanges ? 3 : 2);
    }

    protected void placeOrcTorch(World world, int i, int j, int k) {
        this.func_150516_a(world, i, j, k, LOTRMod.orcTorch, 0);
        this.func_150516_a(world, i, j + 1, k, LOTRMod.orcTorch, 1);
    }

    protected void placeMobSpawner(World world, int i, int j, int k, Class entityClass) {
        this.func_150516_a(world, i, j, k, LOTRMod.mobSpawner, 0);
        TileEntity tileentity = world.func_147438_o(i, j, k);
        if (tileentity != null && tileentity instanceof LOTRTileEntityMobSpawner) {
            ((LOTRTileEntityMobSpawner)tileentity).setMobID(LOTREntities.getEntityIDFromClass(entityClass));
        }
    }

    protected void placeSpawnerChest(World world, int i, int j, int k, int meta, Class entityClass) {
        this.func_150516_a(world, i, j, k, LOTRMod.spawnerChest, 0);
        this.setBlockMetadata(world, i, j, k, meta);
        TileEntity tileentity = world.func_147438_o(i, j, k);
        if (tileentity != null && tileentity instanceof LOTRTileEntitySpawnerChest) {
            ((LOTRTileEntitySpawnerChest)tileentity).setMobID(entityClass);
        }
    }

    protected void placePlate(World world, int i, int j, int k, Random random, LOTRFoods foodList) {
        this.placePlate_do(world, i, j, k, random, foodList, false);
    }

    protected void placePlateWithCertainty(World world, int i, int j, int k, Random random, LOTRFoods foodList) {
        this.placePlate_do(world, i, j, k, random, foodList, true);
    }

    private void placePlate_do(World world, int i, int j, int k, Random random, LOTRFoods foodList, boolean certain) {
        TileEntity tileentity;
        if (!certain && random.nextBoolean()) {
            return;
        }
        this.func_150516_a(world, i, j, k, LOTRMod.plateBlock, 0);
        if ((certain || random.nextBoolean()) && (tileentity = world.func_147438_o(i, j, k)) != null && tileentity instanceof LOTRTileEntityPlate) {
            LOTRTileEntityPlate plate = (LOTRTileEntityPlate)tileentity;
            ItemStack food = foodList.getRandomFood(random);
            plate.foodItem = food.func_77973_b();
            plate.foodDamage = food.func_77960_j();
        }
    }

    protected void placeBarrel(World world, Random random, int i, int j, int k, int meta, Item drink) {
        this.func_150516_a(world, i, j, k, LOTRMod.barrel, meta);
        TileEntity tileentity = world.func_147438_o(i, j, k);
        if (tileentity != null && tileentity instanceof LOTRTileEntityBarrel) {
            LOTRTileEntityBarrel barrel = (LOTRTileEntityBarrel)tileentity;
            barrel.barrelMode = LOTRTileEntityBarrel.FULL;
            barrel.func_70299_a(9, new ItemStack(drink, LOTRBrewingRecipes.BARREL_CAPACITY - random.nextInt(LOTRBrewingRecipes.BARREL_CAPACITY / 2), 1 + random.nextInt(3)));
        }
    }

    protected void placeMug(World world, Random random, int i, int j, int k, int meta, Item drink) {
        this.func_150516_a(world, i, j, k, LOTRMod.mugBlock, meta);
        if (random.nextInt(3) != 0) {
            LOTRBlockMug.setMugItem(world, i, j, k, new ItemStack(drink, 1, 1 + random.nextInt(3)));
        }
    }

    protected void placeFlowerPot(World world, int i, int j, int k, ItemStack itemstack) {
        this.func_150516_a(world, i, j, k, LOTRMod.flowerPot, 0);
        LOTRBlockFlowerPot.setPlant(world, i, j, k, itemstack);
    }

    protected void spawnItemFrame(World world, int i, int j, int k, int direction, ItemStack itemstack) {
        EntityItemFrame frame = new EntityItemFrame(world, i, j, k, direction);
        frame.func_82334_a(itemstack);
        world.func_72838_d((Entity)frame);
    }

    protected void placeArmorStand(World world, int i, int j, int k, int direction, ItemStack[] armor) {
        this.func_150516_a(world, i, j, k, LOTRMod.armorStand, direction);
        this.func_150516_a(world, i, j + 1, k, LOTRMod.armorStand, direction | 4);
        TileEntity tileentity = world.func_147438_o(i, j, k);
        if (tileentity != null && tileentity instanceof LOTRTileEntityArmorStand) {
            LOTRTileEntityArmorStand armorStand = (LOTRTileEntityArmorStand)tileentity;
            for (int l = 0; l < armor.length; ++l) {
                armorStand.func_70299_a(l, armor[l]);
            }
        }
    }

    protected void placeBanner(World world, int i, int j, int k, int direction, int type) {
        LOTREntityBanner banner = new LOTREntityBanner(world);
        banner.func_70012_b((double)i + 0.5, j, (double)k + 0.5, (float)direction * 90.0f, 0.0f);
        banner.setBannerType(type);
        world.func_72838_d((Entity)banner);
    }

    protected void placeWallBanner(World world, int i, int j, int k, int direction, int type) {
        LOTREntityBannerWall banner = new LOTREntityBannerWall(world, i, j, k, direction);
        banner.setBannerType(type);
        world.func_72838_d((Entity)banner);
    }

    protected void setGrassToDirt(World world, int i, int j, int k) {
        if (world.func_147439_a(i, j, k) == Blocks.field_150349_c) {
            this.func_150516_a(world, i, j, k, Blocks.field_150346_d, 0);
        }
    }

    protected void setAir(World world, int i, int j, int k) {
        this.func_150516_a(world, i, j, k, Blocks.field_150350_a, 0);
    }

    protected void placeSkull(World world, Random random, int i, int j, int k) {
        this.func_150516_a(world, i, j, k, Blocks.field_150465_bP, 1);
        TileEntity tileentity = world.func_147438_o(i, j, k);
        if (tileentity != null && tileentity instanceof TileEntitySkull) {
            TileEntitySkull skull = (TileEntitySkull)tileentity;
            skull.func_145903_a(random.nextInt(16));
        }
    }
}

