/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.structure;

import java.util.Random;
import lotr.common.LOTRMod;
import lotr.common.world.structure.LOTRChestContents;
import lotr.common.world.structure.LOTRWorldGenStructureBase;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public abstract class LOTRWorldGenTentBase
extends LOTRWorldGenStructureBase {
    protected Block tentBlock;
    protected int tentMeta;
    protected Block floorBlock;
    protected int floorMeta;
    protected Block supportsBlock;
    protected int supportsMeta;
    protected LOTRChestContents chestContents;
    protected boolean hasOrcForge;

    public LOTRWorldGenTentBase(boolean flag) {
        super(flag);
        if (this.isOrcTent()) {
            this.supportsBlock = LOTRMod.fence;
            this.supportsMeta = 3;
        } else {
            this.supportsBlock = Blocks.field_150422_aJ;
            this.supportsMeta = 0;
        }
    }

    protected boolean isOrcTent() {
        return true;
    }

    protected abstract boolean canTentGenerateAt(World var1, int var2, int var3, int var4);

    public boolean func_76484_a(World world, Random random, int i, int j, int k) {
        return this.generateWithSetRotation(world, random, i, j, k, -1);
    }

    public boolean generateWithSetRotation(World world, Random random, int i, int j, int k, int rotation) {
        if (this.restrictions && !this.canTentGenerateAt(world, i, j, k)) {
            return false;
        }
        --j;
        if (rotation == -1) {
            rotation = random.nextInt(4);
            if (!this.restrictions && this.usingPlayer != null) {
                rotation = this.usingPlayerRotation();
            }
        }
        switch (rotation) {
            case 0: {
                return this.generateNorthToSouth(world, random, i, j, k += 4);
            }
            case 1: {
                return this.generateEastToWest(world, random, i -= 4, j, k);
            }
            case 2: {
                return this.generateNorthToSouth(world, random, i, j, k -= 4);
            }
            case 3: {
                return this.generateEastToWest(world, random, i += 4, j, k);
            }
        }
        return false;
    }

    private boolean generateNorthToSouth(World world, Random random, int i, int j, int k) {
        int j1;
        int k1;
        for (int i1 = i - 2; i1 <= i + 2; ++i1) {
            for (k1 = k - 3; k1 <= k + 3; ++k1) {
                int j12;
                if (this.restrictions && !this.canTentGenerateAt(world, i1, j12 = world.func_72976_f(i1, k1), k1)) {
                    return false;
                }
                for (j12 = j; !LOTRMod.isOpaque(world, i1, j12, k1) && j12 >= 0; --j12) {
                    if (this.floorBlock == Blocks.field_150349_c && j12 < j) {
                        this.func_150516_a(world, i1, j12, k1, Blocks.field_150346_d, 0);
                    } else {
                        this.func_150516_a(world, i1, j12, k1, this.floorBlock, this.floorMeta);
                    }
                    if (world.func_147439_a(i1, j12 - 1, k1) != Blocks.field_150349_c) continue;
                    this.func_150516_a(world, i1, j12 - 1, k1, Blocks.field_150346_d, 0);
                }
            }
        }
        for (j1 = j + 1; j1 <= j + 3; ++j1) {
            for (k1 = k - 3; k1 <= k + 3; ++k1) {
                int range = j1 == j + 3 ? 0 : 1;
                for (int i1 = i - range; i1 <= i + range; ++i1) {
                    this.func_150516_a(world, i1, j1, k1, Blocks.field_150350_a, 0);
                }
            }
        }
        for (int k12 = k - 3; k12 <= k + 3; ++k12) {
            this.func_150516_a(world, i - 2, j + 1, k12, this.tentBlock, this.tentMeta);
            this.func_150516_a(world, i + 2, j + 1, k12, this.tentBlock, this.tentMeta);
            this.func_150516_a(world, i - 2, j + 2, k12, this.tentBlock, this.tentMeta);
            this.func_150516_a(world, i + 2, j + 2, k12, this.tentBlock, this.tentMeta);
            this.func_150516_a(world, i - 1, j + 3, k12, this.tentBlock, this.tentMeta);
            this.func_150516_a(world, i + 1, j + 3, k12, this.tentBlock, this.tentMeta);
            this.func_150516_a(world, i, j + 4, k12, this.tentBlock, this.tentMeta);
        }
        for (j1 = j + 1; j1 <= j + 3; ++j1) {
            this.func_150516_a(world, i, j1, k - 3, this.supportsBlock, this.supportsMeta);
            this.func_150516_a(world, i, j1, k + 3, this.supportsBlock, this.supportsMeta);
        }
        if (this.isOrcTent()) {
            this.placeOrcTorch(world, i - 1, j + 1, k - 3);
            this.placeOrcTorch(world, i + 1, j + 1, k - 3);
            this.placeOrcTorch(world, i - 1, j + 1, k + 3);
            this.placeOrcTorch(world, i + 1, j + 1, k + 3);
        } else {
            this.func_150516_a(world, i - 1, j + 1, k - 3, Blocks.field_150478_aa, 5);
            this.func_150516_a(world, i + 1, j + 1, k - 3, Blocks.field_150478_aa, 5);
            this.func_150516_a(world, i - 1, j + 1, k + 3, Blocks.field_150478_aa, 5);
            this.func_150516_a(world, i + 1, j + 1, k + 3, Blocks.field_150478_aa, 5);
        }
        if (random.nextBoolean()) {
            if (this.hasOrcForge) {
                this.func_150516_a(world, i - 1, j + 1, k, LOTRMod.orcForge, 0);
                this.func_150516_a(world, i - 1, j + 1, k - 1, this.supportsBlock, this.supportsMeta);
                this.func_150516_a(world, i - 1, j + 1, k + 1, this.supportsBlock, this.supportsMeta);
            } else {
                this.func_150516_a(world, i - 1, j + 1, k, (Block)Blocks.field_150486_ae, 0);
                LOTRChestContents.fillChest(world, random, i - 1, j + 1, k, this.chestContents);
            }
        } else if (this.hasOrcForge) {
            this.func_150516_a(world, i + 1, j + 1, k, LOTRMod.orcForge, 0);
            this.func_150516_a(world, i + 1, j + 1, k - 1, this.supportsBlock, this.supportsMeta);
            this.func_150516_a(world, i + 1, j + 1, k + 1, this.supportsBlock, this.supportsMeta);
        } else {
            this.func_150516_a(world, i + 1, j + 1, k, (Block)Blocks.field_150486_ae, 0);
            LOTRChestContents.fillChest(world, random, i + 1, j + 1, k, this.chestContents);
        }
        return true;
    }

    private boolean generateEastToWest(World world, Random random, int i, int j, int k) {
        int j1;
        int i1;
        for (int k1 = k - 2; k1 <= k + 2; ++k1) {
            for (i1 = i - 3; i1 <= i + 3; ++i1) {
                int j12;
                if (this.restrictions && !this.canTentGenerateAt(world, i1, j12 = world.func_72976_f(i1, k1), k1)) {
                    return false;
                }
                for (j12 = j; !LOTRMod.isOpaque(world, i1, j12, k1) && j12 >= 0; --j12) {
                    if (this.floorBlock == Blocks.field_150349_c && j12 < j) {
                        this.func_150516_a(world, i1, j12, k1, Blocks.field_150346_d, 0);
                    } else {
                        this.func_150516_a(world, i1, j12, k1, this.floorBlock, this.floorMeta);
                    }
                    if (world.func_147439_a(i1, j12 - 1, k1) != Blocks.field_150349_c) continue;
                    this.func_150516_a(world, i1, j12 - 1, k1, Blocks.field_150346_d, 0);
                }
            }
        }
        for (j1 = j + 1; j1 <= j + 3; ++j1) {
            for (i1 = i - 3; i1 <= i + 3; ++i1) {
                int range = j1 == j + 3 ? 0 : 1;
                for (int k1 = k - range; k1 <= k + range; ++k1) {
                    this.func_150516_a(world, i1, j1, k1, Blocks.field_150350_a, 0);
                }
            }
        }
        for (int i12 = i - 3; i12 <= i + 3; ++i12) {
            this.func_150516_a(world, i12, j + 1, k - 2, this.tentBlock, this.tentMeta);
            this.func_150516_a(world, i12, j + 1, k + 2, this.tentBlock, this.tentMeta);
            this.func_150516_a(world, i12, j + 2, k - 2, this.tentBlock, this.tentMeta);
            this.func_150516_a(world, i12, j + 2, k + 2, this.tentBlock, this.tentMeta);
            this.func_150516_a(world, i12, j + 3, k - 1, this.tentBlock, this.tentMeta);
            this.func_150516_a(world, i12, j + 3, k + 1, this.tentBlock, this.tentMeta);
            this.func_150516_a(world, i12, j + 4, k, this.tentBlock, this.tentMeta);
        }
        for (j1 = j + 1; j1 <= j + 3; ++j1) {
            this.func_150516_a(world, i - 3, j1, k, this.supportsBlock, this.supportsMeta);
            this.func_150516_a(world, i + 3, j1, k, this.supportsBlock, this.supportsMeta);
        }
        if (this.isOrcTent()) {
            this.placeOrcTorch(world, i - 3, j + 1, k - 1);
            this.placeOrcTorch(world, i - 3, j + 1, k + 1);
            this.placeOrcTorch(world, i + 3, j + 1, k - 1);
            this.placeOrcTorch(world, i + 3, j + 1, k + 1);
        } else {
            this.func_150516_a(world, i - 3, j + 1, k - 1, Blocks.field_150478_aa, 5);
            this.func_150516_a(world, i - 3, j + 1, k + 1, Blocks.field_150478_aa, 5);
            this.func_150516_a(world, i + 3, j + 1, k - 1, Blocks.field_150478_aa, 5);
            this.func_150516_a(world, i + 3, j + 1, k + 1, Blocks.field_150478_aa, 5);
        }
        if (random.nextBoolean()) {
            if (this.hasOrcForge) {
                this.func_150516_a(world, i, j + 1, k - 1, LOTRMod.orcForge, 0);
                this.func_150516_a(world, i - 1, j + 1, k - 1, this.supportsBlock, this.supportsMeta);
                this.func_150516_a(world, i + 1, j + 1, k - 1, this.supportsBlock, this.supportsMeta);
            } else {
                this.func_150516_a(world, i, j + 1, k - 1, (Block)Blocks.field_150486_ae, 0);
                LOTRChestContents.fillChest(world, random, i, j + 1, k - 1, this.chestContents);
            }
        } else if (this.hasOrcForge) {
            this.func_150516_a(world, i, j + 1, k + 1, LOTRMod.orcForge, 0);
            this.func_150516_a(world, i - 1, j + 1, k + 1, this.supportsBlock, this.supportsMeta);
            this.func_150516_a(world, i + 1, j + 1, k + 1, this.supportsBlock, this.supportsMeta);
        } else {
            this.func_150516_a(world, i, j + 1, k + 1, (Block)Blocks.field_150486_ae, 0);
            LOTRChestContents.fillChest(world, random, i, j + 1, k + 1, this.chestContents);
        }
        return true;
    }
}

