/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.structure;

import java.util.Random;
import lotr.common.LOTRMod;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.world.structure.LOTRChestContents;
import lotr.common.world.structure.LOTRWorldGenStructureBase;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public abstract class LOTRWorldGenWargPitBase
extends LOTRWorldGenStructureBase {
    protected Block wallBlock;
    protected int wallMeta;
    protected Block groundBlock;
    protected int groundMeta;

    public LOTRWorldGenWargPitBase(boolean flag) {
        super(flag);
    }

    protected abstract boolean canGenerateAt(World var1, int var2, int var3, int var4);

    protected abstract LOTREntityNPC getOrc(World var1);

    protected abstract LOTREntityNPC getWarg(World var1);

    public boolean func_76484_a(World world, Random random, int i, int j, int k) {
        int j1;
        int i1;
        int k1;
        if (this.restrictions && !this.canGenerateAt(world, i, j, k)) {
            return false;
        }
        int rotation = random.nextInt(4);
        int radius = 8;
        int radiusPlusOne = radius + 1;
        if (!this.restrictions && this.usingPlayer != null) {
            rotation = this.usingPlayerRotation();
            switch (rotation) {
                case 0: {
                    k += radiusPlusOne;
                    break;
                }
                case 1: {
                    i -= radiusPlusOne;
                    break;
                }
                case 2: {
                    k -= radiusPlusOne;
                    break;
                }
                case 3: {
                    i += radiusPlusOne;
                }
            }
        }
        if (this.restrictions) {
            int minHeight = j;
            int maxHeight = j;
            for (int i12 = i - radiusPlusOne; i12 <= i + radiusPlusOne; ++i12) {
                for (k1 = k - radiusPlusOne; k1 <= k + radiusPlusOne; ++k1) {
                    int i2 = i12 - i;
                    int k2 = k1 - k;
                    if (i2 * i2 + k2 * k2 > radiusPlusOne * radiusPlusOne) continue;
                    int j12 = world.func_72976_f(i12, k1);
                    if (!this.canGenerateAt(world, i12, j12, k1)) {
                        return false;
                    }
                    if (j12 < minHeight) {
                        minHeight = j12;
                    }
                    if (j12 <= maxHeight) continue;
                    maxHeight = j12;
                }
            }
            if (maxHeight - minHeight > 5) {
                return false;
            }
            j = maxHeight;
        }
        int base = j - 8;
        int wallThresholdMin = (int)(((double)radius - 0.25) * ((double)radius - 0.25));
        int wallThresholdMax = radiusPlusOne * radiusPlusOne;
        for (i1 = i - radiusPlusOne; i1 <= i + radiusPlusOne; ++i1) {
            for (int k12 = k - radiusPlusOne; k12 <= k + radiusPlusOne; ++k12) {
                int j13;
                int i2 = i1 - i;
                int k2 = k12 - k;
                int distSq = i2 * i2 + k2 * k2;
                if (distSq >= wallThresholdMax) continue;
                if (distSq >= wallThresholdMin) {
                    this.func_150516_a(world, i1, j + 3, k12, LOTRMod.fence, 3);
                    this.func_150516_a(world, i1, j + 2, k12, LOTRMod.planks, 3);
                    for (j13 = j + 1; j13 >= base && j13 >= 0; --j13) {
                        this.func_150516_a(world, i1, j13, k12, this.wallBlock, this.wallMeta);
                    }
                    continue;
                }
                for (j13 = j + 3; j13 >= base && j13 >= 0; --j13) {
                    if (j13 == base) {
                        this.func_150516_a(world, i1, j13, k12, this.groundBlock, this.groundMeta);
                        continue;
                    }
                    this.func_150516_a(world, i1, j13, k12, Blocks.field_150350_a, 0);
                }
            }
        }
        this.placeFenceAndTorch(world, i - 1, j - 3, k - radius + 1);
        this.placeFenceAndTorch(world, i + 1, j - 3, k - radius + 1);
        this.placeFenceAndTorch(world, i - 1, j - 3, k + radius - 1);
        this.placeFenceAndTorch(world, i + 1, j - 3, k + radius - 1);
        this.placeFenceAndTorch(world, i - radius + 1, j - 3, k - 1);
        this.placeFenceAndTorch(world, i - radius + 1, j - 3, k + 1);
        this.placeFenceAndTorch(world, i + radius - 1, j - 3, k - 1);
        this.placeFenceAndTorch(world, i + radius - 1, j - 3, k + 1);
        if (rotation == 0) {
            k1 = k - radius;
            this.func_150516_a(world, i, j + 3, k1, Blocks.field_150396_be, 0);
            for (j1 = j + 2; !LOTRMod.isOpaque(world, i, j1, k1 - 1) && j1 >= 0; --j1) {
                this.func_150516_a(world, i, j1, k1 - 1, Blocks.field_150468_ap, 2);
            }
            for (j1 = j + 2; !LOTRMod.isOpaque(world, i, j1, k1 + 1) && j1 >= 0; --j1) {
                this.func_150516_a(world, i, j1, k1 + 1, Blocks.field_150468_ap, 3);
            }
            this.func_150516_a(world, i, base + 1, k + radius - 1, (Block)Blocks.field_150486_ae, 0);
            LOTRChestContents.fillChest(world, random, i, base + 1, k + radius - 1, LOTRChestContents.WARG_PIT);
        }
        if (rotation == 1) {
            i1 = i + radius;
            this.func_150516_a(world, i1, j + 3, k, Blocks.field_150396_be, 1);
            for (j1 = j + 2; !LOTRMod.isOpaque(world, i1 - 1, j1, k) && j1 >= 0; --j1) {
                this.func_150516_a(world, i1 - 1, j1, k, Blocks.field_150468_ap, 4);
            }
            for (j1 = j + 2; !LOTRMod.isOpaque(world, i1 + 1, j1, k) && j1 >= 0; --j1) {
                this.func_150516_a(world, i1 + 1, j1, k, Blocks.field_150468_ap, 5);
            }
            this.func_150516_a(world, i - radius + 1, base + 1, k, (Block)Blocks.field_150486_ae, 0);
            LOTRChestContents.fillChest(world, random, i - radius + 1, base + 1, k, LOTRChestContents.WARG_PIT);
        }
        if (rotation == 2) {
            k1 = k + radius;
            this.func_150516_a(world, i, j + 3, k1, Blocks.field_150396_be, 2);
            for (j1 = j + 2; !LOTRMod.isOpaque(world, i, j1, k1 - 1) && j1 >= 0; --j1) {
                this.func_150516_a(world, i, j1, k1 - 1, Blocks.field_150468_ap, 2);
            }
            for (j1 = j + 2; !LOTRMod.isOpaque(world, i, j1, k1 + 1) && j1 >= 0; --j1) {
                this.func_150516_a(world, i, j1, k1 + 1, Blocks.field_150468_ap, 3);
            }
            this.func_150516_a(world, i, base + 1, k - radius + 1, (Block)Blocks.field_150486_ae, 0);
            LOTRChestContents.fillChest(world, random, i, base + 1, k - radius + 1, LOTRChestContents.WARG_PIT);
        }
        if (rotation == 3) {
            i1 = i - radius;
            this.func_150516_a(world, i1, j + 3, k, Blocks.field_150396_be, 3);
            for (j1 = j + 2; !LOTRMod.isOpaque(world, i1 - 1, j1, k) && j1 >= 0; --j1) {
                this.func_150516_a(world, i1 - 1, j1, k, Blocks.field_150468_ap, 4);
            }
            for (j1 = j + 2; !LOTRMod.isOpaque(world, i1 + 1, j1, k) && j1 >= 0; --j1) {
                this.func_150516_a(world, i1 + 1, j1, k, Blocks.field_150468_ap, 5);
            }
            this.func_150516_a(world, i + radius - 1, base + 1, k, (Block)Blocks.field_150486_ae, 0);
            LOTRChestContents.fillChest(world, random, i + radius - 1, base + 1, k, LOTRChestContents.WARG_PIT);
        }
        int wargs = 2 + random.nextInt(5);
        for (int l = 0; l < wargs; ++l) {
            LOTREntityNPC warg = this.getWarg(world);
            warg.func_70012_b((double)i + 0.5, base + 1, (double)k + 0.5, 0.0f, 0.0f);
            warg.isNPCPersistent = true;
            warg.func_110161_a(null);
            warg.func_110171_b(i, base, k, 8);
            world.func_72838_d((Entity)warg);
        }
        LOTREntityNPC orc = this.getOrc(world);
        orc.func_70012_b((double)i + 0.5, base + 1, (double)k + 0.5, 0.0f, 0.0f);
        orc.isNPCPersistent = true;
        orc.func_110161_a(null);
        orc.func_70062_b(0, new ItemStack(Items.field_151058_ca));
        orc.func_110171_b(i, base, k, 8);
        world.func_72838_d((Entity)orc);
        return true;
    }

    private void placeFenceAndTorch(World world, int i, int j, int k) {
        this.func_150516_a(world, i, j, k, LOTRMod.fence, 3);
        this.placeOrcTorch(world, i, j + 1, k);
    }
}

