/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.structure2;

import java.util.Random;
import lotr.common.LOTRFoods;
import lotr.common.LOTRMod;
import lotr.common.block.LOTRBlockArmorStand;
import lotr.common.block.LOTRBlockBarrel;
import lotr.common.block.LOTRBlockDwarvenForge;
import lotr.common.block.LOTRBlockFlowerPot;
import lotr.common.block.LOTRBlockHobbitOven;
import lotr.common.block.LOTRBlockMug;
import lotr.common.block.LOTRBlockOrcForge;
import lotr.common.entity.LOTREntities;
import lotr.common.entity.item.LOTREntityBanner;
import lotr.common.entity.item.LOTREntityBannerWall;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.recipe.LOTRBrewingRecipes;
import lotr.common.tileentity.LOTRTileEntityArmorStand;
import lotr.common.tileentity.LOTRTileEntityBarrel;
import lotr.common.tileentity.LOTRTileEntityMobSpawner;
import lotr.common.tileentity.LOTRTileEntityPlate;
import lotr.common.tileentity.LOTRTileEntitySpawnerChest;
import lotr.common.world.structure.LOTRChestContents;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockRotatedPillar;
import net.minecraft.block.BlockSkull;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.Direction;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public abstract class LOTRWorldGenStructureBase2
extends WorldGenerator {
    public boolean restrictions = true;
    public EntityPlayer usingPlayer = null;
    protected boolean notifyChanges;
    private int rotationMode;
    protected int originX;
    protected int originY;
    protected int originZ;

    public LOTRWorldGenStructureBase2(boolean flag) {
        super(flag);
        this.notifyChanges = flag;
    }

    protected int usingPlayerRotation() {
        return MathHelper.func_76128_c((double)((double)(this.usingPlayer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
    }

    protected void setRotationMode(int i) {
        this.rotationMode = i;
    }

    public int getRotationMode() {
        return this.rotationMode;
    }

    protected void setOrigin(int i, int j, int k) {
        this.originX = i;
        this.originY = j;
        this.originZ = k;
    }

    protected void setBlockAndMetadata(World world, int i, int j, int k, Block block, int meta) {
        int i1 = i;
        int k1 = k;
        i = this.getX(i1, k1);
        k = this.getZ(i1, k1);
        j = this.getY(j);
        meta = this.rotateMeta(block, meta);
        super.func_150516_a(world, i, j, k, block, meta);
        if (meta != 0 && (block instanceof BlockChest || block instanceof BlockFurnace)) {
            world.func_72921_c(i, j, k, meta, this.notifyChanges ? 3 : 2);
        }
    }

    private int rotateMeta(Block block, int meta) {
        if (block instanceof BlockRotatedPillar) {
            int i = meta & 3;
            int j = meta & 0xC;
            if (j == 0) {
                return meta;
            }
            if (this.rotationMode == 0 || this.rotationMode == 2) {
                return meta;
            }
            if (j == 4) {
                j = 8;
            } else if (j == 8) {
                j = 4;
            }
            return j | i;
        }
        if (block instanceof BlockStairs) {
            int i = meta & 3;
            int j = meta & 4;
            for (int l = 0; l < this.rotationMode; ++l) {
                if (i == 2) {
                    i = 1;
                    continue;
                }
                if (i == 1) {
                    i = 3;
                    continue;
                }
                if (i == 3) {
                    i = 0;
                    continue;
                }
                if (i != 0) continue;
                i = 2;
            }
            return j | i;
        }
        if (block instanceof LOTRBlockMug || block instanceof LOTRBlockArmorStand) {
            int i = meta;
            for (int l = 0; l < this.rotationMode; ++l) {
                i = Direction.field_71577_f[i];
            }
            return i;
        }
        if (block == Blocks.field_150444_as || block instanceof BlockLadder || block instanceof BlockFurnace || block instanceof BlockChest || block instanceof LOTRBlockBarrel || block instanceof LOTRBlockHobbitOven || block instanceof LOTRBlockDwarvenForge || block instanceof LOTRBlockOrcForge) {
            if (meta == 0 && (block instanceof BlockFurnace || block instanceof BlockChest)) {
                return meta;
            }
            int i = meta;
            for (int l = 0; l < this.rotationMode; ++l) {
                if (i == 2) {
                    i = 5;
                    continue;
                }
                if (i == 5) {
                    i = 3;
                    continue;
                }
                if (i == 3) {
                    i = 4;
                    continue;
                }
                if (i != 4) continue;
                i = 2;
            }
            return i;
        }
        if (block instanceof BlockBed) {
            boolean flag;
            int i = meta;
            boolean bl = flag = meta >= 8;
            if (flag) {
                i -= 8;
            }
            for (int l = 0; l < this.rotationMode; ++l) {
                i = Direction.field_71577_f[i];
            }
            if (flag) {
                i += 8;
            }
            return i;
        }
        if (block instanceof BlockTorch) {
            if (meta == 5) {
                return 5;
            }
            int i = meta;
            for (int l = 0; l < this.rotationMode; ++l) {
                if (i == 4) {
                    i = 1;
                    continue;
                }
                if (i == 1) {
                    i = 3;
                    continue;
                }
                if (i == 3) {
                    i = 2;
                    continue;
                }
                if (i != 2) continue;
                i = 4;
            }
            return i;
        }
        if (block instanceof BlockDoor) {
            if ((meta & 8) != 0) {
                return meta;
            }
            int i = meta;
            for (int l = 0; l < this.rotationMode; ++l) {
                i = Direction.field_71577_f[i];
            }
            return i;
        }
        if (block instanceof BlockTrapDoor) {
            int i = meta & 3;
            int j = meta & 8;
            for (int l = 0; l < this.rotationMode; ++l) {
                if (i == 0) {
                    i = 3;
                    continue;
                }
                if (i == 1) {
                    i = 2;
                    continue;
                }
                if (i == 2) {
                    i = 0;
                    continue;
                }
                if (i != 3) continue;
                i = 1;
            }
            return j | i;
        }
        if (block instanceof BlockFenceGate) {
            int i = meta;
            for (int l = 0; l < this.rotationMode; ++l) {
                i = Direction.field_71577_f[i];
            }
            return i;
        }
        if (block instanceof BlockSkull) {
            if (meta < 2) {
                return meta;
            }
            int i = Direction.field_71579_d[meta];
            for (int l = 0; l < this.rotationMode; ++l) {
                i = Direction.field_71577_f[i];
            }
            return Direction.field_71582_c[i];
        }
        return meta;
    }

    private int indexInArray(int value, int[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            return i;
        }
        return -1;
    }

    protected Block getBlock(World world, int i, int j, int k) {
        int i1 = i;
        int k1 = k;
        i = this.getX(i1, k1);
        k = this.getZ(i1, k1);
        j = this.getY(j);
        return world.func_147439_a(i, j, k);
    }

    protected int getMeta(World world, int i, int j, int k) {
        int i1 = i;
        int k1 = k;
        i = this.getX(i1, k1);
        k = this.getZ(i1, k1);
        j = this.getY(j);
        return world.func_72805_g(i, j, k);
    }

    protected int getTopBlock(World world, int i, int k) {
        int i1 = i;
        int k1 = k;
        i = this.getX(i1, k1);
        k = this.getZ(i1, k1);
        return world.func_72825_h(i, k) - this.originY;
    }

    protected boolean isAir(World world, int i, int j, int k) {
        return this.getBlock(world, i, j, k).func_149688_o() == Material.field_151579_a;
    }

    protected boolean isOpaque(World world, int i, int j, int k) {
        return this.getBlock(world, i, j, k).func_149662_c();
    }

    protected TileEntity getTileEntity(World world, int i, int j, int k) {
        int i1 = i;
        int k1 = k;
        i = this.getX(i1, k1);
        k = this.getZ(i1, k1);
        j = this.getY(j);
        return world.func_147438_o(i, j, k);
    }

    protected void fillChest(World world, Random random, int i, int j, int k, LOTRChestContents contents) {
        int i1 = i;
        int k1 = k;
        i = this.getX(i1, k1);
        k = this.getZ(i1, k1);
        j = this.getY(j);
        LOTRChestContents.fillChest(world, random, i, j, k, contents);
    }

    protected void placeOrcTorch(World world, int i, int j, int k) {
        this.setBlockAndMetadata(world, i, j, k, LOTRMod.orcTorch, 0);
        this.setBlockAndMetadata(world, i, j, k, LOTRMod.orcTorch, 1);
    }

    protected void placeMobSpawner(World world, int i, int j, int k, Class entityClass) {
        this.setBlockAndMetadata(world, i, j, k, LOTRMod.mobSpawner, 0);
        TileEntity tileentity = this.getTileEntity(world, i, j, k);
        if (tileentity != null && tileentity instanceof LOTRTileEntityMobSpawner) {
            ((LOTRTileEntityMobSpawner)tileentity).setMobID(LOTREntities.getEntityIDFromClass(entityClass));
        }
    }

    protected void placeSpawnerChest(World world, int i, int j, int k, int meta, Class entityClass) {
        this.setBlockAndMetadata(world, i, j, k, LOTRMod.spawnerChest, 0);
        this.setBlockAndMetadata(world, i, j, k, LOTRMod.spawnerChest, meta);
        TileEntity tileentity = this.getTileEntity(world, i, j, k);
        if (tileentity != null && tileentity instanceof LOTRTileEntitySpawnerChest) {
            ((LOTRTileEntitySpawnerChest)tileentity).setMobID(entityClass);
        }
    }

    protected void placePlate(World world, int i, int j, int k, Random random, LOTRFoods foodList) {
        this.placePlate_do(world, i, j, k, random, foodList, false);
    }

    protected void placePlateWithCertainty(World world, int i, int j, int k, Random random, LOTRFoods foodList) {
        this.placePlate_do(world, i, j, k, random, foodList, true);
    }

    private void placePlate_do(World world, int i, int j, int k, Random random, LOTRFoods foodList, boolean certain) {
        TileEntity tileentity;
        if (!certain && random.nextBoolean()) {
            return;
        }
        this.setBlockAndMetadata(world, i, j, k, LOTRMod.plateBlock, 0);
        if ((certain || random.nextBoolean()) && (tileentity = this.getTileEntity(world, i, j, k)) != null && tileentity instanceof LOTRTileEntityPlate) {
            LOTRTileEntityPlate plate = (LOTRTileEntityPlate)tileentity;
            ItemStack food = foodList.getRandomFood(random);
            plate.foodItem = food.func_77973_b();
            plate.foodDamage = food.func_77960_j();
        }
    }

    protected void placeBarrel(World world, Random random, int i, int j, int k, int meta, Item drink) {
        this.setBlockAndMetadata(world, i, j, k, LOTRMod.barrel, meta);
        TileEntity tileentity = this.getTileEntity(world, i, j, k);
        if (tileentity != null && tileentity instanceof LOTRTileEntityBarrel) {
            LOTRTileEntityBarrel barrel = (LOTRTileEntityBarrel)tileentity;
            barrel.barrelMode = LOTRTileEntityBarrel.FULL;
            barrel.func_70299_a(9, new ItemStack(drink, LOTRBrewingRecipes.BARREL_CAPACITY - random.nextInt(LOTRBrewingRecipes.BARREL_CAPACITY / 2), 1 + random.nextInt(3)));
        }
    }

    protected void placeMug(World world, Random random, int i, int j, int k, int meta, Item drink) {
        this.setBlockAndMetadata(world, i, j, k, LOTRMod.mugBlock, meta);
        if (random.nextInt(3) != 0) {
            int i1 = i;
            int k1 = k;
            i = this.getX(i1, k1);
            k = this.getZ(i1, k1);
            j = this.getY(j);
            LOTRBlockMug.setMugItem(world, i, j, k, new ItemStack(drink, 1, 1 + random.nextInt(3)));
        }
    }

    protected void placeFlowerPot(World world, int i, int j, int k, ItemStack itemstack) {
        this.setBlockAndMetadata(world, i, j, k, LOTRMod.flowerPot, 0);
        int i1 = i;
        int k1 = k;
        i = this.getX(i1, k1);
        k = this.getZ(i1, k1);
        j = this.getY(j);
        LOTRBlockFlowerPot.setPlant(world, i, j, k, itemstack);
    }

    protected void spawnItemFrame(World world, int i, int j, int k, int direction, ItemStack itemstack) {
        int i1 = i;
        int k1 = k;
        i = this.getX(i1, k1);
        k = this.getZ(i1, k1);
        j = this.getY(j);
        EntityItemFrame frame = new EntityItemFrame(world, i, j, k, direction);
        frame.func_82334_a(itemstack);
        world.func_72838_d((Entity)frame);
    }

    protected void placeArmorStand(World world, int i, int j, int k, int direction, ItemStack[] armor) {
        this.setBlockAndMetadata(world, i, j, k, LOTRMod.armorStand, direction);
        this.setBlockAndMetadata(world, i, j + 1, k, LOTRMod.armorStand, direction | 4);
        TileEntity tileentity = world.func_147438_o(i, j, k);
        if (tileentity != null && tileentity instanceof LOTRTileEntityArmorStand) {
            LOTRTileEntityArmorStand armorStand = (LOTRTileEntityArmorStand)tileentity;
            for (int l = 0; l < armor.length; ++l) {
                armorStand.func_70299_a(l, armor[l]);
            }
        }
    }

    protected void placeBanner(World world, int i, int j, int k, int direction, int type) {
        int i1 = i;
        int k1 = k;
        i = this.getX(i1, k1);
        k = this.getZ(i1, k1);
        j = this.getY(j);
        for (int l = 0; l < this.rotationMode; ++l) {
            direction = Direction.field_71577_f[direction];
        }
        LOTREntityBanner banner = new LOTREntityBanner(world);
        banner.func_70012_b((double)i + 0.5, j, (double)k + 0.5, (float)direction * 90.0f, 0.0f);
        banner.setBannerType(type);
        world.func_72838_d((Entity)banner);
    }

    protected void placeWallBanner(World world, int i, int j, int k, int direction, int type) {
        int i1 = i;
        int k1 = k;
        i = this.getX(i1, k1);
        k = this.getZ(i1, k1);
        j = this.getY(j);
        for (int l = 0; l < this.rotationMode; ++l) {
            direction = Direction.field_71577_f[direction];
        }
        LOTREntityBannerWall banner = new LOTREntityBannerWall(world, i, j, k, direction);
        banner.setBannerType(type);
        world.func_72838_d((Entity)banner);
    }

    protected void setGrassToDirt(World world, int i, int j, int k) {
        if (this.getBlock(world, i, j, k) == Blocks.field_150349_c) {
            this.setBlockAndMetadata(world, i, j, k, Blocks.field_150346_d, 0);
        }
    }

    protected void setAir(World world, int i, int j, int k) {
        this.setBlockAndMetadata(world, i, j, k, Blocks.field_150350_a, 0);
    }

    protected void placeSkull(World world, Random random, int i, int j, int k) {
        this.setBlockAndMetadata(world, i, j, k, Blocks.field_150465_bP, 1);
        TileEntity tileentity = this.getTileEntity(world, i, j, k);
        if (tileentity != null && tileentity instanceof TileEntitySkull) {
            TileEntitySkull skull = (TileEntitySkull)tileentity;
            skull.func_145903_a(random.nextInt(16));
        }
    }

    protected void spawnNPCAndSetHome(EntityCreature entity, World world, int i, int j, int k, int homeDistance) {
        int i1 = i;
        int k1 = k;
        i = this.getX(i1, k1);
        k = this.getZ(i1, k1);
        j = this.getY(j);
        entity.func_70012_b((double)i + 0.5, (double)j, (double)k + 0.5, 0.0f, 0.0f);
        entity.func_110161_a(null);
        if (entity instanceof LOTREntityNPC) {
            ((LOTREntityNPC)entity).isNPCPersistent = true;
        }
        world.func_72838_d((Entity)entity);
        entity.func_110171_b(i, j, k, homeDistance);
    }

    protected int getX(int x, int z) {
        switch (this.rotationMode) {
            case 0: {
                return this.originX - x;
            }
            case 1: {
                return this.originX - z;
            }
            case 2: {
                return this.originX + x;
            }
            case 3: {
                return this.originX + z;
            }
        }
        return this.originX;
    }

    protected int getZ(int x, int z) {
        switch (this.rotationMode) {
            case 0: {
                return this.originZ + z;
            }
            case 1: {
                return this.originZ - x;
            }
            case 2: {
                return this.originZ - z;
            }
            case 3: {
                return this.originZ + x;
            }
        }
        return this.originZ;
    }

    protected int getY(int y) {
        return this.originY + y;
    }
}

