/*
 * Decompiled with CFR 0.152.
 */
package Zyldra.CC2.Entity.mob;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInvBasic;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class EntityMount
extends EntityAnimal
implements IInvBasic {
    private static final IEntitySelector horseBreedingSelector = new IEntitySelector(){
        private static final String __OBFID = "CL_00001642";

        public boolean func_82704_a(Entity par1Entity) {
            return false;
        }
    };
    private static final IAttribute horseJumpStrength = new RangedAttribute("horse.jumpStrength", 0.7, 0.0, 2.0).func_111117_a("Jump Strength").func_111112_a(true);
    private static final String[] horseArmorTextures = new String[]{null, "textures/entity/horse/armor/horse_armor_iron.png", "textures/entity/horse/armor/horse_armor_gold.png", "textures/entity/horse/armor/horse_armor_diamond.png"};
    private static final String[] field_110273_bx = new String[]{"", "meo", "goo", "dio"};
    private static final int[] armorValues = new int[]{0, 5, 7, 11};
    private static final String[] horseTextures = new String[]{"textures/entity/horse/horse_white.png", "textures/entity/horse/horse_creamy.png", "textures/entity/horse/horse_chestnut.png", "textures/entity/horse/horse_brown.png", "textures/entity/horse/horse_black.png", "textures/entity/horse/horse_gray.png", "textures/entity/horse/horse_darkbrown.png"};
    private static final String[] field_110269_bA = new String[]{"hwh", "hcr", "hch", "hbr", "hbl", "hgr", "hdb"};
    private static final String[] horseMarkingTextures = new String[]{null, "textures/entity/horse/horse_markings_white.png", "textures/entity/horse/horse_markings_whitefield.png", "textures/entity/horse/horse_markings_whitedots.png", "textures/entity/horse/horse_markings_blackdots.png"};
    private static final String[] field_110292_bC = new String[]{"", "wo_", "wmo", "wdo", "bdo"};
    private int eatingHaystackCounter;
    private int openMouthCounter;
    private int jumpRearingCounter;
    public int field_110278_bp;
    public int field_110279_bq;
    protected boolean horseJumping;
    private boolean hasReproduced;
    protected int temper;
    protected float jumpPower;
    private boolean field_110294_bI;
    private float headLean;
    private float prevHeadLean;
    private float rearingAmount;
    private float prevRearingAmount;
    private float mouthOpenness;
    private float prevMouthOpenness;
    private int field_110285_bP;
    private String field_110286_bQ;
    private String[] field_110280_bR = new String[3];
    private static final String __OBFID = "CL_00001641";
    private static int armor = 0;

    public EntityMount(World par1World) {
        super(par1World);
        this.func_70105_a(1.4f, 1.6f);
        this.field_70178_ae = false;
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.2));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.7));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.setHorseWatchableBoolean(2, true);
        this.setHorseWatchableBoolean(4, true);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(19, (Object)0);
        this.field_70180_af.func_75682_a(20, (Object)0);
        this.field_70180_af.func_75682_a(21, (Object)String.valueOf(""));
        this.field_70180_af.func_75682_a(22, (Object)0);
    }

    public void setHorseType(int par1) {
        this.field_70180_af.func_75692_b(19, (Object)((byte)par1));
        this.func_110230_cF();
    }

    public int getHorseType() {
        return this.field_70180_af.func_75683_a(19);
    }

    public void setHorseVariant(int par1) {
        this.field_70180_af.func_75692_b(20, (Object)par1);
        this.func_110230_cF();
    }

    public int getHorseVariant() {
        return this.field_70180_af.func_75679_c(20);
    }

    public String func_70005_c_() {
        if (this.func_94056_bM()) {
            return this.func_94057_bL();
        }
        int i = this.getHorseType();
        switch (i) {
            default: {
                return StatCollector.func_74838_a((String)"entity.horse.name");
            }
            case 1: {
                return StatCollector.func_74838_a((String)"entity.donkey.name");
            }
            case 2: {
                return StatCollector.func_74838_a((String)"entity.mule.name");
            }
            case 3: {
                return StatCollector.func_74838_a((String)"entity.zombiehorse.name");
            }
            case 4: 
        }
        return StatCollector.func_74838_a((String)"entity.skeletonhorse.name");
    }

    private boolean getHorseWatchableBoolean(int par1) {
        return (this.field_70180_af.func_75679_c(16) & par1) != 0;
    }

    private void setHorseWatchableBoolean(int par1, boolean par2) {
        int j = this.field_70180_af.func_75679_c(16);
        if (par2) {
            this.field_70180_af.func_75692_b(16, (Object)(j | par1));
        } else {
            this.field_70180_af.func_75692_b(16, (Object)(j & ~par1));
        }
    }

    public boolean isAdultHorse() {
        return true;
    }

    public boolean isTame() {
        return this.getHorseWatchableBoolean(2);
    }

    public boolean func_110253_bW() {
        return this.isAdultHorse();
    }

    public String getOwnerName() {
        return this.field_70180_af.func_75681_e(21);
    }

    public void setOwnerName(String par1Str) {
        this.field_70180_af.func_75692_b(21, (Object)par1Str);
    }

    public float getHorseSize() {
        int i = this.func_70874_b();
        return i >= 0 ? 1.0f : 0.5f + (float)(-24000 - i) / -24000.0f * 0.5f;
    }

    public void func_98054_a(boolean par1) {
        if (par1) {
            this.func_98055_j(this.getHorseSize());
        } else {
            this.func_98055_j(1.0f);
        }
    }

    public boolean isHorseJumping() {
        return this.horseJumping;
    }

    public void setHorseJumping(boolean par1) {
        this.horseJumping = par1;
    }

    public boolean func_110164_bC() {
        return !this.func_110256_cu() && super.func_110164_bC();
    }

    protected void func_142017_o(float par1) {
        if (par1 > 6.0f && this.isEatingHaystack()) {
            this.setEatingHaystack(false);
        }
    }

    public int func_110241_cb() {
        return this.field_70180_af.func_75679_c(22);
    }

    private int getHorseArmorIndex(ItemStack par1ItemStack) {
        if (par1ItemStack == null) {
            return 0;
        }
        Item item = par1ItemStack.func_77973_b();
        return item == Items.field_151138_bX ? 1 : (item == Items.field_151136_bY ? 2 : (item == Items.field_151125_bZ ? 3 : 0));
    }

    public boolean isEatingHaystack() {
        return this.getHorseWatchableBoolean(32);
    }

    public boolean isRearing() {
        return this.getHorseWatchableBoolean(64);
    }

    public boolean getHasReproduced() {
        return this.hasReproduced;
    }

    public void func_146086_d(ItemStack p_146086_1_) {
        this.field_70180_af.func_75692_b(22, (Object)this.getHorseArmorIndex(p_146086_1_));
        this.func_110230_cF();
    }

    public void setHasReproduced(boolean par1) {
        this.hasReproduced = par1;
    }

    public int getTemper() {
        return this.temper;
    }

    public void setTemper(int par1) {
        this.temper = par1;
    }

    public int increaseTemper(int par1) {
        int j = MathHelper.func_76125_a((int)(this.getTemper() + par1), (int)0, (int)this.getMaxTemper());
        this.setTemper(j);
        return j;
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        Entity entity = par1DamageSource.func_76346_g();
        return this.field_70153_n != null && this.field_70153_n.equals((Object)entity) ? false : super.func_70097_a(par1DamageSource, par2);
    }

    public int func_70658_aO() {
        return armorValues[this.func_110241_cb()];
    }

    public boolean func_70104_M() {
        return this.field_70153_n == null;
    }

    public boolean prepareChunkForSpawn() {
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.field_70161_v);
        this.field_70170_p.func_72807_a(i, j);
        return true;
    }

    private void func_110266_cB() {
        this.openHorseMouth();
        this.field_70170_p.func_72956_a((Entity)this, "eating", 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
    }

    protected void func_70069_a(float par1) {
        int i;
        if (par1 > 1.0f) {
            this.func_85030_a("mob.horse.land", 0.4f, 1.0f);
        }
        if ((i = MathHelper.func_76123_f((float)(par1 * 0.5f - 3.0f))) > 0) {
            Block block;
            this.func_70097_a(DamageSource.field_76379_h, i);
            if (this.field_70153_n != null) {
                this.field_70153_n.func_70097_a(DamageSource.field_76379_h, (float)i);
            }
            if ((block = this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - 0.2 - (double)this.field_70126_B)), MathHelper.func_76128_c((double)this.field_70161_v))).func_149688_o() != Material.field_151579_a) {
                Block.SoundType soundtype = block.field_149762_H;
                this.field_70170_p.func_72956_a((Entity)this, soundtype.func_150498_e(), soundtype.func_150497_c() * 0.5f, soundtype.func_150494_d() * 0.75f);
            }
        }
    }

    public void func_76316_a(InventoryBasic par1InventoryBasic) {
        int i = this.func_110241_cb();
        boolean flag = this.isHorseSaddled();
        if (this.field_70173_aa > 20) {
            if (i == 0 && i != this.func_110241_cb()) {
                this.func_85030_a("mob.horse.armor", 0.5f, 1.0f);
            } else if (i != this.func_110241_cb()) {
                this.func_85030_a("mob.horse.armor", 0.5f, 1.0f);
            }
            if (!flag && this.isHorseSaddled()) {
                this.func_85030_a("mob.horse.leather", 0.5f, 1.0f);
            }
        }
    }

    public boolean func_70601_bi() {
        this.prepareChunkForSpawn();
        return super.func_70601_bi();
    }

    protected EntityMount getClosestHorse(Entity par1Entity, double par2) {
        double d1 = Double.MAX_VALUE;
        Entity entity1 = null;
        List list = this.field_70170_p.func_94576_a(par1Entity, par1Entity.field_70121_D.func_72321_a(par2, par2, par2), horseBreedingSelector);
        for (Entity entity2 : list) {
            double d2 = entity2.func_70092_e(par1Entity.field_70165_t, par1Entity.field_70163_u, par1Entity.field_70161_v);
            if (!(d2 < d1)) continue;
            entity1 = entity2;
            d1 = d2;
        }
        return (EntityMount)entity1;
    }

    public double getHorseJumpStrength() {
        return this.func_110148_a(horseJumpStrength).func_111126_e();
    }

    protected String func_70673_aS() {
        this.openHorseMouth();
        int i = this.getHorseType();
        return i == 3 ? "mob.horse.zombie.death" : (i == 4 ? "mob.horse.skeleton.death" : (i != 1 && i != 2 ? "mob.horse.death" : "mob.horse.donkey.death"));
    }

    protected Item func_146068_u() {
        boolean flag = this.field_70146_Z.nextInt(4) == 0;
        int i = this.getHorseType();
        return i == 4 ? Items.field_151103_aS : (i == 3 ? (flag ? Item.func_150899_d((int)0) : Items.field_151078_bh) : Items.field_151116_aA);
    }

    protected String func_70621_aR() {
        int i;
        this.openHorseMouth();
        if (this.field_70146_Z.nextInt(3) == 0) {
            this.makeHorseRear();
        }
        return (i = this.getHorseType()) == 3 ? "mob.horse.zombie.hit" : (i == 4 ? "mob.horse.skeleton.hit" : (i != 1 && i != 2 ? "mob.horse.hit" : "mob.horse.donkey.hit"));
    }

    public boolean isHorseSaddled() {
        return this.getHorseWatchableBoolean(4);
    }

    protected String func_70639_aQ() {
        int i;
        this.openHorseMouth();
        if (this.field_70146_Z.nextInt(10) == 0 && !this.func_70610_aX()) {
            this.makeHorseRear();
        }
        return (i = this.getHorseType()) == 3 ? "mob.horse.zombie.idle" : (i == 4 ? "mob.horse.skeleton.idle" : (i != 1 && i != 2 ? "mob.horse.idle" : "mob.horse.donkey.idle"));
    }

    protected String getAngrySoundName() {
        this.openHorseMouth();
        this.makeHorseRear();
        int i = this.getHorseType();
        return i != 3 && i != 4 ? (i != 1 && i != 2 ? "mob.horse.angry" : "mob.horse.donkey.angry") : null;
    }

    protected void func_145780_a(int p_145780_1_, int p_145780_2_, int p_145780_3_, Block p_145780_4_) {
        Block.SoundType soundtype = p_145780_4_.field_149762_H;
        if (this.field_70170_p.func_147439_a(p_145780_1_, p_145780_2_ + 1, p_145780_3_) == Blocks.field_150431_aC) {
            soundtype = Blocks.field_150431_aC.field_149762_H;
        }
        if (!p_145780_4_.func_149688_o().func_76224_d()) {
            int l = this.getHorseType();
            if (this.field_70153_n != null && l != 1 && l != 2) {
                ++this.field_110285_bP;
                if (this.field_110285_bP > 5 && this.field_110285_bP % 3 == 0) {
                    this.func_85030_a("mob.horse.gallop", soundtype.func_150497_c() * 0.15f, soundtype.func_150494_d());
                    if (l == 0 && this.field_70146_Z.nextInt(10) == 0) {
                        this.func_85030_a("mob.horse.breathe", soundtype.func_150497_c() * 0.6f, soundtype.func_150494_d());
                    }
                } else if (this.field_110285_bP <= 5) {
                    this.func_85030_a("mob.horse.wood", soundtype.func_150497_c() * 0.15f, soundtype.func_150494_d());
                }
            } else if (soundtype == Block.field_149766_f) {
                this.func_85030_a("mob.horse.wood", soundtype.func_150497_c() * 0.15f, soundtype.func_150494_d());
            } else {
                this.func_85030_a("mob.horse.soft", soundtype.func_150497_c() * 0.15f, soundtype.func_150494_d());
            }
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(horseJumpStrength);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(53.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.225f);
    }

    public int func_70641_bl() {
        return 6;
    }

    public int getMaxTemper() {
        return 100;
    }

    protected float func_70599_aP() {
        return 0.8f;
    }

    public int func_70627_aG() {
        return 400;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_110239_cn() {
        return this.getHorseType() == 0 || this.func_110241_cb() > 0;
    }

    private void func_110230_cF() {
        this.field_110286_bQ = null;
    }

    @SideOnly(value=Side.CLIENT)
    private void setHorseTexturePaths() {
        int k;
        this.field_110286_bQ = "horse/";
        this.field_110280_bR[0] = null;
        this.field_110280_bR[1] = null;
        this.field_110280_bR[2] = null;
        int i = this.getHorseType();
        int j = this.getHorseVariant();
        if (i == 0) {
            k = j & 0xFF;
            int l = (j & 0xFF00) >> 8;
            this.field_110280_bR[0] = horseTextures[k];
            this.field_110286_bQ = this.field_110286_bQ + field_110269_bA[k];
            this.field_110280_bR[1] = horseMarkingTextures[l];
            this.field_110286_bQ = this.field_110286_bQ + field_110292_bC[l];
        } else {
            this.field_110280_bR[0] = "";
            this.field_110286_bQ = this.field_110286_bQ + "_" + i + "_";
        }
        k = this.func_110241_cb();
        this.field_110280_bR[2] = horseArmorTextures[k];
        this.field_110286_bQ = this.field_110286_bQ + field_110273_bx[k];
    }

    @SideOnly(value=Side.CLIENT)
    public String getHorseTexture() {
        if (this.field_110286_bQ == null) {
            this.setHorseTexturePaths();
        }
        return this.field_110286_bQ;
    }

    @SideOnly(value=Side.CLIENT)
    public String[] getVariantTexturePaths() {
        if (this.field_110286_bQ == null) {
            this.setHorseTexturePaths();
        }
        return this.field_110280_bR;
    }

    public boolean func_70085_c(EntityPlayer par1EntityPlayer) {
        ItemStack itemstack = par1EntityPlayer.field_71071_by.func_70448_g();
        if (this.func_110253_bW() && this.field_70153_n == null) {
            if (itemstack != null && itemstack.func_111282_a(par1EntityPlayer, (EntityLivingBase)this)) {
                return true;
            }
            this.func_110237_h(par1EntityPlayer);
            return true;
        }
        return super.func_70085_c(par1EntityPlayer);
    }

    private void func_110237_h(EntityPlayer par1EntityPlayer) {
        par1EntityPlayer.field_70177_z = this.field_70177_z;
        par1EntityPlayer.field_70125_A = this.field_70125_A;
        this.setEatingHaystack(false);
        this.setRearing(false);
        if (!this.field_70170_p.field_72995_K) {
            par1EntityPlayer.func_70078_a((Entity)this);
        }
    }

    public boolean func_110259_cr() {
        return this.getHorseType() == 0;
    }

    public boolean func_110229_cs() {
        int i = this.getHorseType();
        return i == 2 || i == 1;
    }

    protected boolean func_70610_aX() {
        return this.field_70153_n != null && this.isHorseSaddled() ? true : this.isEatingHaystack() || this.isRearing();
    }

    public boolean func_110256_cu() {
        int i = this.getHorseType();
        return i == 3 || i == 4;
    }

    public boolean func_110222_cv() {
        return this.func_110256_cu() || this.getHorseType() == 2;
    }

    public boolean func_70877_b(ItemStack par1ItemStack) {
        return false;
    }

    private void func_110210_cH() {
        this.field_110278_bp = 1;
    }

    public void func_70645_a(DamageSource par1DamageSource) {
        if (ForgeHooks.onLivingDeath((EntityLivingBase)this, (DamageSource)par1DamageSource)) {
            return;
        }
        Entity entity = par1DamageSource.func_76346_g();
        EntityLivingBase entitylivingbase = this.func_94060_bK();
        if (this.field_70744_aE >= 0 && entitylivingbase != null) {
            entitylivingbase.func_70084_c((Entity)this, this.field_70744_aE);
        }
        if (entity != null) {
            entity.func_70074_a((EntityLivingBase)this);
        }
        this.field_70729_aU = true;
        this.field_70170_p.func_72960_a((Entity)this, (byte)3);
    }

    public void func_70636_d() {
        if (this.field_70146_Z.nextInt(200) == 0) {
            this.func_110210_cH();
        }
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70146_Z.nextInt(900) == 0 && this.field_70725_aQ == 0) {
                this.func_70691_i(1.0f);
            }
            if (!this.isEatingHaystack() && this.field_70153_n == null && this.field_70146_Z.nextInt(300) == 0 && this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u) - 1, MathHelper.func_76128_c((double)this.field_70161_v)) == Blocks.field_150349_c) {
                this.setEatingHaystack(true);
            }
            if (this.isEatingHaystack() && ++this.eatingHaystackCounter > 50) {
                this.eatingHaystackCounter = 0;
                this.setEatingHaystack(false);
            }
        }
        if (this.field_70153_n == null) {
            this.func_70106_y();
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70180_af.func_75684_a()) {
            this.field_70180_af.func_111144_e();
            this.func_110230_cF();
        }
        if (this.openMouthCounter > 0 && ++this.openMouthCounter > 30) {
            this.openMouthCounter = 0;
            this.setHorseWatchableBoolean(128, false);
        }
        if (!this.field_70170_p.field_72995_K && this.jumpRearingCounter > 0 && ++this.jumpRearingCounter > 20) {
            this.jumpRearingCounter = 0;
            this.setRearing(false);
        }
        if (this.field_110278_bp > 0 && ++this.field_110278_bp > 8) {
            this.field_110278_bp = 0;
        }
        if (this.field_110279_bq > 0) {
            ++this.field_110279_bq;
            if (this.field_110279_bq > 300) {
                this.field_110279_bq = 0;
            }
        }
        this.prevHeadLean = this.headLean;
        if (this.isEatingHaystack()) {
            this.headLean += (1.0f - this.headLean) * 0.4f + 0.05f;
            if (this.headLean > 1.0f) {
                this.headLean = 1.0f;
            }
        } else {
            this.headLean += (0.0f - this.headLean) * 0.4f - 0.05f;
            if (this.headLean < 0.0f) {
                this.headLean = 0.0f;
            }
        }
        this.prevRearingAmount = this.rearingAmount;
        if (this.isRearing()) {
            this.headLean = 0.0f;
            this.prevHeadLean = 0.0f;
            this.rearingAmount += (1.0f - this.rearingAmount) * 0.4f + 0.05f;
            if (this.rearingAmount > 1.0f) {
                this.rearingAmount = 1.0f;
            }
        } else {
            this.field_110294_bI = false;
            this.rearingAmount += (0.8f * this.rearingAmount * this.rearingAmount * this.rearingAmount - this.rearingAmount) * 0.6f - 0.05f;
            if (this.rearingAmount < 0.0f) {
                this.rearingAmount = 0.0f;
            }
        }
        this.prevMouthOpenness = this.mouthOpenness;
        if (this.getHorseWatchableBoolean(128)) {
            this.mouthOpenness += (1.0f - this.mouthOpenness) * 0.7f + 0.05f;
            if (this.mouthOpenness > 1.0f) {
                this.mouthOpenness = 1.0f;
            }
        } else {
            this.mouthOpenness += (0.0f - this.mouthOpenness) * 0.7f - 0.05f;
            if (this.mouthOpenness < 0.0f) {
                this.mouthOpenness = 0.0f;
            }
        }
    }

    private void openHorseMouth() {
        if (!this.field_70170_p.field_72995_K) {
            this.openMouthCounter = 1;
            this.setHorseWatchableBoolean(128, true);
        }
    }

    private boolean func_110200_cJ() {
        return this.field_70153_n == null && this.field_70154_o == null && this.isTame() && this.isAdultHorse() && !this.func_110222_cv() && this.func_110143_aJ() >= this.func_110138_aP();
    }

    public void func_70019_c(boolean par1) {
        this.setHorseWatchableBoolean(32, par1);
    }

    public void setEatingHaystack(boolean par1) {
        this.func_70019_c(par1);
    }

    public void setRearing(boolean par1) {
        if (par1) {
            this.setEatingHaystack(false);
        }
        this.setHorseWatchableBoolean(64, par1);
    }

    private void makeHorseRear() {
        if (!this.field_70170_p.field_72995_K) {
            this.jumpRearingCounter = 1;
            this.setRearing(true);
        }
    }

    public void makeHorseRearWithSound() {
        this.makeHorseRear();
        String s = this.getAngrySoundName();
        if (s != null) {
            this.func_85030_a(s, this.func_70599_aP(), this.func_70647_i());
        }
    }

    public boolean setTamedBy(EntityPlayer par1EntityPlayer) {
        this.setOwnerName(par1EntityPlayer.func_70005_c_());
        return true;
    }

    public void func_70612_e(float par1, float par2) {
        if (this.field_70153_n != null && this.isHorseSaddled()) {
            this.field_70126_B = this.field_70177_z = this.field_70153_n.field_70177_z;
            this.field_70125_A = this.field_70153_n.field_70125_A * 0.5f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            par1 = ((EntityLivingBase)this.field_70153_n).field_70702_br * 0.5f;
            par2 = ((EntityLivingBase)this.field_70153_n).field_70701_bs;
            if (par2 <= 0.0f) {
                par2 *= 0.25f;
                this.field_110285_bP = 0;
            }
            if (this.field_70122_E && this.jumpPower == 0.0f && this.isRearing() && !this.field_110294_bI) {
                par1 = 0.0f;
                par2 = 0.0f;
            }
            if (this.jumpPower > 0.0f && !this.isHorseJumping() && this.field_70122_E) {
                this.field_70181_x = this.getHorseJumpStrength() * (double)this.jumpPower;
                if (this.func_70644_a(Potion.field_76430_j)) {
                    this.field_70181_x += (double)((float)(this.func_70660_b(Potion.field_76430_j).func_76458_c() + 1) * 0.1f);
                }
                this.setHorseJumping(true);
                this.field_70160_al = true;
                if (par2 > 0.0f) {
                    float f2 = MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f));
                    float f3 = MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f));
                    this.field_70159_w += (double)(-0.4f * f2 * this.jumpPower);
                    this.field_70179_y += (double)(0.4f * f3 * this.jumpPower);
                    this.func_85030_a("mob.horse.jump", 0.4f, 1.0f);
                }
                this.jumpPower = 0.0f;
            }
            this.field_70138_W = 1.0f;
            this.field_70747_aH = this.func_70689_ay() * 0.1f;
            if (!this.field_70170_p.field_72995_K) {
                this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                super.func_70612_e(par1, par2);
            }
            if (this.field_70122_E) {
                this.jumpPower = 0.0f;
                this.setHorseJumping(false);
            }
            this.field_70722_aY = this.field_70721_aZ;
            double d1 = this.field_70165_t - this.field_70169_q;
            double d0 = this.field_70161_v - this.field_70166_s;
            float f4 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
            if (f4 > 1.0f) {
                f4 = 1.0f;
            }
            this.field_70721_aZ += (f4 - this.field_70721_aZ) * 0.4f;
            this.field_70754_ba += this.field_70721_aZ;
        } else {
            this.field_70138_W = 0.5f;
            this.field_70747_aH = 0.02f;
            super.func_70612_e(par1, par2);
        }
    }

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74757_a("EatingHaystack", this.isEatingHaystack());
        par1NBTTagCompound.func_74757_a("HasReproduced", this.getHasReproduced());
        par1NBTTagCompound.func_74768_a("Type", this.getHorseType());
        par1NBTTagCompound.func_74768_a("Variant", this.getHorseVariant());
        par1NBTTagCompound.func_74768_a("Temper", this.getTemper());
        par1NBTTagCompound.func_74757_a("Tame", this.isTame());
        par1NBTTagCompound.func_74778_a("OwnerName", this.getOwnerName());
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        ItemStack itemstack;
        IAttributeInstance iattributeinstance;
        super.func_70037_a(par1NBTTagCompound);
        this.setEatingHaystack(par1NBTTagCompound.func_74767_n("EatingHaystack"));
        this.setHasReproduced(par1NBTTagCompound.func_74767_n("HasReproduced"));
        this.setHorseType(par1NBTTagCompound.func_74762_e("Type"));
        this.setHorseVariant(par1NBTTagCompound.func_74762_e("Variant"));
        this.setTemper(par1NBTTagCompound.func_74762_e("Temper"));
        if (par1NBTTagCompound.func_150297_b("OwnerName", 8)) {
            this.setOwnerName(par1NBTTagCompound.func_74779_i("OwnerName"));
        }
        if ((iattributeinstance = this.func_110140_aT().func_111152_a("Speed")) != null) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(iattributeinstance.func_111125_b() * 0.25);
        }
        if (par1NBTTagCompound.func_150297_b("ArmorItem", 10) && (itemstack = ItemStack.func_77949_a((NBTTagCompound)par1NBTTagCompound.func_74775_l("ArmorItem"))) != null && EntityMount.func_146085_a(itemstack.func_77973_b())) {
            this.func_146086_d(itemstack);
        }
    }

    public boolean func_70878_b(EntityAnimal par1EntityAnimal) {
        if (par1EntityAnimal == this) {
            return false;
        }
        if (par1EntityAnimal.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        EntityMount entityhorse = (EntityMount)par1EntityAnimal;
        if (this.func_110200_cJ() && entityhorse.func_110200_cJ()) {
            int j;
            int i = this.getHorseType();
            return i == (j = entityhorse.getHorseType()) || i == 0 && j == 1 || i == 1 && j == 0;
        }
        return false;
    }

    public EntityAgeable func_90011_a(EntityAgeable par1EntityAgeable) {
        EntityMount entityhorse = (EntityMount)par1EntityAgeable;
        EntityMount entityhorse1 = new EntityMount(this.field_70170_p);
        int i = this.getHorseType();
        int j = entityhorse.getHorseType();
        int k = 0;
        if (i == j) {
            k = i;
        } else if (i == 0 && j == 1 || i == 1 && j == 0) {
            k = 2;
        }
        if (k == 0) {
            int i1 = this.field_70146_Z.nextInt(9);
            int l = i1 < 4 ? this.getHorseVariant() & 0xFF : (i1 < 8 ? entityhorse.getHorseVariant() & 0xFF : this.field_70146_Z.nextInt(7));
            int j1 = this.field_70146_Z.nextInt(5);
            l = j1 < 2 ? (l |= this.getHorseVariant() & 0xFF00) : (j1 < 4 ? (l |= entityhorse.getHorseVariant() & 0xFF00) : (l |= this.field_70146_Z.nextInt(5) << 8 & 0xFF00));
            entityhorse1.setHorseVariant(l);
        }
        entityhorse1.setHorseType(k);
        double d1 = this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b() + par1EntityAgeable.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b() + (double)this.func_110267_cL();
        entityhorse1.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(d1 / 3.0);
        double d2 = this.func_110148_a(horseJumpStrength).func_111125_b() + par1EntityAgeable.func_110148_a(horseJumpStrength).func_111125_b() + this.func_110245_cM();
        entityhorse1.func_110148_a(horseJumpStrength).func_111128_a(d2 / 3.0);
        double d0 = this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b() + par1EntityAgeable.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b() + this.func_110203_cN();
        entityhorse1.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(d0 / 3.0);
        return entityhorse1;
    }

    public IEntityLivingData func_110161_a(IEntityLivingData par1EntityLivingData) {
        int l;
        IEntityLivingData p_110161_1_1 = super.func_110161_a(par1EntityLivingData);
        boolean flag = false;
        int i = 0;
        if (p_110161_1_1 instanceof GroupData) {
            l = ((GroupData)p_110161_1_1).field_111107_a;
            i = ((GroupData)p_110161_1_1).field_111106_b & 0xFF | this.field_70146_Z.nextInt(5) << 8;
        } else {
            if (this.field_70146_Z.nextInt(10) == 0) {
                l = 1;
            } else {
                int j = this.field_70146_Z.nextInt(7);
                int k = this.field_70146_Z.nextInt(5);
                l = 0;
                i = j | k << 8;
            }
            p_110161_1_1 = new GroupData(l, i);
        }
        this.setHorseType(l);
        this.setHorseVariant(i);
        if (this.field_70146_Z.nextInt(5) == 0) {
            this.func_70873_a(-24000);
        }
        if (l != 4 && l != 3) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.func_110267_cL());
            if (l == 0) {
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.func_110203_cN());
            } else {
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.175f);
            }
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(15.0);
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.2f);
        }
        if (l != 2 && l != 1) {
            this.func_110148_a(horseJumpStrength).func_111128_a(this.func_110245_cM());
        } else {
            this.func_110148_a(horseJumpStrength).func_111128_a(0.5);
        }
        this.func_70606_j(this.func_110138_aP());
        return p_110161_1_1;
    }

    @SideOnly(value=Side.CLIENT)
    public float getGrassEatingAmount(float par1) {
        return this.prevHeadLean + (this.headLean - this.prevHeadLean) * par1;
    }

    @SideOnly(value=Side.CLIENT)
    public float getRearingAmount(float par1) {
        return this.prevRearingAmount + (this.rearingAmount - this.prevRearingAmount) * par1;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_110201_q(float par1) {
        return this.prevMouthOpenness + (this.mouthOpenness - this.prevMouthOpenness) * par1;
    }

    protected boolean func_70650_aV() {
        return true;
    }

    public void setJumpPower(int par1) {
        if (this.isHorseSaddled()) {
            if (par1 < 0) {
                par1 = 0;
            } else {
                this.field_110294_bI = true;
                this.makeHorseRear();
            }
            this.jumpPower = par1 >= 90 ? 1.0f : 0.4f + 0.4f * (float)par1 / 90.0f;
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void spawnHorseParticles(boolean par1) {
        String s = par1 ? "heart" : "smoke";
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_72869_a(s, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte par1) {
        if (par1 == 7) {
            this.spawnHorseParticles(true);
        } else if (par1 == 6) {
            this.spawnHorseParticles(false);
        } else {
            super.func_70103_a(par1);
        }
    }

    public void func_70043_V() {
        super.func_70043_V();
        if (this.prevRearingAmount > 0.0f) {
            float f = MathHelper.func_76126_a((float)(this.field_70761_aq * (float)Math.PI / 180.0f));
            float f1 = MathHelper.func_76134_b((float)(this.field_70761_aq * (float)Math.PI / 180.0f));
            float f2 = 0.7f * this.prevRearingAmount;
            float f3 = 0.15f * this.prevRearingAmount;
            this.field_70153_n.func_70107_b(this.field_70165_t + (double)(f2 * f), this.field_70163_u + this.func_70042_X() + this.field_70153_n.func_70033_W() + (double)f3, this.field_70161_v - (double)(f2 * f1));
            if (this.field_70153_n instanceof EntityLivingBase) {
                ((EntityLivingBase)this.field_70153_n).field_70761_aq = this.field_70761_aq;
            }
        }
    }

    private float func_110267_cL() {
        return 15.0f + (float)this.field_70146_Z.nextInt(8) + (float)this.field_70146_Z.nextInt(9);
    }

    private double func_110245_cM() {
        return (double)0.4f + this.field_70146_Z.nextDouble() * 0.2 + this.field_70146_Z.nextDouble() * 0.2 + this.field_70146_Z.nextDouble() * 0.2;
    }

    private double func_110203_cN() {
        return ((double)0.45f + this.field_70146_Z.nextDouble() * 0.3 + this.field_70146_Z.nextDouble() * 0.3 + this.field_70146_Z.nextDouble() * 0.3) * 0.25;
    }

    public static boolean func_146085_a(Item p_146085_0_) {
        return p_146085_0_ == Items.field_151138_bX || p_146085_0_ == Items.field_151136_bY || p_146085_0_ == Items.field_151125_bZ;
    }

    public boolean func_70617_f_() {
        return false;
    }

    public static class GroupData
    implements IEntityLivingData {
        public int field_111107_a;
        public int field_111106_b;
        private static final String __OBFID = "CL_00001643";

        public GroupData(int par1, int par2) {
            this.field_111107_a = par1;
            this.field_111106_b = par2;
        }
    }
}

