/*
 * Decompiled with CFR 0.152.
 */
package Zyldra.CC2.plugins;

import Zyldra.CC2.plugins.ICompatPlugin;
import Zyldra.CC2.plugins.NEI.NotEnoughItems;
import cpw.mods.fml.common.Loader;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import net.minecraftforge.common.config.Configuration;

public class PluginController {
    private static PluginController instance;
    private Configuration conf = null;
    private List<ICompatPlugin> plugins = new LinkedList<ICompatPlugin>();
    private Phase currPhase = Phase.PRELAUNCH;

    private PluginController() {
        String path = Loader.instance().getConfigDir().toString() + File.separator + "NaturaCompat.cfg";
        this.conf = new Configuration(new File(path));
    }

    public static PluginController getController() {
        if (instance == null) {
            instance = new PluginController();
        }
        return instance;
    }

    public void registerPlugin(ICompatPlugin plugin) {
        this.conf.load();
        boolean shouldLoad = this.conf.get("Plugins", plugin.getModId(), true).getBoolean(true);
        this.conf.save();
        if (shouldLoad) {
            this.loadPlugin(plugin);
        }
    }

    private void loadPlugin(ICompatPlugin plugin) {
        if (!Loader.isModLoaded((String)plugin.getModId())) {
            return;
        }
        this.plugins.add(plugin);
        switch (this.currPhase) {
            case DONE: 
            case POSTINIT: {
                plugin.preInit();
                plugin.init();
                plugin.postInit();
                break;
            }
            case INIT: {
                plugin.preInit();
                plugin.init();
                break;
            }
            case PREINIT: {
                plugin.preInit();
                break;
            }
        }
    }

    public void preInit() {
        this.currPhase = Phase.PREINIT;
        for (ICompatPlugin pl : this.plugins) {
            pl.preInit();
        }
    }

    public void init() {
        this.currPhase = Phase.INIT;
        for (ICompatPlugin pl : this.plugins) {
            pl.init();
        }
    }

    public void postInit() {
        this.currPhase = Phase.POSTINIT;
        for (ICompatPlugin pl : this.plugins) {
            pl.postInit();
        }
        this.currPhase = Phase.DONE;
    }

    public void registerBuiltins() {
        this.registerPlugin(new NotEnoughItems());
    }

    private static enum Phase {
        PRELAUNCH,
        PREINIT,
        INIT,
        POSTINIT,
        DONE;

    }
}

