/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.IntBuffer;

public class TextureUtils {
    public static final String texGrassTop = "grass_top";
    public static final String texStone = "stone";
    public static final String texDirt = "dirt";
    public static final String texGrassSide = "grass_side";
    public static final String texStoneslabSide = "stone_slab_side";
    public static final String texStoneslabTop = "stone_slab_top";
    public static final String texBedrock = "bedrock";
    public static final String texSand = "sand";
    public static final String texGravel = "gravel";
    public static final String texLogOak = "log_oak";
    public static final String texLogOakTop = "log_oak_top";
    public static final String texGoldOre = "gold_ore";
    public static final String texIronOre = "iron_ore";
    public static final String texCoalOre = "coal_ore";
    public static final String texObsidian = "obsidian";
    public static final String texGrassSideOverlay = "grass_side_overlay";
    public static final String texSnow = "snow";
    public static final String texGrassSideSnowed = "grass_side_snowed";
    public static final String texMyceliumSide = "mycelium_side";
    public static final String texMyceliumTop = "mycelium_top";
    public static final String texDiamondOre = "diamond_ore";
    public static final String texRedstoneOre = "redstone_ore";
    public static final String texLapisOre = "lapis_ore";
    public static final String texLeavesOak = "leaves_oak";
    public static final String texLeavesOakOpaque = "leaves_oak_opaque";
    public static final String texLeavesJungle = "leaves_jungle";
    public static final String texLeavesJungleOpaque = "leaves_jungle_opaque";
    public static final String texCactusSide = "cactus_side";
    public static final String texClay = "clay";
    public static final String texFarmlandWet = "farmland_wet";
    public static final String texFarmlandDry = "farmland_dry";
    public static final String texNetherrack = "netherrack";
    public static final String texSoulSand = "soul_sand";
    public static final String texGlowstone = "glowstone";
    public static final String texLogSpruce = "log_spruce";
    public static final String texLogBirch = "log_birch";
    public static final String texLeavesSpruce = "leaves_spruce";
    public static final String texLeavesSpruceOpaque = "leaves_spruce_opaque";
    public static final String texLogJungle = "log_jungle";
    public static final String texEndStone = "end_stone";
    public static final String texSandstoneTop = "sandstone_top";
    public static final String texSandstoneBottom = "sandstone_bottom";
    public static final String texRedstoneLampOff = "redstone_lamp_off";
    public static final String texRedstoneLampOn = "redstone_lamp_on";
    public static final String texWaterStill = "water_still";
    public static final String texWaterFlow = "water_flow";
    public static final String texLavaStill = "lava_still";
    public static final String texLavaFlow = "lava_flow";
    public static final String texFireLayer0 = "fire_layer_0";
    public static final String texFireLayer1 = "fire_layer_1";
    public static final String texPortal = "portal";
    public static rf iconGrassTop;
    public static rf iconGrassSide;
    public static rf iconGrassSideOverlay;
    public static rf iconSnow;
    public static rf iconGrassSideSnowed;
    public static rf iconMyceliumSide;
    public static rf iconMyceliumTop;
    public static rf iconWaterStill;
    public static rf iconWaterFlow;
    public static rf iconLavaStill;
    public static rf iconLavaFlow;
    public static rf iconPortal;
    public static rf iconFireLayer0;
    public static rf iconFireLayer1;
    private static IntBuffer staticBuffer;

    public static void update() {
        bpz mapBlocks = bpz.textureMapBlocks;
        if (mapBlocks == null) {
            return;
        }
        iconGrassTop = mapBlocks.getIconSafe(texGrassTop);
        iconGrassSide = mapBlocks.getIconSafe(texGrassSide);
        iconGrassSideOverlay = mapBlocks.getIconSafe(texGrassSideOverlay);
        iconSnow = mapBlocks.getIconSafe(texSnow);
        iconGrassSideSnowed = mapBlocks.getIconSafe(texGrassSideSnowed);
        iconMyceliumSide = mapBlocks.getIconSafe(texMyceliumSide);
        iconMyceliumTop = mapBlocks.getIconSafe(texMyceliumTop);
        iconWaterStill = mapBlocks.getIconSafe(texWaterStill);
        iconWaterFlow = mapBlocks.getIconSafe(texWaterFlow);
        iconLavaStill = mapBlocks.getIconSafe(texLavaStill);
        iconLavaFlow = mapBlocks.getIconSafe(texLavaFlow);
        iconFireLayer0 = mapBlocks.getIconSafe(texFireLayer0);
        iconFireLayer1 = mapBlocks.getIconSafe(texFireLayer1);
        iconPortal = mapBlocks.getIconSafe(texPortal);
    }

    public static BufferedImage fixTextureDimensions(String name, BufferedImage bi) {
        int height;
        int width;
        if ((name.startsWith("/mob/zombie") || name.startsWith("/mob/pigzombie")) && (width = bi.getWidth()) == (height = bi.getHeight()) * 2) {
            BufferedImage scaledImage = new BufferedImage(width, height * 2, 2);
            Graphics2D gr = scaledImage.createGraphics();
            gr.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            gr.drawImage(bi, 0, 0, width, height, null);
            return scaledImage;
        }
        return bi;
    }

    public static bqd getTextureAtlasSprite(rf icon) {
        if (icon instanceof bqd) {
            return (bqd)icon;
        }
        return null;
    }

    public static int ceilPowerOfTwo(int val) {
        int i;
        for (i = 1; i < val; i *= 2) {
        }
        return i;
    }

    public static int getPowerOfTwo(int val) {
        int i = 1;
        int po2 = 0;
        while (i < val) {
            i *= 2;
            ++po2;
        }
        return po2;
    }

    public static int twoToPower(int power) {
        int val = 1;
        for (int i = 0; i < power; ++i) {
            val *= 2;
        }
        return val;
    }

    public static void refreshBlockTextures() {
        Config.dbg("*** Reloading block textures ***");
        bpz.textureMapBlocks.loadTextureSafe(Config.getResourceManager());
        TextureUtils.update();
        NaturalTextures.update();
        bpz.textureMapBlocks.d();
    }

    public static bqh getTexture(String path) {
        return TextureUtils.getTexture(new bqx(path));
    }

    public static bqh getTexture(bqx loc) {
        bqh tex = Config.getTextureManager().b(loc);
        if (tex != null) {
            return tex;
        }
        if (!Config.hasResource(loc)) {
            return null;
        }
        tex = new bpu(loc);
        Config.getTextureManager().a(loc, tex);
        return tex;
    }

    public static void resourcesReloaded(bqy rm) {
        if (bpz.textureMapBlocks == null) {
            return;
        }
        Config.dbg("*** Reloading custom textures ***");
        CustomSky.reset();
        TextureAnimations.reset();
        TextureUtils.update();
        NaturalTextures.update();
        TextureAnimations.update();
        CustomColorizer.update();
        CustomSky.update();
        RandomMobs.resetTextures();
        Config.updateTexturePackClouds();
        Config.getTextureManager().e();
    }

    public static void refreshTextureMaps(bqy rm) {
        bpz.textureMapBlocks.loadTextureSafe(rm);
        bpz.textureMapItems.loadTextureSafe(rm);
        TextureUtils.update();
        NaturalTextures.update();
    }

    public static void registerResourceListener() {
        bqy rm = Config.getResourceManager();
        if (rm instanceof bqv) {
            bqv rrm = (bqv)rm;
            bqz rl = new bqz(){

                public void a(bqy var1) {
                    TextureUtils.resourcesReloaded(var1);
                }
            };
            rrm.a(rl);
        }
        bqk tto = new bqk(){

            public void e() {
                TextureAnimations.updateCustomAnimations();
            }

            public void a(bqy var1) throws IOException {
            }

            public int b() {
                return 0;
            }
        };
        bqx ttol = new bqx("optifine/TickableTextures");
        Config.getTextureManager().a(ttol, tto);
    }

    public static String fixResourcePath(String path, String basePath) {
        String strAssMc = "assets/minecraft/";
        if (path.startsWith(strAssMc)) {
            path = path.substring(strAssMc.length());
            return path;
        }
        if (path.startsWith("./")) {
            path = path.substring(2);
            if (!basePath.endsWith("/")) {
                basePath = basePath + "/";
            }
            path = basePath + path;
            return path;
        }
        String strMcpatcher = "mcpatcher/";
        if (path.startsWith("~/")) {
            path = path.substring(2);
            path = strMcpatcher + path;
            return path;
        }
        if (path.startsWith("/")) {
            path = strMcpatcher + path.substring(1);
            return path;
        }
        return path;
    }

    public static String getBasePath(String path) {
        int pos = path.lastIndexOf(47);
        if (pos < 0) {
            return "";
        }
        return path.substring(0, pos);
    }

    static {
        staticBuffer = ban.f((int)256);
    }
}

