/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.lib.config.ConfigTagParent;
import codechicken.nei.ItemList;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.api.API;
import codechicken.nei.api.ItemInfo;
import codechicken.nei.config.GuiItemSorter;
import codechicken.nei.config.OptionOpenGui;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public class ItemSorter
implements Comparator<ItemStack>,
ItemList.ItemsLoadedCallback {
    public static ArrayList<SortEntry> entries = new ArrayList();
    public static ArrayList<SortEntry> list = new ArrayList();
    public static final ItemSorter instance = new ItemSorter();
    public HashMap<ItemStack, Integer> ordering = null;

    public static void sort(ArrayList<ItemStack> items) {
        Collections.sort(items, instance);
    }

    @Override
    public int compare(ItemStack o1, ItemStack o2) {
        for (SortEntry e : list) {
            int c = e.comparator.compare(o1, o2);
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    @Override
    public void itemsLoaded() {
        HashMap<ItemStack, Integer> newMap = new HashMap<ItemStack, Integer>();
        int i = 0;
        for (ItemStack stack : ItemList.items) {
            newMap.put(stack, i++);
        }
        this.ordering = newMap;
    }

    public static String getSaveString() {
        StringBuilder sb = new StringBuilder();
        for (SortEntry e : list) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(e.name);
        }
        return sb.toString();
    }

    public static SortEntry find(String name) {
        for (SortEntry e : entries) {
            if (!e.name.equals(name)) continue;
            return e;
        }
        return null;
    }

    public static int compareInt(int a, int b) {
        return a == b ? 0 : (a < b ? -1 : 1);
    }

    public static void add(String name, Comparator<ItemStack> comparator) {
        SortEntry e = new SortEntry(name, comparator);
        entries.add(e);
        ArrayList<SortEntry> nlist = new ArrayList<SortEntry>(list);
        nlist.add(e);
        list = nlist;
    }

    public static void initConfig(ConfigTagParent tag) {
        API.addSortOption("nei.itemsort.minecraft", new Comparator<ItemStack>(){

            @Override
            public int compare(ItemStack o1, ItemStack o2) {
                boolean m2;
                boolean m1 = "minecraft".equals(ItemInfo.itemOwners.get(o1.func_77973_b()));
                return m1 == (m2 = "minecraft".equals(ItemInfo.itemOwners.get(o2.func_77973_b()))) ? 0 : (m1 ? -1 : 1);
            }
        });
        API.addSortOption("nei.itemsort.mod", new Comparator<ItemStack>(){

            @Override
            public int compare(ItemStack o1, ItemStack o2) {
                String mod1 = ItemInfo.itemOwners.get(o1.func_77973_b());
                String mod2 = ItemInfo.itemOwners.get(o2.func_77973_b());
                if (mod1 == null) {
                    return mod2 == null ? 0 : 1;
                }
                if (mod2 == null) {
                    return -1;
                }
                return mod1.compareTo(mod2);
            }
        });
        API.addSortOption("nei.itemsort.id", new Comparator<ItemStack>(){

            @Override
            public int compare(ItemStack o1, ItemStack o2) {
                int id1 = Item.func_150891_b((Item)o1.func_77973_b());
                int id2 = Item.func_150891_b((Item)o2.func_77973_b());
                return ItemSorter.compareInt(id1, id2);
            }
        });
        API.addSortOption("nei.itemsort.default", new Comparator<ItemStack>(){

            @Override
            public int compare(ItemStack o1, ItemStack o2) {
                Integer order1 = ItemSorter.instance.ordering.get(o1);
                Integer order2 = ItemSorter.instance.ordering.get(o2);
                if (order1 == null) {
                    return order2 == null ? 0 : 1;
                }
                if (order2 == null) {
                    return -1;
                }
                return ItemSorter.compareInt(order1, order2);
            }
        });
        API.addSortOption("nei.itemsort.damage", new Comparator<ItemStack>(){

            @Override
            public int compare(ItemStack o1, ItemStack o2) {
                int id1 = o1.func_77960_j();
                int id2 = o2.func_77960_j();
                return ItemSorter.compareInt(id1, id2);
            }
        });
        API.addSortOption("nei.itemsort.name", new Comparator<ItemStack>(){

            @Override
            public int compare(ItemStack o1, ItemStack o2) {
                String name1 = ItemInfo.getSearchName(o1);
                String name2 = ItemInfo.getSearchName(o2);
                return name1.compareTo(name2);
            }
        });
        tag.getTag("inventory.itemsort").setDefaultValue(ItemSorter.getSaveString());
        API.addOption(new OptionOpenGui("inventory.itemsort", GuiItemSorter.class));
        ItemList.loadCallbacks.add(instance);
    }

    public static void loadConfig() {
        String s = NEIClientConfig.getStringSetting("inventory.itemsort");
        if (s == null) {
            list = new ArrayList<SortEntry>(entries);
        } else {
            ArrayList<SortEntry> nlist = new ArrayList<SortEntry>();
            for (String s2 : s.split(",")) {
                SortEntry e = ItemSorter.find(s2.trim());
                if (e == null) continue;
                nlist.add(e);
            }
            for (SortEntry e : entries) {
                if (nlist.contains(e)) continue;
                nlist.add(e);
            }
            list = nlist;
        }
    }

    public static class SortEntry {
        public String name;
        public Comparator<ItemStack> comparator;

        public SortEntry(String name, Comparator<ItemStack> comparator) {
            this.name = name;
            this.comparator = comparator;
        }

        public String getLocalisedName() {
            return StatCollector.func_74838_a((String)this.name);
        }

        public String getTooltip() {
            String tipname = this.name + ".tip";
            String tip = StatCollector.func_74838_a((String)tipname);
            return !tip.equals(tipname) ? tip : null;
        }
    }
}

