/*
 * Decompiled with CFR 0.152.
 */
package net.vanillaplus.world;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.vanillaplus.common.VanillaPlus;
import net.vanillaplus.helpers.MainConfig;
import net.vanillaplus.world.WorldGenMinableEnd;
import net.vanillaplus.world.WorldGenMinableNether;

public class OreWorldGen
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.field_76574_g) {
            case -1: {
                this.generateNether(world, random, chunkX * 16, chunkZ * 16);
                break;
            }
            case 0: {
                this.generateSurface(world, random, chunkX * 16, chunkZ * 16);
                break;
            }
            case 1: {
                this.generateEnd(world, random, chunkX * 16, chunkZ * 16);
            }
        }
    }

    public void generateNether(World world, Random rand, int chunkX, int chunkZ) {
        if (MainConfig.netherOreBoolean) {
            int randPosZ;
            int randPosY;
            int randPosX;
            int i;
            for (i = 0; i < 14; ++i) {
                randPosX = chunkX + rand.nextInt(16);
                randPosY = rand.nextInt(60);
                randPosZ = chunkZ + rand.nextInt(16);
                new WorldGenMinableNether(VanillaPlus.magmaOre, 4).func_76484_a(world, rand, randPosX, randPosY, randPosZ);
            }
            for (i = 0; i < 13; ++i) {
                randPosX = chunkX + rand.nextInt(16);
                randPosY = rand.nextInt(45);
                randPosZ = chunkZ + rand.nextInt(16);
                new WorldGenMinableNether(VanillaPlus.hellFireOre, 3).func_76484_a(world, rand, randPosX, randPosY, randPosZ);
            }
        }
    }

    public void generateSurface(World world, Random rand, int chunkX, int chunkZ) {
        if (MainConfig.overworldOreBoolean) {
            int randPosZ;
            int randPosY;
            int randPosX;
            int i;
            for (i = 0; i < 20; ++i) {
                randPosX = chunkX + rand.nextInt(16);
                randPosY = rand.nextInt(20);
                randPosZ = chunkZ + rand.nextInt(16);
                new WorldGenMinable(VanillaPlus.xpOre, 3).func_76484_a(world, rand, randPosX, randPosY, randPosZ);
            }
            for (i = 0; i < 10; ++i) {
                randPosX = chunkX + rand.nextInt(16);
                randPosY = rand.nextInt(20);
                randPosZ = chunkZ + rand.nextInt(16);
                new WorldGenMinable(VanillaPlus.rubyOre, 3).func_76484_a(world, rand, randPosX, randPosY, randPosZ);
            }
            for (i = 0; i < 5; ++i) {
                randPosX = chunkX + rand.nextInt(16);
                randPosY = rand.nextInt(15);
                randPosZ = chunkZ + rand.nextInt(16);
                new WorldGenMinable(VanillaPlus.sapphireOre, 3).func_76484_a(world, rand, randPosX, randPosY, randPosZ);
            }
        }
    }

    private void generateEnd(World world, Random rand, int chunkX, int chunkZ) {
        if (MainConfig.endOreBoolean) {
            for (int i = 0; i < 20; ++i) {
                int randPosX = chunkX + rand.nextInt(16);
                int randPosY = rand.nextInt(55);
                int randPosZ = chunkZ + rand.nextInt(16);
                new WorldGenMinableEnd(VanillaPlus.enderCrystalOre, 4).func_76484_a(world, rand, randPosX, randPosY, randPosZ);
            }
        }
    }
}

