/*
 * Decompiled with CFR 0.152.
 */
package buildcraft;

import buildcraft.BuildCraftBuilders;
import buildcraft.BuildCraftEnergy;
import buildcraft.BuildCraftFactory;
import buildcraft.BuildCraftMod;
import buildcraft.BuildCraftSilicon;
import buildcraft.api.blueprints.SchematicRegistry;
import buildcraft.api.core.BCLog;
import buildcraft.api.core.BuildCraftAPI;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.core.JavaTools;
import buildcraft.api.gates.ActionManager;
import buildcraft.api.recipes.BuildcraftRecipes;
import buildcraft.builders.urbanism.EntityRobotUrbanism;
import buildcraft.core.BlockIndex;
import buildcraft.core.BlockSpring;
import buildcraft.core.BuildCraftConfiguration;
import buildcraft.core.CommandBuildCraft;
import buildcraft.core.CoreIconProvider;
import buildcraft.core.InterModComms;
import buildcraft.core.ItemBuildCraft;
import buildcraft.core.ItemSpring;
import buildcraft.core.ItemWrench;
import buildcraft.core.SpringPopulate;
import buildcraft.core.TickHandlerCoreClient;
import buildcraft.core.Version;
import buildcraft.core.network.BuildCraftChannelHandler;
import buildcraft.core.network.PacketHandler;
import buildcraft.core.network.PacketUpdate;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.recipes.AssemblyRecipeManager;
import buildcraft.core.recipes.IntegrationRecipeManager;
import buildcraft.core.recipes.RefineryRecipeManager;
import buildcraft.core.render.BlockHighlightHandler;
import buildcraft.core.robots.EntityRobot;
import buildcraft.core.robots.EntityRobotBuilder;
import buildcraft.core.robots.EntityRobotPicker;
import buildcraft.core.triggers.ActionMachineControl;
import buildcraft.core.triggers.ActionRedstoneOutput;
import buildcraft.core.triggers.ActionTriggerIconProvider;
import buildcraft.core.triggers.BCAction;
import buildcraft.core.triggers.BCTrigger;
import buildcraft.core.triggers.DefaultActionProvider;
import buildcraft.core.triggers.DefaultTriggerProvider;
import buildcraft.core.triggers.TriggerFluidContainer;
import buildcraft.core.triggers.TriggerFluidContainerLevel;
import buildcraft.core.triggers.TriggerInventory;
import buildcraft.core.triggers.TriggerInventoryLevel;
import buildcraft.core.triggers.TriggerMachine;
import buildcraft.core.triggers.TriggerRedstoneInput;
import buildcraft.core.utils.CraftingHandler;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.channel.ChannelHandler;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.HashSet;
import java.util.TreeMap;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.command.ICommand;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.AchievementPage;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.oredict.OreDictionary;

@Mod(name="BuildCraft", version="6.0.17", useMetadata=false, modid="BuildCraft|Core", acceptedMinecraftVersions="[1.7.10,1.8)", dependencies="required-after:Forge@[10.13.0.1179,)")
public class BuildCraftCore
extends BuildCraftMod {
    public static final boolean NEXTGEN_PREALPHA = true;
    public static RenderMode render = RenderMode.Full;
    public static boolean debugMode = false;
    public static boolean modifyWorld = false;
    public static boolean colorBlindMode = false;
    public static boolean dropBrokenBlocks = true;
    public static int itemLifespan = 1200;
    public static int updateFactor = 10;
    public static long longUpdateFactor = 40L;
    public static BuildCraftConfiguration mainConfiguration;
    public static TreeMap<BlockIndex, PacketUpdate> bufferedDescriptions;
    public static final int trackedPassiveEntityId = 156;
    public static Block springBlock;
    public static Item woodenGearItem;
    public static Item stoneGearItem;
    public static Item ironGearItem;
    public static Item goldGearItem;
    public static Item diamondGearItem;
    public static Item wrenchItem;
    public static Item redstoneCrystal;
    public static Item robotBaseItem;
    public static Item robotBuilderItem;
    public static Item robotPickerItem;
    @SideOnly(value=Side.CLIENT)
    public static IIcon redLaserTexture;
    @SideOnly(value=Side.CLIENT)
    public static IIcon blueLaserTexture;
    @SideOnly(value=Side.CLIENT)
    public static IIcon stripesLaserTexture;
    @SideOnly(value=Side.CLIENT)
    public static IIcon transparentTexture;
    @SideOnly(value=Side.CLIENT)
    public static IIconProvider iconProvider;
    public static int blockByEntityModel;
    public static int legacyPipeModel;
    public static int markerModel;
    public static BCTrigger triggerMachineActive;
    public static BCTrigger triggerMachineInactive;
    public static BCTrigger triggerEmptyInventory;
    public static BCTrigger triggerContainsInventory;
    public static BCTrigger triggerSpaceInventory;
    public static BCTrigger triggerFullInventory;
    public static BCTrigger triggerEmptyFluid;
    public static BCTrigger triggerContainsFluid;
    public static BCTrigger triggerSpaceFluid;
    public static BCTrigger triggerFullFluid;
    public static BCTrigger triggerRedstoneActive;
    public static BCTrigger triggerRedstoneInactive;
    public static BCTrigger triggerInventoryBelow25;
    public static BCTrigger triggerInventoryBelow50;
    public static BCTrigger triggerInventoryBelow75;
    public static BCTrigger triggerFluidContainerBelow25;
    public static BCTrigger triggerFluidContainerBelow50;
    public static BCTrigger triggerFluidContainerBelow75;
    public static BCAction actionRedstone;
    public static BCAction actionOn;
    public static BCAction actionOff;
    public static BCAction actionLoop;
    public static boolean loadDefaultRecipes;
    public static boolean consumeWaterSources;
    @Mod.Instance(value="BuildCraft|Core")
    public static BuildCraftCore instance;
    public static Achievement woodenGearAchievement;
    public static Achievement stoneGearAchievement;
    public static Achievement ironGearAchievement;
    public static Achievement goldGearAchievement;
    public static Achievement diamondGearAchievement;
    public static Achievement wrenchAchievement;
    public static Achievement engineAchievement1;
    public static Achievement engineAchievement2;
    public static Achievement engineAchievement3;
    public static Achievement aLotOfCraftingAchievement;
    public static Achievement straightDownAchievement;
    public static Achievement chunkDestroyerAchievement;
    public static Achievement fasterFillingAchievement;
    public static Achievement timeForSomeLogicAchievement;
    public static Achievement refineAndRedefineAchievement;
    public static Achievement tinglyLaserAchievement;
    public static Achievement architectAchievement;
    public static Achievement builderAchievement;
    public static Achievement blueprintAchievement;
    public static Achievement templateAchievement;
    public static Achievement libraryAchievement;
    public static AchievementPage BuildcraftAchievements;
    public static HashSet<String> recipesBlacklist;
    public static float diffX;
    public static float diffY;
    public static float diffZ;
    public static GameProfile gameProfile;
    private static FloatBuffer modelviewF;
    private static FloatBuffer projectionF;
    private static IntBuffer viewport;
    private static FloatBuffer pos;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mod.EventHandler
    public void loadConfiguration(FMLPreInitializationEvent evt) {
        SchematicRegistry.declareBlueprintSupport("BuildCraft|Core");
        BCLog.initLog();
        BuildcraftRecipes.assemblyTable = AssemblyRecipeManager.INSTANCE;
        BuildcraftRecipes.integrationTable = IntegrationRecipeManager.INSTANCE;
        BuildcraftRecipes.refinery = RefineryRecipeManager.INSTANCE;
        mainConfiguration = new BuildCraftConfiguration(new File(evt.getModConfigurationDirectory(), "buildcraft/main.conf"));
        try {
            mainConfiguration.load();
            Property updateCheck = mainConfiguration.get("general", "update.check", true);
            updateCheck.comment = "set to true for version check on startup";
            if (updateCheck.getBoolean(true)) {
                Version.check();
            }
            Property dropBlock = mainConfiguration.get("general", "dropBrokenBlocks", true);
            dropBlock.comment = "set to false to prevent fillers from dropping blocks.";
            dropBrokenBlocks = dropBlock.getBoolean(true);
            Property lifespan = mainConfiguration.get("general", "itemLifespan", itemLifespan);
            lifespan.comment = "the lifespan in ticks of items dropped on the ground by pipes and machines, vanilla = 6000, default = 1200";
            if ((itemLifespan = lifespan.getInt(itemLifespan)) < 100) {
                itemLifespan = 100;
            }
            Property factor = mainConfiguration.get("general", "network.updateFactor", 10);
            factor.comment = "increasing this number will decrease network update frequency, useful for overloaded servers";
            updateFactor = factor.getInt(10);
            Property longFactor = mainConfiguration.get("general", "network.stateRefreshPeriod", 40);
            longFactor.comment = "delay between full client sync packets, increasing it saves bandwidth, decreasing makes for better client syncronization.";
            longUpdateFactor = longFactor.getInt(40);
            wrenchItem = new ItemWrench().func_77655_b("wrenchItem");
            CoreProxy.proxy.registerItem(wrenchItem);
            Property modifyWorldProp = mainConfiguration.get("general", "modifyWorld", true);
            modifyWorldProp.comment = "set to false if BuildCraft should not generate custom blocks (e.g. oil)";
            modifyWorld = modifyWorldProp.getBoolean(true);
            if (modifyWorld) {
                BlockSpring.EnumSpring.WATER.canGen = mainConfiguration.get("worldgen", "waterSpring", true).getBoolean(true);
                springBlock = new BlockSpring().func_149663_c("eternalSpring");
                CoreProxy.proxy.registerBlock(springBlock, ItemSpring.class);
            }
            Property consumeWater = mainConfiguration.get("general", "consumeWater", consumeWaterSources);
            consumeWaterSources = consumeWater.getBoolean(consumeWaterSources);
            consumeWater.comment = "set to true if the Pump should consume water";
            woodenGearItem = new ItemBuildCraft().func_77655_b("woodenGearItem");
            CoreProxy.proxy.registerItem(woodenGearItem);
            OreDictionary.registerOre((String)"gearWood", (ItemStack)new ItemStack(woodenGearItem));
            stoneGearItem = new ItemBuildCraft().func_77655_b("stoneGearItem");
            CoreProxy.proxy.registerItem(stoneGearItem);
            OreDictionary.registerOre((String)"gearStone", (ItemStack)new ItemStack(stoneGearItem));
            ironGearItem = new ItemBuildCraft().func_77655_b("ironGearItem");
            CoreProxy.proxy.registerItem(ironGearItem);
            OreDictionary.registerOre((String)"gearIron", (ItemStack)new ItemStack(ironGearItem));
            goldGearItem = new ItemBuildCraft().func_77655_b("goldGearItem");
            CoreProxy.proxy.registerItem(goldGearItem);
            OreDictionary.registerOre((String)"gearGold", (ItemStack)new ItemStack(goldGearItem));
            diamondGearItem = new ItemBuildCraft().func_77655_b("diamondGearItem");
            CoreProxy.proxy.registerItem(diamondGearItem);
            OreDictionary.registerOre((String)"gearDiamond", (ItemStack)new ItemStack(diamondGearItem));
            MinecraftForge.EVENT_BUS.register((Object)this);
            MinecraftForge.EVENT_BUS.register((Object)new BlockHighlightHandler());
        }
        finally {
            if (mainConfiguration.hasChanged()) {
                mainConfiguration.save();
            }
        }
    }

    @Mod.EventHandler
    public void initialize(FMLInitializationEvent evt) {
        BuildCraftAPI.proxy = CoreProxy.proxy;
        this.channels = NetworkRegistry.INSTANCE.newChannel("BC-CORE", new ChannelHandler[]{new BuildCraftChannelHandler(), new PacketHandler()});
        ActionManager.registerTriggerProvider(new DefaultTriggerProvider());
        ActionManager.registerActionProvider(new DefaultActionProvider());
        if (modifyWorld) {
            MinecraftForge.EVENT_BUS.register((Object)new SpringPopulate());
        }
        for (String l : mainConfiguration.get("general", "recipesBlacklist", new String[0]).getStringList()) {
            recipesBlacklist.add(JavaTools.stripSurroundingQuotes(l.trim()));
        }
        if (mainConfiguration.hasChanged()) {
            mainConfiguration.save();
        }
        if (loadDefaultRecipes) {
            this.loadRecipes();
        }
        EntityRegistry.registerModEntity(EntityRobot.class, (String)"bcRobot", (int)10, (Object)instance, (int)50, (int)1, (boolean)true);
        EntityRegistry.registerModEntity(EntityRobotPicker.class, (String)"bcRobotPicker", (int)14, (Object)instance, (int)50, (int)1, (boolean)true);
        EntityRegistry.registerModEntity(EntityRobotBuilder.class, (String)"bcRobotBuilder", (int)11, (Object)instance, (int)50, (int)1, (boolean)true);
        EntityRegistry.registerModEntity(EntityRobotUrbanism.class, (String)"bcRobotUrbanism", (int)12, (Object)instance, (int)50, (int)1, (boolean)true);
        EntityList.field_75626_c.remove(EntityRobotBuilder.class);
        EntityList.field_75625_b.remove("BuildCraft|Core.bcRobot");
        EntityList.field_75625_b.remove("BuildCraft|Core.bcLaser");
        EntityList.field_75625_b.remove("BuildCraft|Core.bcEnergyLaser");
        FMLCommonHandler.instance().bus().register((Object)new CraftingHandler());
        CoreProxy.proxy.initializeRendering();
        CoreProxy.proxy.initializeEntityRendering();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        for (Object o : Block.field_149771_c) {
            Block block = (Block)o;
            if (!(block instanceof BlockFluidBase) && !(block instanceof BlockLiquid) && !(block instanceof IPlantable)) continue;
            BuildCraftAPI.softBlocks.add(block);
        }
        BuildCraftAPI.softBlocks.add(Blocks.field_150433_aE);
        BuildCraftAPI.softBlocks.add(Blocks.field_150395_bd);
        BuildCraftAPI.softBlocks.add((Block)Blocks.field_150480_ab);
        BuildCraftAPI.softBlocks.add(Blocks.field_150350_a);
        FMLCommonHandler.instance().bus().register((Object)new TickHandlerCoreClient());
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandBuildCraft());
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void textureHook(TextureStitchEvent.Pre event) {
        if (event.map.func_130086_a() == 1) {
            iconProvider = new CoreIconProvider();
            iconProvider.registerIcons((IIconRegister)event.map);
            ActionTriggerIconProvider.INSTANCE.registerIcons((IIconRegister)event.map);
        } else if (event.map.func_130086_a() == 0) {
            redLaserTexture = event.map.func_94245_a("buildcraft:blockRedLaser");
            blueLaserTexture = event.map.func_94245_a("buildcraft:blockBlueLaser");
            stripesLaserTexture = event.map.func_94245_a("buildcraft:blockStripesLaser");
            transparentTexture = event.map.func_94245_a("buildcraft:blockTransparentLaser");
        }
    }

    public void loadRecipes() {
        CoreProxy.proxy.addCraftingRecipe(new ItemStack(wrenchItem), "I I", " G ", " I ", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('G'), stoneGearItem);
        CoreProxy.proxy.addCraftingRecipe(new ItemStack(woodenGearItem), " S ", "S S", " S ", Character.valueOf('S'), "stickWood");
        CoreProxy.proxy.addCraftingRecipe(new ItemStack(stoneGearItem), " I ", "IGI", " I ", Character.valueOf('I'), "cobblestone", Character.valueOf('G'), woodenGearItem);
        CoreProxy.proxy.addCraftingRecipe(new ItemStack(ironGearItem), " I ", "IGI", " I ", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('G'), stoneGearItem);
        CoreProxy.proxy.addCraftingRecipe(new ItemStack(goldGearItem), " I ", "IGI", " I ", Character.valueOf('I'), Items.field_151043_k, Character.valueOf('G'), ironGearItem);
        CoreProxy.proxy.addCraftingRecipe(new ItemStack(diamondGearItem), " I ", "IGI", " I ", Character.valueOf('I'), Items.field_151045_i, Character.valueOf('G'), goldGearItem);
    }

    @Mod.EventHandler
    public void processIMCRequests(FMLInterModComms.IMCEvent event) {
        InterModComms.processIMC(event);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void renderLast(RenderWorldLastEvent evt) {
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        woodenGearAchievement = new Achievement("achievement.woodenGear", "woodenGearAchievement", 0, 0, woodenGearItem, null).func_75971_g();
        stoneGearAchievement = new Achievement("achievement.stoneGear", "stoneGearAchievement", 2, 0, stoneGearItem, woodenGearAchievement).func_75971_g();
        ironGearAchievement = new Achievement("achievement.ironGear", "ironGearAchievement", 4, 0, ironGearItem, stoneGearAchievement).func_75971_g();
        goldGearAchievement = new Achievement("achievement.goldGear", "goldGearAchievement", 6, 0, goldGearItem, ironGearAchievement).func_75971_g();
        diamondGearAchievement = new Achievement("achievement.diamondGear", "diamondGearAchievement", 8, 0, diamondGearItem, goldGearAchievement).func_75971_g();
        wrenchAchievement = new Achievement("achievement.wrench", "wrenchAchievement", 3, 2, wrenchItem, stoneGearAchievement).func_75971_g();
        engineAchievement1 = new Achievement("achievement.redstoneEngine", "engineAchievement1", 1, -2, new ItemStack((Block)BuildCraftEnergy.engineBlock, 1, 0), woodenGearAchievement).func_75971_g();
        engineAchievement2 = new Achievement("achievement.stirlingEngine", "engineAchievement2", 3, -2, new ItemStack((Block)BuildCraftEnergy.engineBlock, 1, 1), engineAchievement1).func_75971_g();
        engineAchievement3 = new Achievement("achievement.combustionEngine", "engineAchievement3", 5, -2, new ItemStack((Block)BuildCraftEnergy.engineBlock, 1, 2), engineAchievement2).func_75971_g();
        aLotOfCraftingAchievement = new Achievement("achievement.aLotOfCrafting", "aLotOfCraftingAchievement", 1, 2, (Block)BuildCraftFactory.autoWorkbenchBlock, woodenGearAchievement).func_75971_g();
        straightDownAchievement = new Achievement("achievement.straightDown", "straightDownAchievement", 5, 2, (Block)BuildCraftFactory.miningWellBlock, ironGearAchievement).func_75971_g();
        chunkDestroyerAchievement = new Achievement("achievement.chunkDestroyer", "chunkDestroyerAchievement", 9, 2, (Block)BuildCraftFactory.quarryBlock, diamondGearAchievement).func_75971_g();
        fasterFillingAchievement = new Achievement("achievement.fasterFilling", "fasterFillingAchievement", 7, 2, (Block)BuildCraftBuilders.fillerBlock, goldGearAchievement).func_75971_g();
        timeForSomeLogicAchievement = new Achievement("achievement.timeForSomeLogic", "timeForSomeLogicAchievement", 9, -2, (Block)BuildCraftSilicon.assemblyTableBlock, diamondGearAchievement).func_75971_g();
        refineAndRedefineAchievement = new Achievement("achievement.refineAndRedefine", "refineAndRedefineAchievement", 10, 0, (Block)BuildCraftFactory.refineryBlock, diamondGearAchievement).func_75971_g();
        tinglyLaserAchievement = new Achievement("achievement.tinglyLaser", "tinglyLaserAchievement", 11, -2, (Block)BuildCraftSilicon.laserBlock, timeForSomeLogicAchievement).func_75971_g();
        architectAchievement = new Achievement("achievement.architect", "architectAchievement", 11, 2, (Block)BuildCraftBuilders.architectBlock, chunkDestroyerAchievement).func_75971_g();
        builderAchievement = new Achievement("achievement.builder", "builderAchievement", 13, 2, (Block)BuildCraftBuilders.builderBlock, architectAchievement).func_75971_g();
        blueprintAchievement = new Achievement("achievement.blueprint", "blueprintAchievement", 11, 4, (Item)BuildCraftBuilders.blueprintItem, architectAchievement).func_75971_g();
        templateAchievement = new Achievement("achievement.template", "templateAchievement", 13, 4, (Item)BuildCraftBuilders.templateItem, blueprintAchievement).func_75971_g();
        libraryAchievement = new Achievement("achievement.blueprintLibrary", "blueprintLibraryAchievement", 15, 2, (Block)BuildCraftBuilders.libraryBlock, builderAchievement).func_75971_g();
        BuildcraftAchievements = new AchievementPage("Buildcraft", new Achievement[]{woodenGearAchievement, stoneGearAchievement, ironGearAchievement, goldGearAchievement, diamondGearAchievement, wrenchAchievement, engineAchievement1, engineAchievement2, engineAchievement3, aLotOfCraftingAchievement, straightDownAchievement, chunkDestroyerAchievement, fasterFillingAchievement, timeForSomeLogicAchievement, refineAndRedefineAchievement, tinglyLaserAchievement, architectAchievement, builderAchievement, blueprintAchievement, templateAchievement, libraryAchievement});
        AchievementPage.registerAchievementPage((AchievementPage)BuildcraftAchievements);
    }

    static {
        bufferedDescriptions = new TreeMap();
        triggerMachineActive = new TriggerMachine(true);
        triggerMachineInactive = new TriggerMachine(false);
        triggerEmptyInventory = new TriggerInventory(TriggerInventory.State.Empty);
        triggerContainsInventory = new TriggerInventory(TriggerInventory.State.Contains);
        triggerSpaceInventory = new TriggerInventory(TriggerInventory.State.Space);
        triggerFullInventory = new TriggerInventory(TriggerInventory.State.Full);
        triggerEmptyFluid = new TriggerFluidContainer(TriggerFluidContainer.State.Empty);
        triggerContainsFluid = new TriggerFluidContainer(TriggerFluidContainer.State.Contains);
        triggerSpaceFluid = new TriggerFluidContainer(TriggerFluidContainer.State.Space);
        triggerFullFluid = new TriggerFluidContainer(TriggerFluidContainer.State.Full);
        triggerRedstoneActive = new TriggerRedstoneInput(true);
        triggerRedstoneInactive = new TriggerRedstoneInput(false);
        triggerInventoryBelow25 = new TriggerInventoryLevel(TriggerInventoryLevel.TriggerType.BELOW_25);
        triggerInventoryBelow50 = new TriggerInventoryLevel(TriggerInventoryLevel.TriggerType.BELOW_50);
        triggerInventoryBelow75 = new TriggerInventoryLevel(TriggerInventoryLevel.TriggerType.BELOW_75);
        triggerFluidContainerBelow25 = new TriggerFluidContainerLevel(TriggerFluidContainerLevel.TriggerType.BELOW_25);
        triggerFluidContainerBelow50 = new TriggerFluidContainerLevel(TriggerFluidContainerLevel.TriggerType.BELOW_50);
        triggerFluidContainerBelow75 = new TriggerFluidContainerLevel(TriggerFluidContainerLevel.TriggerType.BELOW_75);
        actionRedstone = new ActionRedstoneOutput();
        actionOn = new ActionMachineControl(ActionMachineControl.Mode.On);
        actionOff = new ActionMachineControl(ActionMachineControl.Mode.Off);
        actionLoop = new ActionMachineControl(ActionMachineControl.Mode.Loop);
        loadDefaultRecipes = true;
        consumeWaterSources = false;
        recipesBlacklist = new HashSet();
        gameProfile = new GameProfile(UUID.nameUUIDFromBytes("buildcraft.core".getBytes()), "[BuildCraft]");
        pos = ByteBuffer.allocateDirect(12).asFloatBuffer();
    }

    public static enum RenderMode {
        Full,
        NoDynamic;

    }
}

