/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.BuildCraftBuilders;
import buildcraft.api.blueprints.BuildingPermission;
import buildcraft.builders.blueprints.BlueprintId;
import buildcraft.core.CreativeTabBuildCraft;
import buildcraft.core.ItemBuildCraft;
import buildcraft.core.blueprints.BlueprintBase;
import buildcraft.core.utils.NBTUtils;
import buildcraft.core.utils.StringUtils;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class ItemBlueprint
extends ItemBuildCraft {
    public ItemBlueprint() {
        super(CreativeTabBuildCraft.ITEMS);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advanced) {
        boolean isComplete;
        if (NBTUtils.getItemData(stack).func_74764_b("name")) {
            String name = NBTUtils.getItemData(stack).func_74779_i("name");
            if ("".equals(name)) {
                list.add(String.format(StringUtils.localize("item.blueprint.unnamed"), new Object[0]));
            } else {
                list.add(String.format(name, new Object[0]));
            }
            list.add(String.format(StringUtils.localize("item.blueprint.author") + " " + NBTUtils.getItemData(stack).func_74779_i("author"), new Object[0]));
        } else {
            list.add(StringUtils.localize("item.blueprint.blank"));
        }
        if (NBTUtils.getItemData(stack).func_74764_b("permission")) {
            BuildingPermission p = BuildingPermission.values()[NBTUtils.getItemData(stack).func_74771_c("permission")];
            if (p == BuildingPermission.CREATIVE_ONLY) {
                list.add(String.format(StringUtils.localize("item.blueprint.creative_only"), new Object[0]));
            } else if (p == BuildingPermission.NONE) {
                list.add(String.format(StringUtils.localize("item.blueprint.no_build"), new Object[0]));
            }
        }
        if (NBTUtils.getItemData(stack).func_74764_b("isComplete") && !(isComplete = NBTUtils.getItemData(stack).func_74767_n("isComplete"))) {
            list.add(String.format(StringUtils.localize("item.blueprint.incomplete"), new Object[0]));
        }
    }

    public int getItemStackLimit(ItemStack stack) {
        return NBTUtils.getItemData(stack).func_74764_b("name") ? 1 : 16;
    }

    public static BlueprintId getId(ItemStack stack) {
        NBTTagCompound nbt = NBTUtils.getItemData(stack);
        if (nbt == null) {
            return null;
        }
        BlueprintId id = new BlueprintId();
        id.read(nbt);
        if (BuildCraftBuilders.serverDB.exists(id)) {
            return id;
        }
        return null;
    }

    public static BlueprintBase loadBlueprint(ItemStack stack) {
        return BuildCraftBuilders.serverDB.load(ItemBlueprint.getId(stack));
    }
}

