/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.BuildCraftBuilders;
import buildcraft.api.blueprints.BuildingPermission;
import buildcraft.api.blueprints.Translation;
import buildcraft.api.core.NetworkData;
import buildcraft.api.core.Position;
import buildcraft.api.gates.IAction;
import buildcraft.builders.ItemBlueprint;
import buildcraft.builders.ItemBlueprintStandard;
import buildcraft.builders.ItemBlueprintTemplate;
import buildcraft.builders.TileAbstractBuilder;
import buildcraft.builders.TilePathMarker;
import buildcraft.core.BlockIndex;
import buildcraft.core.Box;
import buildcraft.core.IMachine;
import buildcraft.core.LaserData;
import buildcraft.core.blueprints.Blueprint;
import buildcraft.core.blueprints.BlueprintBase;
import buildcraft.core.blueprints.BptBuilderBase;
import buildcraft.core.blueprints.BptBuilderBlueprint;
import buildcraft.core.blueprints.BptBuilderTemplate;
import buildcraft.core.blueprints.BptContext;
import buildcraft.core.inventory.InvUtils;
import buildcraft.core.inventory.SimpleInventory;
import buildcraft.core.network.RPC;
import buildcraft.core.network.RPCHandler;
import buildcraft.core.network.RPCSide;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.util.ForgeDirection;

public class TileBuilder
extends TileAbstractBuilder
implements IMachine {
    private static int POWER_ACTIVATION = 50;
    @NetworkData
    public Box box = new Box();
    public PathIterator currentPathIterator;
    private SimpleInventory inv = new SimpleInventory(28, "Builder", 64);
    private BptBuilderBase bluePrintBuilder;
    private LinkedList<BlockIndex> path;
    private LinkedList<ItemStack> requiredToBuild;
    private NBTTagCompound initNBT = null;
    private boolean done = true;

    public TileBuilder() {
        this.box.kind = Box.Kind.STRIPES;
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.initNBT != null) {
            this.iterateBpt(true);
            if (this.initNBT.func_74764_b("iterator")) {
                BlockIndex bi;
                BlockIndex expectedTo = new BlockIndex(this.initNBT.func_74775_l("iterator"));
                while (!this.done && this.bluePrintBuilder != null && this.currentPathIterator != null && !(bi = new BlockIndex((int)this.currentPathIterator.ix, (int)this.currentPathIterator.iy, (int)this.currentPathIterator.iz)).equals(expectedTo)) {
                    this.iterateBpt(true);
                }
            }
            if (this.bluePrintBuilder != null) {
                this.bluePrintBuilder.loadBuildStateToNBT(this.initNBT.func_74775_l("builderState"), this);
            }
            this.initNBT = null;
        }
        this.box.kind = Box.Kind.STRIPES;
        for (int x = this.field_145851_c - 1; x <= this.field_145851_c + 1; ++x) {
            block2: for (int y = this.field_145848_d - 1; y <= this.field_145848_d + 1; ++y) {
                for (int z = this.field_145849_e - 1; z <= this.field_145849_e + 1; ++z) {
                    TileEntity tile = this.field_145850_b.func_147438_o(x, y, z);
                    if (!(tile instanceof TilePathMarker)) continue;
                    this.path = ((TilePathMarker)tile).getPath();
                    for (BlockIndex b : this.path) {
                        this.field_145850_b.func_147468_f(b.x, b.y, b.z);
                        BuildCraftBuilders.pathMarkerBlock.func_149697_b(this.field_145850_b, b.x, b.y, b.z, 0, 0);
                    }
                    continue block2;
                }
            }
        }
        if (this.path != null && this.pathLasers.size() == 0) {
            this.createLasersForPath();
            this.sendNetworkUpdate();
        }
        this.iterateBpt(false);
    }

    public void createLasersForPath() {
        this.pathLasers = new LinkedList();
        BlockIndex previous = null;
        for (BlockIndex b : this.path) {
            if (previous != null) {
                LaserData laser = new LaserData(new Position((double)previous.x + 0.5, (double)previous.y + 0.5, (double)previous.z + 0.5), new Position((double)b.x + 0.5, (double)b.y + 0.5, (double)b.z + 0.5));
                this.pathLasers.add(laser);
            }
            previous = b;
        }
    }

    public BptBuilderBase instanciateBluePrint(int x, int y, int z, ForgeDirection o) {
        BlueprintBase bpt = null;
        try {
            bpt = ItemBlueprint.loadBlueprint(this.func_70301_a(0));
        }
        catch (Throwable t) {
            this.func_70299_a(0, null);
            t.printStackTrace();
            return null;
        }
        if (bpt == null) {
            return null;
        }
        if (bpt.buildingPermission == BuildingPermission.NONE || bpt.buildingPermission == BuildingPermission.CREATIVE_ONLY && this.field_145850_b.func_72912_H().func_76077_q() != WorldSettings.GameType.CREATIVE) {
            return null;
        }
        BptContext context = bpt.getContext(this.field_145850_b, bpt.getBoxForPos(x, y, z));
        if (bpt.rotate && o != ForgeDirection.EAST) {
            if (o == ForgeDirection.SOUTH) {
                bpt.rotateLeft(context);
            } else if (o == ForgeDirection.WEST) {
                bpt.rotateLeft(context);
                bpt.rotateLeft(context);
            } else if (o == ForgeDirection.NORTH) {
                bpt.rotateLeft(context);
                bpt.rotateLeft(context);
                bpt.rotateLeft(context);
            }
        }
        Translation transform = new Translation();
        transform.x = x - bpt.anchorX;
        transform.y = y - bpt.anchorY;
        transform.z = z - bpt.anchorZ;
        bpt.translateToWorld(transform);
        if (this.func_70301_a(0).func_77973_b() instanceof ItemBlueprintStandard) {
            return new BptBuilderBlueprint((Blueprint)bpt, this.field_145850_b, x, y, z);
        }
        if (this.func_70301_a(0).func_77973_b() instanceof ItemBlueprintTemplate) {
            return new BptBuilderTemplate(bpt, this.field_145850_b, x, y, z);
        }
        return null;
    }

    public void iterateBpt(boolean forceIterate) {
        if (this.func_70301_a(0) == null || !(this.func_70301_a(0).func_77973_b() instanceof ItemBlueprint)) {
            if (this.bluePrintBuilder != null) {
                this.bluePrintBuilder = null;
            }
            if (this.box.isInitialized()) {
                this.box.reset();
            }
            if (this.currentPathIterator != null) {
                this.currentPathIterator = null;
            }
            this.updateRequirements();
            this.sendNetworkUpdate();
            return;
        }
        if (this.bluePrintBuilder == null || this.bluePrintBuilder.isDone(this) || forceIterate) {
            if (this.path != null && this.path.size() > 1) {
                if (this.currentPathIterator == null) {
                    Iterator<BlockIndex> it = this.path.iterator();
                    BlockIndex start = (BlockIndex)it.next();
                    this.currentPathIterator = new PathIterator(start, it, ForgeDirection.values()[this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e)].getOpposite());
                }
                if (this.bluePrintBuilder != null && this.bluePrintBuilder.isDone(this)) {
                    this.bluePrintBuilder.postProcessing(this.field_145850_b);
                }
                this.bluePrintBuilder = this.currentPathIterator.next();
                if (this.bluePrintBuilder != null) {
                    this.box.reset();
                    this.box.initialize(this.bluePrintBuilder);
                    this.sendNetworkUpdate();
                }
                if (this.bluePrintBuilder == null) {
                    this.currentPathIterator = this.currentPathIterator.iterate();
                }
                this.done = this.currentPathIterator == null;
            } else if (this.bluePrintBuilder != null && this.bluePrintBuilder.isDone(this)) {
                this.bluePrintBuilder.postProcessing(this.field_145850_b);
                this.done = true;
                this.bluePrintBuilder = null;
            } else {
                this.bluePrintBuilder = this.instanciateBluePrint(this.field_145851_c, this.field_145848_d, this.field_145849_e, ForgeDirection.values()[this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e)].getOpposite());
                if (this.bluePrintBuilder != null) {
                    this.box.initialize(this.bluePrintBuilder);
                    this.sendNetworkUpdate();
                    this.done = false;
                }
            }
            this.updateRequirements();
        }
        if (this.done) {
            boolean dropBlueprint = true;
            for (int i = 1; i < this.func_70302_i_(); ++i) {
                if (this.func_70301_a(i) != null) continue;
                this.func_70299_a(i, this.func_70301_a(0));
                dropBlueprint = false;
                break;
            }
            if (dropBlueprint) {
                InvUtils.dropItems(this.getWorld(), this.func_70301_a(0), this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            this.func_70299_a(0, null);
            this.box.reset();
        }
    }

    public int func_70302_i_() {
        return this.inv.func_70302_i_();
    }

    public ItemStack func_70301_a(int i) {
        return this.inv.func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int j) {
        ItemStack result = this.inv.func_70298_a(i, j);
        if (!this.field_145850_b.field_72995_K && i == 0) {
            RPCHandler.rpcBroadcastPlayers(this, "setItemRequirements", null, null);
            this.iterateBpt(false);
        }
        return result;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inv.func_70299_a(i, itemstack);
        if (!this.field_145850_b.field_72995_K && i == 0) {
            this.iterateBpt(false);
            this.done = false;
        }
    }

    public ItemStack func_70304_b(int slot) {
        return this.inv.func_70304_b(slot);
    }

    public String func_145825_b() {
        return "Builder";
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.inv.readFromNBT(nbttagcompound);
        if (nbttagcompound.func_74764_b("box")) {
            this.box.initialize(nbttagcompound.func_74775_l("box"));
        }
        if (nbttagcompound.func_74764_b("path")) {
            this.path = new LinkedList();
            NBTTagList list = nbttagcompound.func_150295_c("path", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                this.path.add(new BlockIndex(list.func_150305_b(i)));
            }
        }
        this.done = nbttagcompound.func_74767_n("done");
        this.initNBT = (NBTTagCompound)nbttagcompound.func_74775_l("bptBuilder").func_74737_b();
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        this.inv.writeToNBT(nbttagcompound);
        if (this.box.isInitialized()) {
            NBTTagCompound boxStore = new NBTTagCompound();
            this.box.writeToNBT(boxStore);
            nbttagcompound.func_74782_a("box", (NBTBase)boxStore);
        }
        if (this.path != null) {
            NBTTagList list = new NBTTagList();
            for (BlockIndex i : this.path) {
                NBTTagCompound c = new NBTTagCompound();
                i.writeTo(c);
                list.func_74742_a((NBTBase)c);
            }
            nbttagcompound.func_74782_a("path", (NBTBase)list);
        }
        nbttagcompound.func_74757_a("done", this.done);
        NBTTagCompound bptNBT = new NBTTagCompound();
        if (this.bluePrintBuilder != null) {
            NBTTagCompound builderCpt = new NBTTagCompound();
            this.bluePrintBuilder.saveBuildStateToNBT(builderCpt, this);
            bptNBT.func_74782_a("builderState", (NBTBase)builderCpt);
        }
        if (this.currentPathIterator != null) {
            NBTTagCompound iteratorNBT = new NBTTagCompound();
            new BlockIndex((int)this.currentPathIterator.ix, (int)this.currentPathIterator.iy, (int)this.currentPathIterator.iz).writeTo(iteratorNBT);
            bptNBT.func_74782_a("iterator", (NBTBase)iteratorNBT);
        }
        nbttagcompound.func_74782_a("bptBuilder", (NBTBase)bptNBT);
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.destroy();
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.bluePrintBuilder != null) {
            this.bluePrintBuilder.removeDoneBuilders(this);
        }
        if ((this.bluePrintBuilder == null || this.bluePrintBuilder.isDone(this)) && this.box.isInitialized()) {
            this.box.reset();
            this.sendNetworkUpdate();
            return;
        }
        this.iterateBpt(false);
        if (this.getWorld().func_72912_H().func_76077_q() == WorldSettings.GameType.CREATIVE) {
            this.build();
        } else if (this.mjStored > (double)POWER_ACTIVATION) {
            this.build();
        }
        if (this.done) {
            return;
        }
        if (this.mjStored < 25.0) {
            return;
        }
    }

    @Override
    public boolean isActive() {
        return !this.done;
    }

    @Override
    public boolean manageFluids() {
        return false;
    }

    @Override
    public boolean manageSolids() {
        return true;
    }

    public boolean isBuildingBlueprint() {
        return this.func_70301_a(0) != null && this.func_70301_a(0).func_77973_b() instanceof ItemBlueprint;
    }

    public Collection<ItemStack> getNeededItems() {
        return this.requiredToBuild;
    }

    @RPC(value=RPCSide.CLIENT)
    public void setItemRequirements(LinkedList<ItemStack> rq, LinkedList<Integer> realSizes) {
        block1: {
            this.requiredToBuild = rq;
            if (rq == null || rq.size() <= 0) break block1;
            Iterator itStack = rq.iterator();
            Iterator size = realSizes.iterator();
            do {
                ItemStack stack = (ItemStack)itStack.next();
                stack.field_77994_a = (Integer)size.next();
                if (stack.field_77994_a <= 999) continue;
                stack.field_77994_a = 999;
            } while (itStack.hasNext());
        }
    }

    @Override
    public boolean isBuildingMaterialSlot(int i) {
        return i != 0;
    }

    @Override
    public boolean allowAction(IAction action) {
        return false;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == 0) {
            return stack.func_77973_b() instanceof ItemBlueprint;
        }
        return true;
    }

    @Override
    public Box getBox() {
        return this.box;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        Box renderBox = new Box(this).extendToEncompass(this.box);
        for (LaserData l : this.pathLasers) {
            renderBox = renderBox.extendToEncompass(l.head);
            renderBox = renderBox.extendToEncompass(l.tail);
        }
        return renderBox.expand(50).getBoundingBox();
    }

    public void build() {
        if (!this.buildTracker.markTimeIfDelay(this.field_145850_b)) {
            return;
        }
        if (this.bluePrintBuilder != null) {
            this.bluePrintBuilder.buildNextSlot(this.field_145850_b, this, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.updateRequirements();
        }
    }

    public void updateRequirements() {
        if (this.bluePrintBuilder instanceof BptBuilderBlueprint) {
            LinkedList<Integer> realSize = new LinkedList<Integer>();
            for (ItemStack stack : ((BptBuilderBlueprint)this.bluePrintBuilder).neededItems) {
                realSize.add(stack.field_77994_a);
                stack.field_77994_a = 0;
            }
            RPCHandler.rpcBroadcastPlayers(this, "setItemRequirements", ((BptBuilderBlueprint)this.bluePrintBuilder).neededItems, realSize);
        } else {
            RPCHandler.rpcBroadcastPlayers(this, "setItemRequirements", null, null);
        }
    }

    public BptBuilderBase getBlueprint() {
        if (this.bluePrintBuilder != null) {
            return this.bluePrintBuilder;
        }
        return null;
    }

    private class PathIterator {
        public Iterator<BlockIndex> currentIterator;
        public double cx;
        public double cy;
        public double cz;
        public float ix;
        public float iy;
        public float iz;
        public BlockIndex to;
        public double lastDistance;
        AxisAlignedBB oldBoundingBox = null;
        ForgeDirection o = null;

        public PathIterator(BlockIndex from, Iterator<BlockIndex> it, ForgeDirection initialDir) {
            this.to = it.next();
            this.currentIterator = it;
            double dx = this.to.x - from.x;
            double dy = this.to.y - from.y;
            double dz = this.to.z - from.z;
            double size = Math.sqrt(dx * dx + dy * dy + dz * dz);
            this.cx = dx / size / 10.0;
            this.cy = dy / size / 10.0;
            this.cz = dz / size / 10.0;
            this.ix = from.x;
            this.iy = from.y;
            this.iz = from.z;
            this.lastDistance = (this.ix - (float)this.to.x) * (this.ix - (float)this.to.x) + (this.iy - (float)this.to.y) * (this.iy - (float)this.to.y) + (this.iz - (float)this.to.z) * (this.iz - (float)this.to.z);
            this.o = dx == 0.0 && dz == 0.0 ? initialDir : (Math.abs(dx) > Math.abs(dz) ? (dx > 0.0 ? ForgeDirection.EAST : ForgeDirection.WEST) : (dz > 0.0 ? ForgeDirection.SOUTH : ForgeDirection.NORTH));
        }

        public BptBuilderBase next() {
            int newZ;
            int newY;
            int newX;
            BptBuilderBase bpt;
            while ((bpt = TileBuilder.this.instanciateBluePrint(newX = Math.round(this.ix), newY = Math.round(this.iy), newZ = Math.round(this.iz), this.o)) != null) {
                AxisAlignedBB boundingBox = bpt.getBoundingBox();
                if (this.oldBoundingBox == null || !this.collision(this.oldBoundingBox, boundingBox)) {
                    this.oldBoundingBox = boundingBox;
                    if (bpt != null) {
                        return bpt;
                    }
                }
                this.ix = (float)((double)this.ix + this.cx);
                this.iy = (float)((double)this.iy + this.cy);
                this.iz = (float)((double)this.iz + this.cz);
                double distance = (this.ix - (float)this.to.x) * (this.ix - (float)this.to.x) + (this.iy - (float)this.to.y) * (this.iy - (float)this.to.y) + (this.iz - (float)this.to.z) * (this.iz - (float)this.to.z);
                if (distance > this.lastDistance) {
                    return null;
                }
                this.lastDistance = distance;
            }
            return null;
        }

        public PathIterator iterate() {
            if (this.currentIterator.hasNext()) {
                PathIterator next = new PathIterator(this.to, this.currentIterator, this.o);
                next.oldBoundingBox = this.oldBoundingBox;
                return next;
            }
            return null;
        }

        public boolean collision(AxisAlignedBB left, AxisAlignedBB right) {
            if (left.field_72336_d < right.field_72340_a || left.field_72340_a > right.field_72336_d) {
                return false;
            }
            if (left.field_72337_e < right.field_72338_b || left.field_72338_b > right.field_72337_e) {
                return false;
            }
            return !(left.field_72334_f < right.field_72339_c) && !(left.field_72339_c > right.field_72334_f);
        }
    }
}

