/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.urbanism;

import buildcraft.api.core.NetworkData;
import buildcraft.builders.urbanism.AnchoredBox;
import buildcraft.builders.urbanism.EntityUrbanist;
import buildcraft.builders.urbanism.UrbanistTaskErase;
import buildcraft.core.Box;
import buildcraft.core.IBoxesProvider;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.network.RPC;
import buildcraft.core.network.RPCHandler;
import buildcraft.core.network.RPCSide;
import buildcraft.core.robots.EntityRobot;
import buildcraft.core.robots.IRobotTask;
import buildcraft.core.robots.IRobotTaskProvider;
import buildcraft.core.robots.RobotTaskProviderRegistry;
import java.util.ArrayList;
import java.util.LinkedList;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;

public class TileUrbanist
extends TileBuildCraft
implements IInventory,
IRobotTaskProvider,
IBoxesProvider {
    public EntityUrbanist urbanist;
    @NetworkData
    public ArrayList<AnchoredBox> frames = new ArrayList();
    private EntityLivingBase player;
    private int thirdPersonView = 0;
    private double posX;
    private double posY;
    private double posZ;
    private float yaw;
    private int p2x = 0;
    private int p2y = 0;
    private int p2z = 0;
    private boolean isCreatingFrame = false;
    private LinkedList<IRobotTask> tasks = new LinkedList();

    public void createUrbanistEntity() {
        if (this.field_145850_b.field_72995_K && this.urbanist == null) {
            this.urbanist = new EntityUrbanist(this.field_145850_b);
            this.field_145850_b.func_72838_d((Entity)this.urbanist);
            this.player = Minecraft.func_71410_x().field_71451_h;
            this.urbanist.func_82149_j((Entity)this.player);
            this.urbanist.tile = this;
            this.urbanist.player = this.player;
            this.urbanist.field_70177_z = 0.0f;
            this.urbanist.field_70125_A = 0.0f;
            Minecraft.func_71410_x().field_71451_h = this.urbanist;
            this.thirdPersonView = Minecraft.func_71410_x().field_71474_y.field_74320_O;
            Minecraft.func_71410_x().field_71474_y.field_74320_O = 8;
            this.posX = this.urbanist.field_70165_t;
            this.posY = this.urbanist.field_70163_u + 10.0;
            this.posZ = this.urbanist.field_70161_v;
            this.yaw = 0.0f;
            this.urbanist.func_70080_a(this.posX, this.posY, this.posZ, this.yaw, 50.0f);
            this.urbanist.func_70634_a(this.posX, this.posY, this.posZ);
        }
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
    }

    @RPC(value=RPCSide.SERVER)
    public void setBlock(int x, int y, int z) {
        this.field_145850_b.func_147449_b(x, y, z, Blocks.field_150336_V);
    }

    @RPC(value=RPCSide.SERVER)
    public void eraseBlock(int x, int y, int z) {
        this.tasks.add(new UrbanistTaskErase(this, x, y, z));
    }

    public void rpcEraseBlock(int x, int y, int z) {
        RPCHandler.rpcServer(this, "eraseBlock", x, y, z);
    }

    @RPC(value=RPCSide.BOTH)
    public void createFrame(int x, int y, int z) {
        this.isCreatingFrame = true;
        AnchoredBox a = new AnchoredBox();
        a.box = new Box(x, y, z, x, y + 2, z);
        a.x1 = x;
        a.y1 = y;
        a.z1 = z;
        this.frames.add(a);
    }

    public void rpcCreateFrame(int x, int y, int z) {
        this.p2x = x;
        this.p2y = y;
        this.p2z = z;
        this.createFrame(x, y, z);
        RPCHandler.rpcServer(this, "createFrame", x, y, z);
    }

    @RPC(value=RPCSide.BOTH)
    public void moveFrame(int x, int y, int z) {
        if (this.isCreatingFrame && this.frames.size() > 0) {
            this.frames.get(this.frames.size() - 1).setP2(x, y, z);
        }
    }

    public void rpcMoveFrame(int x, int y, int z) {
        if (this.p2x != x || this.p2y != y || this.p2z != z) {
            this.p2x = x;
            this.p2y = y;
            this.p2z = z;
            this.moveFrame(x, y, z);
            RPCHandler.rpcServer(this, "moveFrame", x, y, z);
        }
    }

    @RPC(value=RPCSide.CLIENT)
    public void setFrameKind(int id, int kind) {
        AnchoredBox b;
        if (id < this.frames.size() && (b = this.frames.get(id)) != null) {
            b.box.kind = Box.Kind.values()[kind];
        }
    }

    @RPC(value=RPCSide.SERVER)
    public void startFiller(String fillerTag, Box box) {
    }

    public void rpcStartFiller(String fillerTag, Box box) {
        RPCHandler.rpcServer(this, "startFiller", fillerTag, box);
    }

    public void destroyUrbanistEntity() {
        Minecraft.func_71410_x().field_71451_h = this.player;
        Minecraft.func_71410_x().field_71474_y.field_74320_O = this.thirdPersonView;
        this.field_145850_b.func_72900_e((Entity)this.urbanist);
        this.urbanist.func_70106_y();
        this.urbanist = null;
    }

    public int func_70302_i_() {
        return 0;
    }

    public ItemStack func_70301_a(int var1) {
        return null;
    }

    public ItemStack func_70298_a(int var1, int var2) {
        return null;
    }

    public ItemStack func_70304_b(int var1) {
        return null;
    }

    public void func_70299_a(int var1, ItemStack var2) {
    }

    public String func_145825_b() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 0;
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int var1, ItemStack var2) {
        return false;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        Box box = new Box(this);
        for (AnchoredBox b : this.frames) {
            box.extendToEncompass(b.box);
        }
        return box.getBoundingBox();
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("nbFrames", this.frames.size());
        for (int i = 0; i < this.frames.size(); ++i) {
            NBTTagCompound cpt = new NBTTagCompound();
            this.frames.get(i).writeToNBT(cpt);
            nbt.func_74782_a("frame[" + i + "]", (NBTBase)cpt);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.frames.clear();
        int size = nbt.func_74762_e("nbFrames");
        for (int i = 0; i < size; ++i) {
            AnchoredBox b = new AnchoredBox();
            b.readFromNBT(nbt.func_74775_l("frame[" + i + "]"));
            this.frames.add(b);
        }
    }

    @Override
    public double getX() {
        return this.field_145851_c;
    }

    @Override
    public double getY() {
        return this.field_145848_d;
    }

    @Override
    public double getZ() {
        return this.field_145849_e;
    }

    @Override
    public boolean isActive() {
        return !this.func_145837_r();
    }

    @Override
    public IRobotTask getNextTask(EntityRobot robot) {
        if (this.tasks.size() > 0) {
            return this.tasks.getFirst();
        }
        return null;
    }

    @Override
    public void popNextTask() {
        this.tasks.removeFirst();
    }

    @Override
    public void initialize() {
        if (!this.field_145850_b.field_72995_K) {
            RobotTaskProviderRegistry.registerProvider(this);
        }
    }

    @Override
    public ArrayList<Box> getBoxes() {
        ArrayList<Box> result = new ArrayList<Box>();
        for (AnchoredBox b : this.frames) {
            result.add(b.box);
        }
        return result;
    }

    public class FrameTask {
        int nbOfTasks;
        AnchoredBox frame;

        public void taskDone() {
            --this.nbOfTasks;
            if (this.nbOfTasks <= 0) {
                TileUrbanist.this.frames.remove(this.frame);
            }
        }
    }
}

