/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.api.core.IAreaProvider;
import buildcraft.api.core.IBox;
import buildcraft.api.core.NetworkData;
import buildcraft.api.core.Position;
import buildcraft.core.BlockIndex;
import buildcraft.core.LaserData;
import buildcraft.core.utils.Utils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class Box
implements IBox {
    @NetworkData
    public Kind kind = Kind.LASER_RED;
    @NetworkData
    public int xMin;
    @NetworkData
    public int yMin;
    @NetworkData
    public int zMin;
    @NetworkData
    public int xMax;
    @NetworkData
    public int yMax;
    @NetworkData
    public int zMax;
    @NetworkData
    public boolean initialized;
    @NetworkData
    public boolean isVisible = true;
    public LaserData[] lasersData;

    public Box() {
        this.reset();
    }

    public Box(TileEntity e) {
        this.initialize(e.field_145851_c, e.field_145848_d, e.field_145849_e, e.field_145851_c + 1, e.field_145848_d + 1, e.field_145849_e + 1);
    }

    public Box(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax) {
        this();
        this.initialize(xMin, yMin, zMin, xMax, yMax, zMax);
    }

    public void reset() {
        this.initialized = false;
        this.xMin = Integer.MAX_VALUE;
        this.yMin = Integer.MAX_VALUE;
        this.zMin = Integer.MAX_VALUE;
        this.xMax = Integer.MAX_VALUE;
        this.yMax = Integer.MAX_VALUE;
        this.zMax = Integer.MAX_VALUE;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void initialize(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax) {
        if (xMin < xMax) {
            this.xMin = xMin;
            this.xMax = xMax;
        } else {
            this.xMin = xMax;
            this.xMax = xMin;
        }
        if (yMin < yMax) {
            this.yMin = yMin;
            this.yMax = yMax;
        } else {
            this.yMin = yMax;
            this.yMax = yMin;
        }
        if (zMin < zMax) {
            this.zMin = zMin;
            this.zMax = zMax;
        } else {
            this.zMin = zMax;
            this.zMax = zMin;
        }
        this.initialized = xMin != Integer.MAX_VALUE && yMin != Integer.MAX_VALUE && zMin != Integer.MAX_VALUE && xMax != Integer.MAX_VALUE && yMax != Integer.MAX_VALUE && zMax != Integer.MAX_VALUE;
    }

    public void initialize(Box box) {
        this.initialize(box.xMin, box.yMin, box.zMin, box.xMax, box.yMax, box.zMax);
    }

    public void initialize(IAreaProvider a) {
        this.initialize(a.xMin(), a.yMin(), a.zMin(), a.xMax(), a.yMax(), a.zMax());
    }

    public void initialize(NBTTagCompound nbttagcompound) {
        this.kind = Kind.values()[nbttagcompound.func_74765_d("kind")];
        this.initialize(nbttagcompound.func_74762_e("xMin"), nbttagcompound.func_74762_e("yMin"), nbttagcompound.func_74762_e("zMin"), nbttagcompound.func_74762_e("xMax"), nbttagcompound.func_74762_e("yMax"), nbttagcompound.func_74762_e("zMax"));
    }

    public void initialize(int centerX, int centerY, int centerZ, int size) {
        this.initialize(centerX - size, centerY - size, centerZ - size, centerX + size, centerY + size, centerZ + size);
    }

    public List<BlockIndex> getBlocksInArea() {
        ArrayList<BlockIndex> blocks = new ArrayList<BlockIndex>();
        for (float x = (float)this.xMin; x <= (float)this.xMax; x += 1.0f) {
            for (float y = (float)this.yMin; y <= (float)this.yMax; y += 1.0f) {
                for (float z = (float)this.zMin; z <= (float)this.zMax; z += 1.0f) {
                    blocks.add(new BlockIndex((int)x, (int)y, (int)z));
                }
            }
        }
        return blocks;
    }

    @Override
    public Box expand(int amount) {
        this.xMin -= amount;
        this.yMin -= amount;
        this.zMin -= amount;
        this.xMax += amount;
        this.yMax += amount;
        this.zMax += amount;
        return this;
    }

    @Override
    public IBox contract(int amount) {
        return this.expand(-amount);
    }

    @Override
    public boolean contains(double x, double y, double z) {
        return x >= (double)this.xMin && x <= (double)this.xMax && y >= (double)this.yMin && y <= (double)this.yMax && z >= (double)this.zMin && z <= (double)this.zMax;
    }

    public boolean contains(Position p) {
        return this.contains((int)p.x, (int)p.y, (int)p.z);
    }

    public boolean contains(BlockIndex i) {
        return this.contains(i.x, i.y, i.z);
    }

    @Override
    public Position pMin() {
        return new Position(this.xMin, this.yMin, this.zMin);
    }

    @Override
    public Position pMax() {
        return new Position(this.xMax, this.yMax, this.zMax);
    }

    public int sizeX() {
        return this.xMax - this.xMin + 1;
    }

    public int sizeY() {
        return this.yMax - this.yMin + 1;
    }

    public int sizeZ() {
        return this.zMax - this.zMin + 1;
    }

    public double centerX() {
        return (double)this.xMin + (double)this.sizeX() / 2.0;
    }

    public double centerY() {
        return (double)this.yMin + (double)this.sizeY() / 2.0;
    }

    public double centerZ() {
        return (double)this.zMin + (double)this.sizeZ() / 2.0;
    }

    public Box rotateLeft() {
        Box nBox = new Box();
        nBox.xMin = this.sizeZ() - 1 - this.zMin;
        nBox.yMin = this.yMin;
        nBox.zMin = this.xMin;
        nBox.xMax = this.sizeZ() - 1 - this.zMax;
        nBox.yMax = this.yMax;
        nBox.zMax = this.xMax;
        nBox.reorder();
        return nBox;
    }

    public void reorder() {
        int tmp;
        if (this.xMin > this.xMax) {
            tmp = this.xMin;
            this.xMin = this.xMax;
            this.xMax = tmp;
        }
        if (this.yMin > this.yMax) {
            tmp = this.yMin;
            this.yMin = this.yMax;
            this.yMax = tmp;
        }
        if (this.zMin > this.zMax) {
            tmp = this.zMin;
            this.zMin = this.zMax;
            this.zMax = tmp;
        }
    }

    @Override
    public void createLaserData() {
        this.lasersData = Utils.createLaserDataBox(this.xMin, this.yMin, this.zMin, this.xMax, this.yMax, this.zMax);
    }

    public void writeToStream(ByteBuf stream) {
        stream.writeBoolean(this.initialized);
        stream.writeInt(this.xMin);
        stream.writeInt(this.yMin);
        stream.writeInt(this.zMin);
        stream.writeInt(this.xMax);
        stream.writeInt(this.yMax);
        stream.writeInt(this.zMax);
    }

    public void readFromStream(ByteBuf stream) {
        this.initialized = stream.readBoolean();
        this.xMin = stream.readInt();
        this.yMin = stream.readInt();
        this.zMin = stream.readInt();
        this.xMax = stream.readInt();
        this.yMax = stream.readInt();
        this.zMax = stream.readInt();
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74774_a("kind", (byte)this.kind.ordinal());
        nbttagcompound.func_74768_a("xMin", this.xMin);
        nbttagcompound.func_74768_a("yMin", this.yMin);
        nbttagcompound.func_74768_a("zMin", this.zMin);
        nbttagcompound.func_74768_a("xMax", this.xMax);
        nbttagcompound.func_74768_a("yMax", this.yMax);
        nbttagcompound.func_74768_a("zMax", this.zMax);
    }

    public String toString() {
        return "{" + this.xMin + ", " + this.xMax + "}, {" + this.yMin + ", " + this.yMax + "}, {" + this.zMin + ", " + this.zMax + "}";
    }

    public Box extendToEncompass(Box toBeContained) {
        if (toBeContained == null || !toBeContained.initialized) {
            return this;
        }
        if (toBeContained.xMin < this.xMin) {
            this.xMin = toBeContained.xMin;
        }
        if (toBeContained.yMin < this.yMin) {
            this.yMin = toBeContained.yMin;
        }
        if (toBeContained.zMin < this.zMin) {
            this.zMin = toBeContained.zMin;
        }
        if (toBeContained.xMax > this.xMax) {
            this.xMax = toBeContained.xMax;
        }
        if (toBeContained.yMax > this.yMax) {
            this.yMax = toBeContained.yMax;
        }
        if (toBeContained.zMax > this.zMax) {
            this.zMax = toBeContained.zMax;
        }
        return this;
    }

    public AxisAlignedBB getBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.xMin, (double)this.yMin, (double)this.zMin, (double)this.xMax, (double)this.yMax, (double)this.zMax);
    }

    public Box extendToEncompass(Position toBeContained) {
        if (toBeContained.x < (double)this.xMin) {
            this.xMin = (int)toBeContained.x - 1;
        }
        if (toBeContained.y < (double)this.yMin) {
            this.yMin = (int)toBeContained.y - 1;
        }
        if (toBeContained.z < (double)this.zMin) {
            this.zMin = (int)toBeContained.z - 1;
        }
        if (toBeContained.x > (double)this.xMax) {
            this.xMax = (int)toBeContained.x + 1;
        }
        if (toBeContained.y > (double)this.yMax) {
            this.yMax = (int)toBeContained.y + 1;
        }
        if (toBeContained.z > (double)this.zMax) {
            this.zMax = (int)toBeContained.z + 1;
        }
        return this;
    }

    public static enum Kind {
        LASER_RED,
        LASER_YELLOW,
        LASER_GREEN,
        LASER_BLUE,
        STRIPES;

    }
}

