/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.blueprints;

import buildcraft.api.blueprints.Schematic;
import buildcraft.api.blueprints.SchematicBlock;
import buildcraft.api.blueprints.SchematicEntity;
import buildcraft.api.blueprints.SchematicRegistry;
import buildcraft.api.core.BCLog;
import buildcraft.api.core.BuildCraftAPI;
import buildcraft.api.core.IInvSlot;
import buildcraft.api.core.StackKey;
import buildcraft.builders.TileAbstractBuilder;
import buildcraft.core.BlockIndex;
import buildcraft.core.blueprints.Blueprint;
import buildcraft.core.blueprints.BptBuilderBase;
import buildcraft.core.blueprints.BuildingSlot;
import buildcraft.core.blueprints.BuildingSlotBlock;
import buildcraft.core.blueprints.BuildingSlotEntity;
import buildcraft.core.blueprints.BuildingSlotIterator;
import buildcraft.core.inventory.InventoryCopy;
import buildcraft.core.inventory.InventoryIterator;
import buildcraft.core.inventory.StackHelper;
import buildcraft.core.utils.BlockUtil;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeSet;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.util.ForgeDirection;

public class BptBuilderBlueprint
extends BptBuilderBase {
    public LinkedList<ItemStack> neededItems = new LinkedList();
    protected TreeSet<Integer> builtEntities = new TreeSet();
    private LinkedList<BuildingSlotBlock> buildList = new LinkedList();
    private LinkedList<BuildingSlotEntity> entityList = new LinkedList();
    private LinkedList<BuildingSlot> postProcessing = new LinkedList();
    private BuildingSlotIterator iterator;

    public BptBuilderBlueprint(Blueprint bluePrint, World world, int x, int y, int z) {
        super(bluePrint, world, x, y, z);
    }

    @Override
    protected void initialize() {
        for (int j = this.blueprint.sizeY - 1; j >= 0; --j) {
            for (int i = 0; i < this.blueprint.sizeX; ++i) {
                for (int k = 0; k < this.blueprint.sizeZ; ++k) {
                    SchematicBlock slot;
                    int xCoord = i + this.x - this.blueprint.anchorX;
                    int yCoord = j + this.y - this.blueprint.anchorY;
                    int zCoord = k + this.z - this.blueprint.anchorZ;
                    if (yCoord < 0 || yCoord >= this.context.world.func_72800_K() || this.clearedLocations.contains(new BlockIndex(xCoord, yCoord, zCoord)) || (slot = (SchematicBlock)this.blueprint.contents[i][j][k]) == null && !this.blueprint.excavate) continue;
                    if (slot == null) {
                        slot = new SchematicBlock();
                        slot.meta = 0;
                        slot.block = Blocks.field_150350_a;
                    }
                    if (!SchematicRegistry.isAllowedForBuilding(slot.block)) continue;
                    BuildingSlotBlock b = new BuildingSlotBlock();
                    b.schematic = slot;
                    b.x = xCoord;
                    b.y = yCoord;
                    b.z = zCoord;
                    b.mode = BuildingSlotBlock.Mode.ClearIfInvalid;
                    b.buildStage = 0;
                    this.buildList.add(b);
                }
            }
        }
        LinkedList<BuildingSlotBlock> tmpStandalone = new LinkedList<BuildingSlotBlock>();
        LinkedList<BuildingSlotBlock> tmpSupported = new LinkedList<BuildingSlotBlock>();
        LinkedList<BuildingSlotBlock> tmpExpanding = new LinkedList<BuildingSlotBlock>();
        for (int j = 0; j < this.blueprint.sizeY; ++j) {
            for (int i = 0; i < this.blueprint.sizeX; ++i) {
                for (int k = 0; k < this.blueprint.sizeZ; ++k) {
                    int xCoord = i + this.x - this.blueprint.anchorX;
                    int yCoord = j + this.y - this.blueprint.anchorY;
                    int zCoord = k + this.z - this.blueprint.anchorZ;
                    SchematicBlock slot = (SchematicBlock)this.blueprint.contents[i][j][k];
                    if (slot == null || yCoord < 0 || yCoord >= this.context.world.func_72800_K() || !SchematicRegistry.isAllowedForBuilding(slot.block)) continue;
                    BuildingSlotBlock b = new BuildingSlotBlock();
                    b.schematic = slot;
                    b.x = xCoord;
                    b.y = yCoord;
                    b.z = zCoord;
                    b.mode = BuildingSlotBlock.Mode.Build;
                    if (!this.builtLocations.contains(new BlockIndex(xCoord, yCoord, zCoord))) {
                        switch (slot.getBuildStage()) {
                            case STANDALONE: {
                                tmpStandalone.add(b);
                                b.buildStage = 1;
                                break;
                            }
                            case SUPPORTED: {
                                tmpSupported.add(b);
                                b.buildStage = 2;
                                break;
                            }
                            case EXPANDING: {
                                tmpExpanding.add(b);
                                b.buildStage = 3;
                            }
                        }
                        continue;
                    }
                    this.postProcessing.add(b);
                }
            }
        }
        this.buildList.addAll(tmpStandalone);
        this.buildList.addAll(tmpSupported);
        this.buildList.addAll(tmpExpanding);
        this.iterator = new BuildingSlotIterator(this.buildList);
        int seqId = 0;
        for (SchematicEntity e : ((Blueprint)this.blueprint).entities) {
            BuildingSlotEntity b = new BuildingSlotEntity();
            b.schematic = e;
            b.sequenceNumber = seqId;
            if (!this.builtEntities.contains(seqId)) {
                this.entityList.add(b);
            } else {
                this.postProcessing.add(b);
            }
            ++seqId;
        }
        this.recomputeNeededItems();
    }

    public void deploy() {
        if (!this.initialized) {
            this.initialize();
            this.initialized = true;
        }
        for (BuildingSlotBlock b : this.buildList) {
            if (b.mode == BuildingSlotBlock.Mode.ClearIfInvalid) {
                this.context.world.func_147468_f(b.x, b.y, b.z);
                continue;
            }
            if (b.schematic.doNotBuild()) continue;
            b.stackConsumed = new LinkedList();
            try {
                for (ItemStack stk : b.getRequirements(this.context)) {
                    if (stk == null) continue;
                    b.stackConsumed.add(stk.func_77946_l());
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                BCLog.logger.throwing("BptBuilderBlueprint", "checkRequirements", t);
            }
            b.writeToWorld(this.context);
        }
        for (BuildingSlotEntity e : this.entityList) {
            e.stackConsumed = new LinkedList();
            try {
                for (ItemStack stk : e.getRequirements(this.context)) {
                    if (stk == null) continue;
                    e.stackConsumed.add(stk.func_77946_l());
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                BCLog.logger.throwing("BptBuilderBlueprint", "checkRequirements", t);
            }
            e.writeToWorld(this.context);
        }
        for (BuildingSlotBlock b : this.buildList) {
            if (b.mode == BuildingSlotBlock.Mode.ClearIfInvalid) continue;
            b.postProcessing(this.context);
        }
        for (BuildingSlotEntity e : this.entityList) {
            e.postProcessing(this.context);
        }
    }

    private void checkDone() {
        this.recomputeNeededItems();
        this.done = this.buildList.size() == 0 && this.entityList.size() == 0;
    }

    @Override
    public BuildingSlot getNextBlock(World world, TileAbstractBuilder inv) {
        if (this.buildList.size() != 0) {
            BuildingSlot slot = this.internalGetNextBlock(world, inv, this.buildList);
            this.checkDone();
            if (slot != null) {
                return slot;
            }
            return null;
        }
        if (this.entityList.size() != 0) {
            BuildingSlot slot = this.internalGetNextEntity(world, inv, this.entityList);
            this.checkDone();
            if (slot != null) {
                return slot;
            }
            return null;
        }
        this.checkDone();
        return null;
    }

    private BuildingSlot internalGetNextBlock(World world, TileAbstractBuilder builder, LinkedList<BuildingSlotBlock> list) {
        if (builder.energyAvailable() < SchematicRegistry.BREAK_ENERGY) {
            this.iterator.reset();
            return null;
        }
        this.iterator.startIteration();
        while (this.iterator.hasNext()) {
            BuildingSlotBlock slot = this.iterator.next();
            if (slot.buildStage > this.buildList.getFirst().buildStage) {
                this.iterator.reset();
                return null;
            }
            try {
                if (BlockUtil.isUnbreakableBlock(world, slot.x, slot.y, slot.z)) {
                    this.iterator.remove();
                    if (slot.mode == BuildingSlotBlock.Mode.ClearIfInvalid) {
                        this.clearedLocations.add(new BlockIndex(slot.x, slot.y, slot.z));
                        continue;
                    }
                    this.builtLocations.add(new BlockIndex(slot.x, slot.y, slot.z));
                    continue;
                }
                if (!slot.isAlreadyBuilt(this.context)) {
                    if (slot.mode == BuildingSlotBlock.Mode.ClearIfInvalid) {
                        if (BuildCraftAPI.isSoftBlock((IBlockAccess)world, slot.x, slot.y, slot.z)) {
                            this.iterator.remove();
                            this.clearedLocations.add(new BlockIndex(slot.x, slot.y, slot.z));
                            continue;
                        }
                        if (!this.setupForDestroy(builder, this.context, slot)) continue;
                        this.iterator.remove();
                        this.clearedLocations.add(new BlockIndex(slot.x, slot.y, slot.z));
                        return slot;
                    }
                    if (!slot.schematic.doNotBuild()) {
                        if (!this.checkRequirements(builder, slot.schematic)) continue;
                        this.useRequirements(builder, slot);
                        this.iterator.remove();
                        this.postProcessing.add(slot);
                        this.builtLocations.add(new BlockIndex(slot.x, slot.y, slot.z));
                        return slot;
                    }
                    this.postProcessing.add(slot);
                    this.iterator.remove();
                    continue;
                }
                if (slot.mode == BuildingSlotBlock.Mode.Build) {
                    this.postProcessing.add(slot);
                }
                this.iterator.remove();
            }
            catch (Throwable t) {
                t.printStackTrace();
                BCLog.logger.throwing("BptBuilderBlueprint", "internalGetBlock", t);
                this.iterator.remove();
            }
        }
        return null;
    }

    private BuildingSlot internalGetNextEntity(World world, TileAbstractBuilder builder, LinkedList<BuildingSlotEntity> list) {
        Iterator it = list.iterator();
        while (it.hasNext()) {
            BuildingSlotEntity slot = (BuildingSlotEntity)it.next();
            if (slot.isAlreadyBuilt(this.context)) {
                it.remove();
                continue;
            }
            if (!this.checkRequirements(builder, slot.schematic)) continue;
            this.useRequirements(builder, slot);
            it.remove();
            this.postProcessing.add(slot);
            this.builtEntities.add(slot.sequenceNumber);
            return slot;
        }
        return null;
    }

    public boolean checkRequirements(TileAbstractBuilder builder, Schematic slot) {
        LinkedList<ItemStack> tmpReq = new LinkedList<ItemStack>();
        try {
            LinkedList<ItemStack> req = new LinkedList<ItemStack>();
            slot.writeRequirementsToWorld(this.context, req);
            for (ItemStack stk : req) {
                if (stk == null) continue;
                tmpReq.add(stk.func_77946_l());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            BCLog.logger.throwing("BptBuilderBlueprint", "checkRequirements", t);
        }
        LinkedList<ItemStack> stacksUsed = new LinkedList<ItemStack>();
        if (this.context.world().func_72912_H().func_76077_q() == WorldSettings.GameType.CREATIVE) {
            for (ItemStack s : tmpReq) {
                stacksUsed.add(s);
            }
            return !(builder.energyAvailable() < slot.getEnergyRequirement(stacksUsed));
        }
        for (ItemStack reqStk : tmpReq) {
            for (IInvSlot slotInv : InventoryIterator.getIterable(new InventoryCopy(builder), ForgeDirection.UNKNOWN)) {
                ItemStack invStk;
                if (!builder.isBuildingMaterialSlot(slotInv.getIndex()) || (invStk = slotInv.getStackInSlot()) == null || invStk.field_77994_a <= 0 || !StackHelper.isCraftingEquivalent(reqStk, invStk, true)) continue;
                try {
                    stacksUsed.add(slot.useItem(this.context, reqStk, slotInv));
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    BCLog.logger.throwing("BptBuilderBlueprint", "checkRequirements", t);
                }
                if (reqStk.field_77994_a != 0) continue;
                break;
            }
            if (reqStk.field_77994_a == 0) continue;
            return false;
        }
        return !(builder.energyAvailable() < slot.getEnergyRequirement(stacksUsed));
    }

    public void useRequirements(TileAbstractBuilder builder, BuildingSlot slot) {
        LinkedList<ItemStack> tmpReq = new LinkedList<ItemStack>();
        try {
            for (ItemStack stk : slot.getRequirements(this.context)) {
                if (stk == null) continue;
                tmpReq.add(stk.func_77946_l());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            BCLog.logger.throwing("BptBuilderBlueprint", "useRequirements", t);
        }
        if (this.context.world().func_72912_H().func_76077_q() == WorldSettings.GameType.CREATIVE) {
            for (ItemStack s : tmpReq) {
                slot.addStackConsumed(s);
            }
            builder.consumeEnergy(slot.getEnergyRequirement());
            return;
        }
        ListIterator<ItemStack> itr = tmpReq.listIterator();
        while (itr.hasNext()) {
            ItemStack reqStk = (ItemStack)itr.next();
            boolean smallStack = reqStk.field_77994_a == 1;
            ItemStack usedStack = reqStk;
            for (IInvSlot slotInv : InventoryIterator.getIterable(builder, ForgeDirection.UNKNOWN)) {
                ItemStack invStk;
                if (!builder.isBuildingMaterialSlot(slotInv.getIndex()) || (invStk = slotInv.getStackInSlot()) == null || invStk.field_77994_a <= 0 || !StackHelper.isCraftingEquivalent(reqStk, invStk, true)) continue;
                try {
                    usedStack = slot.getSchematic().useItem(this.context, reqStk, slotInv);
                    slot.addStackConsumed(usedStack);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    BCLog.logger.throwing("BptBuilderBlueprint", "useRequirements", t);
                }
                if (reqStk.field_77994_a != 0) continue;
                break;
            }
            if (reqStk.field_77994_a != 0) {
                return;
            }
            if (!smallStack) continue;
            itr.set(usedStack);
        }
        builder.consumeEnergy(slot.getEnergyRequirement());
    }

    public void recomputeNeededItems() {
        Integer num;
        StackKey key;
        LinkedList<Object> stacks;
        this.neededItems.clear();
        HashMap<StackKey, Integer> computeStacks = new HashMap<StackKey, Integer>();
        for (BuildingSlot buildingSlot : this.buildList) {
            stacks = new LinkedList();
            try {
                stacks = buildingSlot.getRequirements(this.context);
            }
            catch (Throwable t) {
                t.printStackTrace();
                BCLog.logger.throwing("BptBuilderBlueprint", "recomputeIfNeeded", t);
            }
            for (ItemStack itemStack : stacks) {
                if (itemStack == null || itemStack.func_77973_b() == null || itemStack.field_77994_a == 0) continue;
                key = new StackKey(itemStack);
                if (!computeStacks.containsKey(key)) {
                    computeStacks.put(key, itemStack.field_77994_a);
                    continue;
                }
                num = (Integer)computeStacks.get(key);
                num = num + itemStack.field_77994_a;
                computeStacks.put(key, num);
            }
        }
        for (BuildingSlotEntity buildingSlotEntity : this.entityList) {
            stacks = new LinkedList();
            try {
                stacks = buildingSlotEntity.getRequirements(this.context);
            }
            catch (Throwable t) {
                t.printStackTrace();
                BCLog.logger.throwing("BptBuilderBlueprint", "recomputeIfNeeded", t);
            }
            for (ItemStack itemStack : stacks) {
                if (itemStack == null || itemStack.func_77973_b() == null || itemStack.field_77994_a == 0) continue;
                key = new StackKey(itemStack);
                if (!computeStacks.containsKey(key)) {
                    computeStacks.put(key, itemStack.field_77994_a);
                    continue;
                }
                num = (Integer)computeStacks.get(key);
                num = num + itemStack.field_77994_a;
                computeStacks.put(key, num);
            }
        }
        for (Map.Entry entry : computeStacks.entrySet()) {
            ItemStack newStack = ((StackKey)entry.getKey()).stack.func_77946_l();
            newStack.field_77994_a = (Integer)entry.getValue();
            this.neededItems.add(newStack);
        }
        LinkedList<ItemStack> sortedList = new LinkedList<ItemStack>();
        for (ItemStack toInsert : this.neededItems) {
            int index = 0;
            boolean bl = false;
            for (ItemStack inserted : sortedList) {
                if (inserted.field_77994_a < toInsert.field_77994_a) {
                    sortedList.add(index, toInsert);
                    bl = true;
                    break;
                }
                ++index;
            }
            if (bl) continue;
            sortedList.addLast(toInsert);
        }
        Collections.sort(this.neededItems, new Comparator<ItemStack>(){

            @Override
            public int compare(ItemStack o1, ItemStack o2) {
                if (o1.field_77994_a > o2.field_77994_a) {
                    return -1;
                }
                if (o1.field_77994_a < o2.field_77994_a) {
                    return 1;
                }
                if (Item.func_150891_b((Item)o1.func_77973_b()) > Item.func_150891_b((Item)o2.func_77973_b())) {
                    return -1;
                }
                if (Item.func_150891_b((Item)o1.func_77973_b()) < Item.func_150891_b((Item)o2.func_77973_b())) {
                    return 1;
                }
                if (o1.func_77960_j() > o2.func_77960_j()) {
                    return -1;
                }
                if (o1.func_77960_j() < o2.func_77960_j()) {
                    return 1;
                }
                return 0;
            }
        });
    }

    @Override
    public void postProcessing(World world) {
        for (BuildingSlot s : this.postProcessing) {
            try {
                s.postProcessing(this.context);
            }
            catch (Throwable t) {
                t.printStackTrace();
                BCLog.logger.throwing("BptBuilderBlueprint", "postProcessing", t);
            }
        }
    }

    @Override
    public void saveBuildStateToNBT(NBTTagCompound nbt, TileAbstractBuilder builder) {
        super.saveBuildStateToNBT(nbt, builder);
        int[] entitiesBuiltArr = new int[this.builtEntities.size()];
        int id = 0;
        for (Integer i : this.builtEntities) {
            entitiesBuiltArr[id] = i;
            ++id;
        }
        nbt.func_74783_a("builtEntities", entitiesBuiltArr);
    }

    @Override
    public void loadBuildStateToNBT(NBTTagCompound nbt, TileAbstractBuilder builder) {
        super.loadBuildStateToNBT(nbt, builder);
        int[] entitiesBuiltArr = nbt.func_74759_k("builtEntities");
        for (int i = 0; i < entitiesBuiltArr.length; ++i) {
            this.builtEntities.add(i);
        }
    }
}

