/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.gui.buttons;

import buildcraft.core.DefaultProps;
import buildcraft.core.gui.buttons.IButtonTextureSet;
import buildcraft.core.gui.buttons.StandardButtonTextureSets;
import buildcraft.core.gui.tooltips.IToolTipProvider;
import buildcraft.core.gui.tooltips.ToolTip;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiBetterButton
extends GuiButton
implements IToolTipProvider {
    public static final ResourceLocation BUTTON_TEXTURES = new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_GUI + "/buttons.png");
    protected final IButtonTextureSet texture;
    private ToolTip toolTip;

    public GuiBetterButton(int id, int x, int y, String label) {
        this(id, x, y, 200, StandardButtonTextureSets.LARGE_BUTTON, label);
    }

    public GuiBetterButton(int id, int x, int y, int width, String label) {
        this(id, x, y, width, StandardButtonTextureSets.LARGE_BUTTON, label);
    }

    public GuiBetterButton(int id, int x, int y, int width, IButtonTextureSet texture, String label) {
        super(id, x, y, width, texture.getHeight(), label);
        this.texture = texture;
    }

    public int getWidth() {
        return this.field_146120_f;
    }

    public int getHeight() {
        return this.texture.getHeight();
    }

    public int getTextColor(boolean mouseOver) {
        if (!this.field_146124_l) {
            return -6250336;
        }
        if (mouseOver) {
            return 0xFFFFA0;
        }
        return 0xE0E0E0;
    }

    public boolean isMouseOverButton(int mouseX, int mouseY) {
        return mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.getHeight();
    }

    protected void bindButtonTextures(Minecraft minecraft) {
        minecraft.field_71446_o.func_110577_a(BUTTON_TEXTURES);
    }

    public void func_146112_a(Minecraft minecraft, int mouseX, int mouseY) {
        if (!this.field_146125_m) {
            return;
        }
        FontRenderer fontrenderer = minecraft.field_71466_p;
        this.bindButtonTextures(minecraft);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int xOffset = this.texture.getX();
        int yOffset = this.texture.getY();
        int h = this.texture.getHeight();
        int w = this.texture.getWidth();
        boolean mouseOver = this.isMouseOverButton(mouseX, mouseY);
        int hoverState = this.func_146114_a(mouseOver);
        this.func_73729_b(this.field_146128_h, this.field_146129_i, xOffset, yOffset + hoverState * h, this.field_146120_f / 2, h);
        this.func_73729_b(this.field_146128_h + this.field_146120_f / 2, this.field_146129_i, xOffset + w - this.field_146120_f / 2, yOffset + hoverState * h, this.field_146120_f / 2, h);
        this.func_146119_b(minecraft, mouseX, mouseY);
        this.func_73732_a(fontrenderer, this.field_146126_j, this.field_146128_h + this.field_146120_f / 2, this.field_146129_i + (h - 8) / 2, this.getTextColor(mouseOver));
    }

    @Override
    public ToolTip getToolTip() {
        return this.toolTip;
    }

    public void setToolTip(ToolTip tips) {
        this.toolTip = tips;
    }

    @Override
    public boolean isToolTipVisible() {
        return this.field_146125_m;
    }

    @Override
    public boolean isMouseOver(int mouseX, int mouseY) {
        return this.isMouseOverButton(mouseX, mouseY);
    }
}

