/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.network.serializers;

import buildcraft.core.network.serializers.ClassSerializer;
import buildcraft.core.network.serializers.SerializationContext;
import buildcraft.core.network.serializers.SerializerObject;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;

public class SerializerArrayList
extends ClassSerializer {
    private static SerializerObject anonymousSerializer = new SerializerObject();

    @Override
    public void write(ByteBuf data, Object o, SerializationContext context) throws IllegalArgumentException, IllegalAccessException {
        ArrayList list = (ArrayList)o;
        if (o == null) {
            data.writeBoolean(false);
        } else {
            data.writeBoolean(true);
            data.writeShort(list.size());
            for (Object val : list) {
                anonymousSerializer.write(data, val, context);
            }
        }
    }

    @Override
    public Object read(ByteBuf data, Object o, SerializationContext context) throws IllegalArgumentException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        if (!data.readBoolean()) {
            return null;
        }
        int size = data.readShort();
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < size; ++i) {
            Object val = anonymousSerializer.read(data, null, context);
            list.add(val);
        }
        return list;
    }
}

