/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.triggers;

import buildcraft.api.gates.ITileTrigger;
import buildcraft.api.gates.ITrigger;
import buildcraft.api.gates.ITriggerParameter;
import buildcraft.core.triggers.BCTrigger;
import buildcraft.core.utils.StringUtils;
import java.util.Locale;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TriggerFluidContainer
extends BCTrigger
implements ITileTrigger {
    public State state;

    public TriggerFluidContainer(State state) {
        super("buildcraft:fluid." + state.name().toLowerCase(Locale.ENGLISH), "buildcraft.fluid." + state.name().toLowerCase(Locale.ENGLISH));
        this.state = state;
    }

    @Override
    public boolean hasParameter() {
        return this.state == State.Contains || this.state == State.Space;
    }

    @Override
    public String getDescription() {
        return StringUtils.localize("gate.trigger.fluid." + this.state.name().toLowerCase(Locale.ENGLISH));
    }

    @Override
    public boolean isTriggerActive(ForgeDirection side, TileEntity tile, ITriggerParameter parameter) {
        if (tile instanceof IFluidHandler) {
            FluidTankInfo[] liquids;
            IFluidHandler container = (IFluidHandler)tile;
            FluidStack searchedFluid = null;
            if (parameter != null && parameter.getItemStack() != null) {
                searchedFluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)parameter.getItemStack());
            }
            if (searchedFluid != null) {
                searchedFluid.amount = 1;
            }
            if ((liquids = container.getTankInfo(side)) == null || liquids.length == 0) {
                return false;
            }
            switch (this.state) {
                case Empty: {
                    for (FluidTankInfo c : liquids) {
                        if (c.fluid == null || c.fluid.amount <= 0 || searchedFluid != null && !searchedFluid.isFluidEqual(c.fluid)) continue;
                        return false;
                    }
                    return true;
                }
                case Contains: {
                    for (FluidTankInfo c : liquids) {
                        if (c.fluid == null || c.fluid.amount <= 0 || searchedFluid != null && !searchedFluid.isFluidEqual(c.fluid)) continue;
                        return true;
                    }
                    return false;
                }
                case Space: {
                    if (searchedFluid == null) {
                        for (FluidTankInfo c : liquids) {
                            if (c.fluid != null && c.fluid.amount >= c.capacity) continue;
                            return true;
                        }
                        return false;
                    }
                    return container.fill(side, searchedFluid, false) > 0;
                }
                case Full: {
                    if (searchedFluid == null) {
                        for (FluidTankInfo c : liquids) {
                            if (c.fluid != null && c.fluid.amount >= c.capacity) continue;
                            return false;
                        }
                        return true;
                    }
                    return container.fill(side, searchedFluid, false) <= 0;
                }
            }
        }
        return false;
    }

    @Override
    public int getIconIndex() {
        switch (this.state) {
            case Empty: {
                return 11;
            }
            case Contains: {
                return 12;
            }
            case Space: {
                return 13;
            }
        }
        return 14;
    }

    @Override
    public ITrigger rotateLeft() {
        return this;
    }

    public static enum State {
        Empty,
        Contains,
        Space,
        Full;

    }
}

