/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.triggers;

import buildcraft.api.gates.ITileTrigger;
import buildcraft.api.gates.ITrigger;
import buildcraft.api.gates.ITriggerParameter;
import buildcraft.core.triggers.BCTrigger;
import buildcraft.core.utils.StringUtils;
import java.util.Locale;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TriggerFluidContainerLevel
extends BCTrigger
implements ITileTrigger {
    public TriggerType type;

    public TriggerFluidContainerLevel(TriggerType type) {
        super("buildcraft:fluid." + type.name().toLowerCase(Locale.ENGLISH), "buildcraft.fluid." + type.name().toLowerCase(Locale.ENGLISH));
        this.type = type;
    }

    @Override
    public boolean hasParameter() {
        return true;
    }

    @Override
    public String getDescription() {
        return String.format(StringUtils.localize("gate.trigger.fluidlevel.below"), (int)(this.type.level * 100.0f));
    }

    @Override
    public boolean isTriggerActive(ForgeDirection side, TileEntity tile, ITriggerParameter parameter) {
        if (tile instanceof IFluidHandler) {
            FluidTankInfo[] liquids;
            IFluidHandler container = (IFluidHandler)tile;
            FluidStack searchedFluid = null;
            if (parameter != null && parameter.getItemStack() != null) {
                searchedFluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)parameter.getItemStack());
            }
            if (searchedFluid != null) {
                searchedFluid.amount = 1;
            }
            if ((liquids = container.getTankInfo(side)) == null || liquids.length == 0) {
                return false;
            }
            for (FluidTankInfo c : liquids) {
                if (c.fluid == null) {
                    if (searchedFluid == null) {
                        return true;
                    }
                    return container.fill(side, searchedFluid, false) > 0;
                }
                if (searchedFluid != null && !searchedFluid.isFluidEqual(c.fluid)) continue;
                float percentage = (float)c.fluid.amount / (float)c.capacity;
                return percentage < this.type.level;
            }
        }
        return false;
    }

    @Override
    public int getIconIndex() {
        switch (this.type) {
            case BELOW_25: {
                return 36;
            }
            case BELOW_50: {
                return 37;
            }
        }
        return 38;
    }

    @Override
    public ITrigger rotateLeft() {
        return this;
    }

    public static enum TriggerType {
        BELOW_25(0.25f),
        BELOW_50(0.5f),
        BELOW_75(0.75f);

        public final float level;

        private TriggerType(float level) {
            this.level = level;
        }
    }
}

