/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.triggers;

import buildcraft.api.core.IInvSlot;
import buildcraft.api.gates.ITileTrigger;
import buildcraft.api.gates.ITrigger;
import buildcraft.api.gates.ITriggerParameter;
import buildcraft.core.inventory.InventoryIterator;
import buildcraft.core.inventory.StackHelper;
import buildcraft.core.triggers.BCTrigger;
import buildcraft.core.utils.StringUtils;
import java.util.Locale;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TriggerInventory
extends BCTrigger
implements ITileTrigger {
    public State state;

    public TriggerInventory(State state) {
        super("buildcraft:inventory." + state.name().toLowerCase(Locale.ENGLISH), "buildcraft.inventory." + state.name().toLowerCase(Locale.ENGLISH));
        this.state = state;
    }

    @Override
    public boolean hasParameter() {
        return this.state == State.Contains || this.state == State.Space;
    }

    @Override
    public String getDescription() {
        return StringUtils.localize("gate.trigger.inventory." + this.state.name().toLowerCase(Locale.ENGLISH));
    }

    @Override
    public boolean isTriggerActive(ForgeDirection side, TileEntity tile, ITriggerParameter parameter) {
        ItemStack searchedStack = null;
        if (parameter != null) {
            searchedStack = parameter.getItemStack();
        }
        if (tile instanceof IInventory) {
            boolean hasSlots = false;
            boolean foundItems = false;
            boolean foundSpace = false;
            for (IInvSlot slot : InventoryIterator.getIterable((IInventory)tile, side)) {
                hasSlots = true;
                ItemStack stack = slot.getStackInSlot();
                foundItems |= stack != null && (searchedStack == null || StackHelper.canStacksMerge(stack, searchedStack));
                foundSpace |= (stack == null || StackHelper.canStacksMerge(stack, searchedStack) && stack.field_77994_a < stack.func_77976_d()) && (searchedStack == null || slot.canPutStackInSlot(searchedStack));
            }
            if (!hasSlots) {
                return false;
            }
            switch (this.state) {
                case Empty: {
                    return !foundItems;
                }
                case Contains: {
                    return foundItems;
                }
                case Space: {
                    return foundSpace;
                }
            }
            return !foundSpace;
        }
        return false;
    }

    @Override
    public int getIconIndex() {
        switch (this.state) {
            case Empty: {
                return 7;
            }
            case Contains: {
                return 8;
            }
            case Space: {
                return 9;
            }
        }
        return 10;
    }

    @Override
    public ITrigger rotateLeft() {
        return this;
    }

    public static enum State {
        Empty,
        Contains,
        Space,
        Full;

    }
}

