/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.triggers;

import buildcraft.api.gates.ITileTrigger;
import buildcraft.api.gates.ITrigger;
import buildcraft.api.gates.ITriggerParameter;
import buildcraft.core.IMachine;
import buildcraft.core.triggers.BCTrigger;
import buildcraft.core.utils.StringUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TriggerMachine
extends BCTrigger
implements ITileTrigger {
    boolean active;

    public TriggerMachine(boolean active) {
        super("buildcraft:work." + (active ? "scheduled" : "done"), "buildcraft.work." + (active ? "scheduled" : "done"));
        this.active = active;
    }

    @Override
    public String getDescription() {
        return StringUtils.localize("gate.trigger.machine." + (this.active ? "scheduled" : "done"));
    }

    @Override
    public boolean isTriggerActive(ForgeDirection side, TileEntity tile, ITriggerParameter parameter) {
        if (tile instanceof IMachine) {
            IMachine machine = (IMachine)tile;
            if (this.active) {
                return machine.isActive();
            }
            return !machine.isActive();
        }
        return false;
    }

    @Override
    public int getIconIndex() {
        if (this.active) {
            return 15;
        }
        return 16;
    }

    @Override
    public ITrigger rotateLeft() {
        return this;
    }
}

