/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy;

import buildcraft.api.core.NetworkData;
import buildcraft.api.tools.IToolWrench;
import buildcraft.core.utils.StringUtils;
import buildcraft.energy.TileEngine;
import buildcraft.transport.pipes.PipePowerIron;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEngineCreative
extends TileEngine {
    @NetworkData
    private PipePowerIron.PowerMode powerMode = PipePowerIron.PowerMode.M2;

    @Override
    public ResourceLocation getBaseTexture() {
        return BASE_TEXTURES[3];
    }

    @Override
    public ResourceLocation getChamberTexture() {
        return CHAMBER_TEXTURES[3];
    }

    @Override
    public ResourceLocation getTrunkTexture(TileEngine.EnergyStage stage) {
        return TRUNK_TEXTURES[3];
    }

    @Override
    protected TileEngine.EnergyStage computeEnergyStage() {
        return TileEngine.EnergyStage.BLUE;
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, ForgeDirection side) {
        if (!this.getWorld().field_72995_K) {
            Item equipped;
            Item item = equipped = player.func_71045_bC() != null ? player.func_71045_bC().func_77973_b() : null;
            if (equipped instanceof IToolWrench && ((IToolWrench)equipped).canWrench(player, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                this.powerMode = this.powerMode.getNext();
                this.energy = 0.0;
                player.func_145747_a((IChatComponent)new ChatComponentText(String.format(StringUtils.localize("chat.pipe.power.iron.mode"), this.powerMode.maxPower)));
                this.sendNetworkUpdate();
                ((IToolWrench)equipped).wrenchUsed(player, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                return true;
            }
        }
        return !player.func_70093_af();
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.powerMode = PipePowerIron.PowerMode.fromId(data.func_74771_c("mode"));
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        data.func_74774_a("mode", (byte)this.powerMode.ordinal());
    }

    @Override
    public float getPistonSpeed() {
        return 0.02f * (float)(this.powerMode.ordinal() + 1);
    }

    @Override
    public void engineUpdate() {
        super.engineUpdate();
        if (this.isRedstonePowered) {
            this.addEnergy(this.getCurrentOutput());
        }
    }

    @Override
    public boolean isBurning() {
        return this.isRedstonePowered;
    }

    @Override
    public int getScaledBurnTime(int scale) {
        return 0;
    }

    @Override
    public double maxEnergyReceived() {
        return this.getCurrentOutput();
    }

    @Override
    public double maxEnergyExtracted() {
        return this.getCurrentOutput();
    }

    @Override
    public double getMaxEnergy() {
        return this.getCurrentOutput();
    }

    @Override
    public double getCurrentOutput() {
        return this.powerMode.maxPower;
    }

    @Override
    public float explosionRange() {
        return 0.0f;
    }
}

