/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.core.EntityBlock;
import buildcraft.factory.FactoryProxy;
import buildcraft.factory.TileQuarry;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class EntityMechanicalArm
extends Entity {
    protected TileQuarry parent;
    private double armSizeX;
    private double armSizeZ;
    private double xRoot;
    private double yRoot;
    private double zRoot;
    private boolean inProgressionXZ = false;
    private boolean inProgressionY = false;
    private int headX;
    private int headY;
    private int headZ;
    private EntityBlock xArm;
    private EntityBlock yArm;
    private EntityBlock zArm;
    private EntityBlock head;

    public EntityMechanicalArm(World world) {
        super(world);
        this.makeParts(world);
        this.field_70145_X = true;
    }

    public EntityMechanicalArm(World world, double x, double y, double z, double width, double height, TileQuarry parent) {
        this(world);
        this.func_70080_a(parent.field_145851_c, parent.field_145848_d, parent.field_145849_e, 0.0f, 0.0f);
        this.xRoot = x;
        this.yRoot = y;
        this.zRoot = z;
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.setArmSize(width, height);
        this.setHead(x, y - 2.0, z);
        this.parent = parent;
        parent.setArm(this);
        this.updatePosition();
    }

    void setHead(double x, double y, double z) {
        this.headX = (int)(x * 32.0);
        this.headY = (int)(y * 32.0);
        this.headZ = (int)(z * 32.0);
    }

    private void setArmSize(double x, double z) {
        this.armSizeX = x;
        this.xArm.iSize = x;
        this.armSizeZ = z;
        this.zArm.kSize = z;
        this.updatePosition();
    }

    private void makeParts(World world) {
        this.xArm = FactoryProxy.proxy.newDrill(world, 0.0, 0.0, 0.0, 1.0, 0.5, 0.5);
        this.yArm = FactoryProxy.proxy.newDrill(world, 0.0, 0.0, 0.0, 0.5, 1.0, 0.5);
        this.zArm = FactoryProxy.proxy.newDrill(world, 0.0, 0.0, 0.0, 0.5, 0.5, 1.0);
        this.head = FactoryProxy.proxy.newDrillHead(world, 0.0, 0.0, 0.0, 0.2, 1.0, 0.2);
        this.head.shadowSize = 1.0f;
        world.func_72838_d((Entity)this.xArm);
        world.func_72838_d((Entity)this.yArm);
        world.func_72838_d((Entity)this.zArm);
        world.func_72838_d((Entity)this.head);
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        this.xRoot = nbttagcompound.func_74769_h("xRoot");
        this.yRoot = nbttagcompound.func_74769_h("yRoot");
        this.zRoot = nbttagcompound.func_74769_h("zRoot");
        this.armSizeX = nbttagcompound.func_74769_h("armSizeX");
        this.armSizeZ = nbttagcompound.func_74769_h("armSizeZ");
        this.setArmSize(this.armSizeX, this.armSizeZ);
        this.updatePosition();
    }

    private void findAndJoinQuarry() {
        TileEntity te = this.field_70170_p.func_147438_o((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
        if (te != null && te instanceof TileQuarry) {
            this.parent = (TileQuarry)te;
            this.parent.setArm(this);
        } else {
            this.func_70106_y();
        }
    }

    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74780_a("xRoot", this.xRoot);
        nbttagcompound.func_74780_a("yRoot", this.yRoot);
        nbttagcompound.func_74780_a("zRoot", this.zRoot);
        nbttagcompound.func_74780_a("armSizeX", this.armSizeX);
        nbttagcompound.func_74780_a("armSizeZ", this.armSizeZ);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.updatePosition();
        if (this.parent == null) {
            this.findAndJoinQuarry();
        }
        if (this.parent == null) {
            this.func_70106_y();
            return;
        }
    }

    public void updatePosition() {
        double[] headT = this.getHead();
        this.xArm.func_70107_b(this.xRoot, this.yRoot, headT[2] + 0.25);
        this.yArm.jSize = this.yRoot - headT[1] - 1.0;
        this.yArm.func_70107_b(headT[0] + 0.25, headT[1] + 1.0, headT[2] + 0.25);
        this.zArm.func_70107_b(headT[0] + 0.25, this.yRoot, this.zRoot);
        this.head.func_70107_b(headT[0] + 0.4, headT[1], headT[2] + 0.4);
    }

    public void func_70106_y() {
        if (this.field_70170_p != null && this.field_70170_p.field_72995_K) {
            this.xArm.func_70106_y();
            this.yArm.func_70106_y();
            this.zArm.func_70106_y();
            this.head.func_70106_y();
        }
        super.func_70106_y();
    }

    private double[] getHead() {
        return new double[]{(double)this.headX / 32.0, (double)this.headY / 32.0, (double)this.headZ / 32.0};
    }
}

