/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.BuildCraftFactory;
import buildcraft.api.core.BCLog;
import buildcraft.builders.RenderBuilder;
import buildcraft.core.EntityBlock;
import buildcraft.core.render.RenderVoid;
import buildcraft.core.render.RenderingEntityBlocks;
import buildcraft.factory.EntityMechanicalArm;
import buildcraft.factory.FactoryProxy;
import buildcraft.factory.TileHopper;
import buildcraft.factory.TileQuarry;
import buildcraft.factory.TileRefinery;
import buildcraft.factory.TileTank;
import buildcraft.factory.gui.GuiAutoCrafting;
import buildcraft.factory.render.RenderHopper;
import buildcraft.factory.render.RenderRefinery;
import buildcraft.factory.render.RenderTank;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.RenderingRegistry;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class FactoryProxyClient
extends FactoryProxy {
    public static IIcon pumpTexture;
    public static IIcon drillTexture;
    public static IIcon drillHeadTexture;

    @Override
    public void initializeTileEntities() {
        super.initializeTileEntities();
        if (BuildCraftFactory.tankBlock != null) {
            ClientRegistry.bindTileEntitySpecialRenderer(TileTank.class, (TileEntitySpecialRenderer)new RenderTank());
        }
        if (BuildCraftFactory.refineryBlock != null) {
            ClientRegistry.bindTileEntitySpecialRenderer(TileRefinery.class, (TileEntitySpecialRenderer)new RenderRefinery());
            RenderingEntityBlocks.blockByEntityRenders.put(new RenderingEntityBlocks.EntityRenderIndex((Block)BuildCraftFactory.refineryBlock, 0), new RenderRefinery());
        }
        if (BuildCraftFactory.hopperBlock != null) {
            ClientRegistry.bindTileEntitySpecialRenderer(TileHopper.class, (TileEntitySpecialRenderer)new RenderHopper());
            RenderingEntityBlocks.blockByEntityRenders.put(new RenderingEntityBlocks.EntityRenderIndex((Block)BuildCraftFactory.hopperBlock, 0), new RenderHopper());
        }
        ClientRegistry.bindTileEntitySpecialRenderer(TileQuarry.class, (TileEntitySpecialRenderer)new RenderBuilder());
    }

    @Override
    public void initializeEntityRenders() {
        RenderingRegistry.registerEntityRenderingHandler(EntityMechanicalArm.class, (Render)new RenderVoid());
    }

    @Override
    public void initializeNEIIntegration() {
        try {
            Class<?> neiRenderer = Class.forName("codechicken.nei.DefaultOverlayRenderer");
            Method method = neiRenderer.getMethod("registerGuiOverlay", Class.class, String.class, Integer.TYPE, Integer.TYPE);
            method.invoke(null, GuiAutoCrafting.class, "crafting", 5, 11);
            BCLog.logger.fine("NEI detected, adding NEI overlay");
        }
        catch (Exception e) {
            BCLog.logger.fine("NEI not detected.");
        }
    }

    @Override
    public EntityBlock newPumpTube(World w) {
        EntityBlock eb = super.newPumpTube(w);
        eb.texture = pumpTexture;
        return eb;
    }

    @Override
    public EntityBlock newDrill(World w, double i, double j, double k, double l, double d, double e) {
        EntityBlock eb = super.newDrill(w, i, j, k, l, d, e);
        eb.texture = drillTexture;
        return eb;
    }

    @Override
    public EntityBlock newDrillHead(World w, double i, double j, double k, double l, double d, double e) {
        EntityBlock eb = super.newDrillHead(w, i, j, k, l, d, e);
        eb.texture = drillHeadTexture;
        return eb;
    }
}

