/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.network;

import buildcraft.core.network.BuildCraftPacket;
import buildcraft.core.utils.Utils;
import buildcraft.transport.TravelingItem;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;

public class PacketPipeTransportItemStack
extends BuildCraftPacket {
    private ItemStack stack;
    private int entityId;

    public PacketPipeTransportItemStack() {
    }

    public PacketPipeTransportItemStack(int entityId, ItemStack stack) {
        this.entityId = entityId;
        this.stack = stack;
    }

    @Override
    public void writeData(ByteBuf data) {
        data.writeInt(this.entityId);
        Utils.writeStack(data, this.stack);
    }

    @Override
    public void readData(ByteBuf data) {
        this.entityId = data.readInt();
        this.stack = Utils.readStack(data);
        TravelingItem item = TravelingItem.clientCache.get(this.entityId);
        if (item != null) {
            item.setItemStack(this.stack);
        }
    }

    public int getEntityId() {
        return this.entityId;
    }

    public ItemStack getItemStack() {
        return this.stack;
    }

    @Override
    public int getID() {
        return 6;
    }
}

