/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.core.NetworkData;
import buildcraft.api.mj.MjBattery;
import buildcraft.api.transport.IPipeTile;
import buildcraft.api.transport.PipeManager;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeTransportFluids;
import buildcraft.transport.pipes.PipeLogicWood;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class PipeFluidsWood
extends Pipe<PipeTransportFluids> {
    @NetworkData
    public int liquidToExtract;
    protected int standardIconIndex = PipeIconProvider.TYPE.PipeFluidsWood_Standard.ordinal();
    protected int solidIconIndex = PipeIconProvider.TYPE.PipeAllWood_Solid.ordinal();
    private long lastMining = 0L;
    private boolean lastPower = false;
    @MjBattery(maxCapacity=250.0, maxReceivedPerCycle=100.0, minimumConsumption=0.0)
    private double mjStored = 0.0;
    private PipeLogicWood logic = new PipeLogicWood(this){

        @Override
        protected boolean isValidConnectingTile(TileEntity tile) {
            if (tile instanceof IPipeTile) {
                return false;
            }
            if (!(tile instanceof IFluidHandler)) {
                return false;
            }
            return PipeManager.canExtractFluids(this.pipe, tile.func_145831_w(), tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
        }
    };

    public PipeFluidsWood(Item item) {
        super(new PipeTransportFluids(), item);
    }

    @Override
    public boolean blockActivated(EntityPlayer entityplayer) {
        return this.logic.blockActivated(entityplayer);
    }

    @Override
    public void onNeighborBlockChange(int blockId) {
        this.logic.onNeighborBlockChange(blockId);
        super.onNeighborBlockChange(blockId);
    }

    @Override
    public void initialize() {
        this.logic.initialize();
        super.initialize();
    }

    @Override
    public void updateEntity() {
        ForgeDirection side;
        TileEntity tile;
        super.updateEntity();
        int meta = this.container.func_145832_p();
        if (this.liquidToExtract > 0 && meta < 6 && (tile = this.container.getTile(side = ForgeDirection.getOrientation((int)meta))) instanceof IFluidHandler) {
            IFluidHandler fluidHandler = (IFluidHandler)tile;
            int flowRate = ((PipeTransportFluids)this.transport).flowRate;
            FluidStack extracted = fluidHandler.drain(side.getOpposite(), this.liquidToExtract > flowRate ? flowRate : this.liquidToExtract, false);
            int inserted = 0;
            if (extracted != null) {
                inserted = ((PipeTransportFluids)this.transport).fill(side, extracted, true);
                fluidHandler.drain(side.getOpposite(), inserted, true);
            }
            this.liquidToExtract -= inserted;
        }
        if (this.mjStored >= 1.0) {
            World w = this.container.getWorld();
            if (meta > 5) {
                return;
            }
            tile = this.container.getTile(ForgeDirection.getOrientation((int)meta));
            if (tile instanceof IFluidHandler) {
                if (!PipeManager.canExtractFluids(this, tile.func_145831_w(), tile.field_145851_c, tile.field_145848_d, tile.field_145849_e)) {
                    return;
                }
                if (this.liquidToExtract <= 1000) {
                    this.liquidToExtract += 1000;
                }
            }
            this.mjStored -= 1.0;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return BuildCraftTransport.instance.pipeIconProvider;
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        if (direction == ForgeDirection.UNKNOWN) {
            return this.standardIconIndex;
        }
        int metadata = this.container.func_145832_p();
        if (metadata == direction.ordinal()) {
            return this.solidIconIndex;
        }
        return this.standardIconIndex;
    }

    @Override
    public boolean outputOpen(ForgeDirection to) {
        int meta = this.container.func_145832_p();
        return super.outputOpen(to) && meta != to.ordinal();
    }
}

