/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.core.Position;
import buildcraft.api.mj.MjBattery;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.BlockUtil;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.ItemPipe;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.TravelingItem;
import buildcraft.transport.pipes.events.PipeEventItem;
import buildcraft.transport.utils.TransportUtils;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;

public class PipeItemsStripes
extends Pipe<PipeTransportItems> {
    @MjBattery(maxCapacity=1.0, maxReceivedPerCycle=1.0, minimumConsumption=0.0)
    private double mjStored = 0.0;

    public PipeItemsStripes(Item item) {
        super(new PipeTransportItems(), item);
    }

    @Override
    public void updateEntity() {
        ForgeDirection o;
        super.updateEntity();
        if (this.container.func_145831_w().field_72995_K) {
            return;
        }
        if (this.mjStored > 0.0 && (o = this.getOpenOrientation()) != ForgeDirection.UNKNOWN) {
            Position p = new Position(this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e, o);
            p.moveForwards(1.0);
            if (!BlockUtil.isUnbreakableBlock(this.getWorld(), (int)p.x, (int)p.y, (int)p.z)) {
                ArrayList stacks = this.getWorld().func_147439_a((int)p.x, (int)p.y, (int)p.z).getDrops(this.getWorld(), (int)p.x, (int)p.y, (int)p.z, this.getWorld().func_72805_g((int)p.x, (int)p.y, (int)p.z), 0);
                if (stacks != null) {
                    for (ItemStack s : stacks) {
                        if (s == null) continue;
                        this.rollbackItem(s, o);
                    }
                }
                this.getWorld().func_147468_f((int)p.x, (int)p.y, (int)p.z);
            }
        }
        this.mjStored = 0.0;
    }

    public void eventHandler(PipeEventItem.DropItem event) {
        Position p = new Position(this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e, event.direction);
        Position from = new Position(p);
        p.moveForwards(1.0);
        ItemStack stack = event.entity.func_92059_d();
        if (this.convertPipe((PipeTransportItems)this.transport, event.item)) {
            BuildCraftTransport.pipeItemsStripes.func_77648_a(new ItemStack(BuildCraftTransport.pipeItemsStripes), (EntityPlayer)CoreProxy.proxy.getBuildCraftPlayer((WorldServer)this.getWorld()).get(), this.getWorld(), (int)p.x, (int)p.y, (int)p.z, 1, 0.0f, 0.0f, 0.0f);
        } else if (stack.func_77973_b() instanceof ItemBlock) {
            if (this.getWorld().func_147439_a((int)p.x, (int)p.y, (int)p.z) == Blocks.field_150350_a) {
                stack.func_77943_a((EntityPlayer)CoreProxy.proxy.getBuildCraftPlayer((WorldServer)this.getWorld()).get(), this.getWorld(), (int)p.x, (int)p.y, (int)p.z, 1, 0.0f, 0.0f, 0.0f);
            }
        } else if (stack.func_77973_b() == Items.field_151097_aZ) {
            Block block = this.getWorld().func_147439_a((int)p.x, (int)p.y, (int)p.z);
            if (block instanceof BlockLeavesBase) {
                this.getWorld().func_72908_a((double)((int)p.x), (double)((int)p.y), (double)((int)p.z), Block.field_149779_h.func_150495_a(), 1.0f, 1.0f);
                this.getWorld().func_147468_f((int)p.x, (int)p.y, (int)p.z);
                stack.func_77972_a(1, (EntityLivingBase)CoreProxy.proxy.getBuildCraftPlayer((WorldServer)this.getWorld()).get());
            }
        } else if (stack.func_77973_b() == Items.field_151032_g) {
            --stack.field_77994_a;
            ForgeDirection direction = event.direction;
            EntityArrow entityArrow = new EntityArrow(this.getWorld(), (EntityLivingBase)CoreProxy.proxy.getBuildCraftPlayer((WorldServer)this.getWorld()).get(), 0.0f);
            entityArrow.func_70107_b(p.x + 0.5, p.y + 0.5, p.z + 0.5);
            entityArrow.func_70239_b(3.0);
            entityArrow.func_70240_a(1);
            entityArrow.field_70159_w = (double)direction.offsetX * 1.8 + this.getWorld().field_73012_v.nextGaussian() * (double)0.0075f;
            entityArrow.field_70181_x = (double)direction.offsetY * 1.8 + this.getWorld().field_73012_v.nextGaussian() * (double)0.0075f;
            entityArrow.field_70179_y = (double)direction.offsetZ * 1.8 + this.getWorld().field_73012_v.nextGaussian() * (double)0.0075f;
            this.getWorld().func_72838_d((Entity)entityArrow);
        } else if (stack.func_77973_b() == Items.field_151068_bn && ItemPotion.func_77831_g((int)stack.func_77960_j()) || stack.func_77973_b() == Items.field_151110_aK || stack.func_77973_b() == Items.field_151126_ay) {
            EntityPlayer player = (EntityPlayer)CoreProxy.proxy.getBuildCraftPlayer((WorldServer)this.getWorld(), (int)p.x, (int)p.y, (int)p.z).get();
            switch (event.direction) {
                case DOWN: {
                    player.field_70125_A = 90.0f;
                    player.field_70177_z = 0.0f;
                    break;
                }
                case UP: {
                    player.field_70125_A = 270.0f;
                    player.field_70177_z = 0.0f;
                    break;
                }
                case NORTH: {
                    player.field_70125_A = 0.0f;
                    player.field_70177_z = 180.0f;
                    break;
                }
                case SOUTH: {
                    player.field_70125_A = 0.0f;
                    player.field_70177_z = 0.0f;
                    break;
                }
                case WEST: {
                    player.field_70125_A = 0.0f;
                    player.field_70177_z = 90.0f;
                    break;
                }
                case EAST: {
                    player.field_70125_A = 0.0f;
                    player.field_70177_z = 270.0f;
                    break;
                }
            }
            stack.func_77973_b().func_77659_a(stack, this.getWorld(), (EntityPlayer)CoreProxy.proxy.getBuildCraftPlayer((WorldServer)this.getWorld(), (int)p.x, (int)p.y, (int)p.z).get());
        } else if (this.getWorld().func_147439_a((int)p.x, (int)p.y, (int)p.z) == Blocks.field_150350_a) {
            if (stack.func_77973_b() instanceof ItemBucket) {
                Block underblock = this.getWorld().func_147439_a((int)p.x, (int)p.y - 1, (int)p.z);
                Item newBucket = Items.field_151133_ar;
                if (underblock == Blocks.field_150355_j) {
                    newBucket = Items.field_151131_as;
                }
                if (underblock == Blocks.field_150353_l) {
                    newBucket = Items.field_151129_at;
                }
                boolean rollback = false;
                if (((ItemBucket)stack.func_77973_b()).func_77875_a(this.getWorld(), (int)p.x, (int)p.y - 1, (int)p.z)) {
                    rollback = true;
                } else if (newBucket != Items.field_151133_ar) {
                    this.getWorld().func_147468_f((int)p.x, (int)p.y - 1, (int)p.z);
                    rollback = true;
                }
                if (rollback) {
                    stack.field_77994_a = 0;
                    this.rollbackItem(newBucket, 1, event.direction);
                }
            } else {
                stack.func_77943_a((EntityPlayer)CoreProxy.proxy.getBuildCraftPlayer((WorldServer)this.getWorld()).get(), this.getWorld(), (int)p.x, (int)p.y - 1, (int)p.z, 1, 0.0f, 0.0f, 0.0f);
            }
        } else {
            stack.func_77943_a((EntityPlayer)CoreProxy.proxy.getBuildCraftPlayer((WorldServer)this.getWorld()).get(), this.getWorld(), (int)p.x, (int)p.y, (int)p.z, 1, 0.0f, 0.0f, 0.0f);
        }
    }

    private void rollbackItem(Item item, int quantity, ForgeDirection direction) {
        this.rollbackItem(new ItemStack(item, quantity), direction);
    }

    private void rollbackItem(ItemStack itemStack, ForgeDirection direction) {
        TravelingItem newItem = TravelingItem.make((double)this.container.field_145851_c + 0.5, (float)this.container.field_145848_d + TransportUtils.getPipeFloorOf(itemStack), (double)this.container.field_145849_e + 0.5, itemStack);
        ((PipeTransportItems)this.transport).injectItem(newItem, direction.getOpposite());
    }

    public boolean convertPipe(PipeTransportItems pipe, TravelingItem item) {
        if (item.getItemStack().func_77973_b() instanceof ItemPipe && item.getItemStack().func_77973_b() != BuildCraftTransport.pipeItemsStripes) {
            Pipe newPipe = BlockGenericPipe.createPipe(item.getItemStack().func_77973_b());
            newPipe.setTile(this.container);
            this.container.pipe = newPipe;
            --item.getItemStack().field_77994_a;
            if (item.getItemStack().field_77994_a <= 0) {
                ((PipeTransportItems)newPipe.transport).items.remove(item);
            }
            return true;
        }
        return false;
    }

    @Override
    public IIconProvider getIconProvider() {
        return BuildCraftTransport.instance.pipeIconProvider;
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        return PipeIconProvider.TYPE.Stripes.ordinal();
    }

    @Override
    public boolean canPipeConnect(TileEntity tile, ForgeDirection side) {
        if (tile instanceof TileGenericPipe) {
            TileGenericPipe tilePipe = (TileGenericPipe)tile;
            if (tilePipe.pipe instanceof PipeItemsStripes) {
                return false;
            }
        }
        return super.canPipeConnect(tile, side);
    }
}

