/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.mj.MjAPILegacy;
import buildcraft.api.mj.MjBattery;
import buildcraft.api.power.IPowerEmitter;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import buildcraft.api.transport.IPipeTile;
import buildcraft.transport.IPipeTransportPowerHook;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeTransportPower;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class PipePowerWood
extends Pipe<PipeTransportPower>
implements IPowerReceptor,
IPipeTransportPowerHook {
    public final boolean[] powerSources = new boolean[6];
    protected int standardIconIndex = PipeIconProvider.TYPE.PipePowerWood_Standard.ordinal();
    protected int solidIconIndex = PipeIconProvider.TYPE.PipeAllWood_Solid.ordinal();
    @MjBattery(maxCapacity=1500.0, maxReceivedPerCycle=500.0, minimumConsumption=0.0)
    private double mjStored = 0.0;
    private final SafeTimeTracker sourcesTracker = new SafeTimeTracker(1L);
    private boolean full;
    private MjAPILegacy powerHandler;

    public PipePowerWood(Item item) {
        super(new PipeTransportPower(), item);
        ((PipeTransportPower)this.transport).initFromPipe(this.getClass());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return BuildCraftTransport.instance.pipeIconProvider;
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        return this.standardIconIndex;
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (this.container.func_145831_w().field_72995_K) {
            return;
        }
        if (this.mjStored > 0.0) {
            int sources = 0;
            for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
                if (!this.container.isPipeConnected(o)) {
                    this.powerSources[o.ordinal()] = false;
                    continue;
                }
                if (this.isPowerSource(o)) {
                    this.powerSources[o.ordinal()] = true;
                }
                if (!this.powerSources[o.ordinal()]) continue;
                ++sources;
            }
            if (sources <= 0) {
                this.mjStored = this.mjStored > 5.0 ? this.mjStored - 5.0 : 0.0;
                return;
            }
            double energyToRemove = this.mjStored > 40.0 ? this.mjStored / 40.0 + 4.0 : (this.mjStored > 10.0 ? this.mjStored / 10.0 : 1.0);
            energyToRemove /= (double)sources;
            for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
                double energyUsable;
                double energySent;
                if (!this.powerSources[o.ordinal()] || !((energySent = ((PipeTransportPower)this.transport).receiveEnergy(o, energyUsable = this.mjStored > energyToRemove ? energyToRemove : this.mjStored)) > 0.0)) continue;
                this.mjStored -= energySent;
            }
        }
    }

    public boolean requestsPower() {
        if (this.full) {
            boolean request;
            boolean bl = request = this.mjStored < 750.0;
            if (request) {
                this.full = false;
            }
            return request;
        }
        this.full = this.mjStored >= 1490.0;
        return !this.full;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74780_a("mj", this.mjStored);
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            data.func_74757_a("powerSources[" + i + "]", this.powerSources[i]);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.mjStored = data.func_74769_h("mj");
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            this.powerSources[i] = data.func_74767_n("powerSources[" + i + "]");
        }
    }

    @Override
    public double receiveEnergy(ForgeDirection from, double val) {
        return -1.0;
    }

    @Override
    public double requestEnergy(ForgeDirection from, double amount) {
        if (this.container.getTile(from) instanceof IPipeTile) {
            return amount;
        }
        return 0.0;
    }

    public boolean isPowerSource(ForgeDirection from) {
        return this.container.getTile(from) instanceof IPowerEmitter;
    }

    @Override
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        if (this.powerHandler == null) {
            this.powerHandler = MjAPILegacy.from(this.container, PowerHandler.Type.PIPE);
        }
        return this.powerHandler.getPowerReceiver(ForgeDirection.UNKNOWN);
    }

    @Override
    public void doWork(PowerHandler workProvider) {
    }
}

