/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.triggers;

import buildcraft.api.gates.ITrigger;
import buildcraft.api.gates.ITriggerParameter;
import buildcraft.api.transport.PipeWire;
import buildcraft.core.triggers.BCTrigger;
import buildcraft.core.utils.StringUtils;
import buildcraft.transport.IPipeTrigger;
import buildcraft.transport.Pipe;
import java.util.Locale;

public class TriggerPipeSignal
extends BCTrigger
implements IPipeTrigger {
    boolean active;
    PipeWire color;

    public TriggerPipeSignal(boolean active, PipeWire color) {
        super("buildcraft:pipe.wire.input." + color.name().toLowerCase(Locale.ENGLISH) + (active ? ".active" : ".inactive"), "buildcraft.pipe.wire.input." + color.name().toLowerCase(Locale.ENGLISH) + (active ? ".active" : ".inactive"));
        this.active = active;
        this.color = color;
    }

    @Override
    public boolean hasParameter() {
        return false;
    }

    @Override
    public String getDescription() {
        return String.format(StringUtils.localize("gate.trigger.pipe.wire." + (this.active ? "active" : "inactive")), StringUtils.localize("color." + this.color.name().toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public boolean isTriggerActive(Pipe pipe, ITriggerParameter parameter) {
        if (this.active) {
            return pipe.signalStrength[this.color.ordinal()] > 0;
        }
        return pipe.signalStrength[this.color.ordinal()] == 0;
    }

    @Override
    public int getIconIndex() {
        if (this.active) {
            switch (this.color) {
                case RED: {
                    return 21;
                }
                case BLUE: {
                    return 22;
                }
                case GREEN: {
                    return 23;
                }
                case YELLOW: {
                    return 24;
                }
            }
        } else {
            switch (this.color) {
                case RED: {
                    return 25;
                }
                case BLUE: {
                    return 26;
                }
                case GREEN: {
                    return 27;
                }
                case YELLOW: {
                    return 28;
                }
            }
        }
        return -1;
    }

    @Override
    public ITrigger rotateLeft() {
        return this;
    }
}

