/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.utils;

import io.netty.buffer.ByteBuf;
import net.minecraftforge.common.util.ForgeDirection;

public class TextureMatrix {
    private final int[] iconIndexes = new int[7];
    private boolean dirty = false;

    public int getTextureIndex(ForgeDirection direction) {
        return this.iconIndexes[direction.ordinal()];
    }

    public void setIconIndex(ForgeDirection direction, int value) {
        if (this.iconIndexes[direction.ordinal()] != value) {
            this.iconIndexes[direction.ordinal()] = value;
            this.dirty = true;
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void clean() {
        this.dirty = false;
    }

    public void writeData(ByteBuf data) {
        for (int iconIndexe : this.iconIndexes) {
            data.writeByte(iconIndexe);
        }
    }

    public void readData(ByteBuf data) {
        for (int i = 0; i < this.iconIndexes.length; ++i) {
            byte icon = data.readByte();
            if (this.iconIndexes[i] == icon) continue;
            this.iconIndexes[i] = icon;
            this.dirty = true;
        }
    }
}

