/*
 * Decompiled with CFR 0.152.
 */
package buildcraft;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftMod;
import buildcraft.api.blueprints.SchematicRegistry;
import buildcraft.api.recipes.BuildcraftRecipes;
import buildcraft.api.transport.PipeWire;
import buildcraft.builders.schematics.SchematicRotateMeta;
import buildcraft.core.InterModComms;
import buildcraft.core.network.BuildCraftChannelHandler;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.silicon.BlockLaser;
import buildcraft.silicon.BlockLaserTable;
import buildcraft.silicon.GuiHandler;
import buildcraft.silicon.ItemLaserTable;
import buildcraft.silicon.ItemRedstoneChipset;
import buildcraft.silicon.SiliconProxy;
import buildcraft.silicon.TileAdvancedCraftingTable;
import buildcraft.silicon.TileAssemblyTable;
import buildcraft.silicon.TileIntegrationTable;
import buildcraft.silicon.TileLaser;
import buildcraft.silicon.network.PacketHandlerSilicon;
import buildcraft.silicon.recipes.AdvancedFacadeRecipe;
import buildcraft.silicon.recipes.GateExpansionRecipe;
import buildcraft.silicon.recipes.GateLogicSwapRecipe;
import buildcraft.transport.gates.GateDefinition;
import buildcraft.transport.gates.GateExpansionPulsar;
import buildcraft.transport.gates.GateExpansionRedstoneFader;
import buildcraft.transport.gates.GateExpansionTimer;
import buildcraft.transport.gates.ItemGate;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import io.netty.channel.ChannelHandler;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@Mod(name="BuildCraft Silicon", version="6.0.17", useMetadata=false, modid="BuildCraft|Silicon", dependencies="required-after:BuildCraft|Transport@6.0.17")
public class BuildCraftSilicon
extends BuildCraftMod {
    public static ItemRedstoneChipset redstoneChipset;
    public static BlockLaser laserBlock;
    public static BlockLaserTable assemblyTableBlock;
    @Mod.Instance(value="BuildCraft|Silicon")
    public static BuildCraftSilicon instance;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        SchematicRegistry.declareBlueprintSupport("BuildCraft|Silicon");
        BuildCraftCore.mainConfiguration.save();
        laserBlock = new BlockLaser();
        laserBlock.func_149663_c("laserBlock");
        CoreProxy.proxy.registerBlock((Block)laserBlock);
        assemblyTableBlock = new BlockLaserTable();
        CoreProxy.proxy.registerBlock((Block)assemblyTableBlock, ItemLaserTable.class);
        redstoneChipset = new ItemRedstoneChipset();
        redstoneChipset.func_77655_b("redstoneChipset");
        CoreProxy.proxy.registerItem(redstoneChipset);
        redstoneChipset.registerItemStacks();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        this.channels = NetworkRegistry.INSTANCE.newChannel("BC-SILICON", new ChannelHandler[]{new BuildCraftChannelHandler(), new PacketHandlerSilicon()});
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        CoreProxy.proxy.registerTileEntity(TileLaser.class, "net.minecraft.src.buildcraft.factory.TileLaser");
        CoreProxy.proxy.registerTileEntity(TileAssemblyTable.class, "net.minecraft.src.buildcraft.factory.TileAssemblyTable");
        CoreProxy.proxy.registerTileEntity(TileAdvancedCraftingTable.class, "net.minecraft.src.buildcraft.factory.TileAssemblyAdvancedWorkbench");
        CoreProxy.proxy.registerTileEntity(TileIntegrationTable.class, "net.minecraft.src.buildcraft.factory.TileIntegrationTable");
        SchematicRegistry.registerSchematicBlock((Block)laserBlock, SchematicRotateMeta.class, new int[]{2, 5, 3, 4}, true);
        if (BuildCraftCore.loadDefaultRecipes) {
            BuildCraftSilicon.loadRecipes();
        }
        SiliconProxy.proxy.registerRenderers();
    }

    public static void loadRecipes() {
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)laserBlock), "ORR", "DDR", "ORR", Character.valueOf('O'), Blocks.field_150343_Z, Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('D'), Items.field_151045_i);
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)assemblyTableBlock, 1, 0), "ORO", "ODO", "OGO", Character.valueOf('O'), Blocks.field_150343_Z, Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('D'), Items.field_151045_i, Character.valueOf('G'), BuildCraftCore.diamondGearItem);
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)assemblyTableBlock, 1, 1), "OWO", "OCO", "ORO", Character.valueOf('O'), Blocks.field_150343_Z, Character.valueOf('W'), Blocks.field_150462_ai, Character.valueOf('C'), Blocks.field_150486_ae, Character.valueOf('R'), new ItemStack((Item)redstoneChipset, 1, 0));
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)assemblyTableBlock, 1, 2), "ORO", "OCO", "OGO", Character.valueOf('O'), Blocks.field_150343_Z, Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('C'), new ItemStack((Item)redstoneChipset, 1, 0), Character.valueOf('G'), BuildCraftCore.diamondGearItem);
        BuildcraftRecipes.assemblyTable.addRecipe(500.0, PipeWire.RED.getStack(8), "dyeRed", 1, Items.field_151137_ax, Items.field_151042_j);
        BuildcraftRecipes.assemblyTable.addRecipe(500.0, PipeWire.BLUE.getStack(8), "dyeBlue", 1, Items.field_151137_ax, Items.field_151042_j);
        BuildcraftRecipes.assemblyTable.addRecipe(500.0, PipeWire.GREEN.getStack(8), "dyeGreen", 1, Items.field_151137_ax, Items.field_151042_j);
        BuildcraftRecipes.assemblyTable.addRecipe(500.0, PipeWire.YELLOW.getStack(8), "dyeYellow", 1, Items.field_151137_ax, Items.field_151042_j);
        BuildcraftRecipes.assemblyTable.addRecipe(10000.0, ItemRedstoneChipset.Chipset.RED.getStack(), Items.field_151137_ax);
        BuildcraftRecipes.assemblyTable.addRecipe(20000.0, ItemRedstoneChipset.Chipset.IRON.getStack(), Items.field_151137_ax, Items.field_151042_j);
        BuildcraftRecipes.assemblyTable.addRecipe(40000.0, ItemRedstoneChipset.Chipset.GOLD.getStack(), Items.field_151137_ax, Items.field_151043_k);
        BuildcraftRecipes.assemblyTable.addRecipe(80000.0, ItemRedstoneChipset.Chipset.DIAMOND.getStack(), Items.field_151137_ax, Items.field_151045_i);
        BuildcraftRecipes.assemblyTable.addRecipe(40000.0, ItemRedstoneChipset.Chipset.PULSATING.getStack(2), Items.field_151137_ax, Items.field_151079_bi);
        BuildcraftRecipes.assemblyTable.addRecipe(60000.0, ItemRedstoneChipset.Chipset.QUARTZ.getStack(), Items.field_151137_ax, Items.field_151128_bU);
        BuildcraftRecipes.assemblyTable.addRecipe(60000.0, ItemRedstoneChipset.Chipset.COMP.getStack(), Items.field_151137_ax, Items.field_151132_bS);
        BuildcraftRecipes.assemblyTable.addRecipe(10000.0, ItemGate.makeGateItem(GateDefinition.GateMaterial.REDSTONE, GateDefinition.GateLogic.AND), ItemRedstoneChipset.Chipset.RED.getStack(), PipeWire.RED.getStack());
        BuildCraftSilicon.addGateRecipe(20000.0, GateDefinition.GateMaterial.IRON, ItemRedstoneChipset.Chipset.IRON, PipeWire.RED, PipeWire.BLUE);
        BuildCraftSilicon.addGateRecipe(40000.0, GateDefinition.GateMaterial.GOLD, ItemRedstoneChipset.Chipset.GOLD, PipeWire.RED, PipeWire.BLUE, PipeWire.GREEN);
        BuildCraftSilicon.addGateRecipe(80000.0, GateDefinition.GateMaterial.DIAMOND, ItemRedstoneChipset.Chipset.DIAMOND, PipeWire.RED, PipeWire.BLUE, PipeWire.GREEN, PipeWire.YELLOW);
        EnumSet<GateDefinition.GateMaterial> materials = EnumSet.allOf(GateDefinition.GateMaterial.class);
        materials.remove((Object)GateDefinition.GateMaterial.REDSTONE);
        for (GateDefinition.GateMaterial material : materials) {
            BuildcraftRecipes.integrationTable.addRecipe(new GateLogicSwapRecipe(material, GateDefinition.GateLogic.AND, GateDefinition.GateLogic.OR));
            BuildcraftRecipes.integrationTable.addRecipe(new GateLogicSwapRecipe(material, GateDefinition.GateLogic.OR, GateDefinition.GateLogic.AND));
        }
        BuildcraftRecipes.integrationTable.addRecipe(new GateExpansionRecipe(GateExpansionPulsar.INSTANCE, ItemRedstoneChipset.Chipset.PULSATING.getStack()));
        BuildcraftRecipes.integrationTable.addRecipe(new GateExpansionRecipe(GateExpansionTimer.INSTANCE, ItemRedstoneChipset.Chipset.QUARTZ.getStack()));
        BuildcraftRecipes.integrationTable.addRecipe(new GateExpansionRecipe(GateExpansionRedstoneFader.INSTANCE, ItemRedstoneChipset.Chipset.COMP.getStack()));
        BuildcraftRecipes.integrationTable.addRecipe(new AdvancedFacadeRecipe());
    }

    private static void addGateRecipe(double energyCost, GateDefinition.GateMaterial material, ItemRedstoneChipset.Chipset chipset, PipeWire ... pipeWire) {
        ArrayList<ItemStack> temp = new ArrayList<ItemStack>();
        temp.add(chipset.getStack());
        for (PipeWire wire : pipeWire) {
            temp.add(wire.getStack());
        }
        Object[] inputs = temp.toArray();
        BuildcraftRecipes.assemblyTable.addRecipe(energyCost, ItemGate.makeGateItem(material, GateDefinition.GateLogic.AND), inputs);
        BuildcraftRecipes.assemblyTable.addRecipe(energyCost, ItemGate.makeGateItem(material, GateDefinition.GateLogic.OR), inputs);
    }

    @Mod.EventHandler
    public void processIMCRequests(FMLInterModComms.IMCEvent event) {
        InterModComms.processIMC(event);
    }

    @Mod.EventHandler
    public void whiteListAppliedEnergetics(FMLInitializationEvent event) {
        FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)TileLaser.class.getCanonicalName());
        FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)TileAssemblyTable.class.getCanonicalName());
        FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)TileAdvancedCraftingTable.class.getCanonicalName());
        FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)TileIntegrationTable.class.getCanonicalName());
    }
}

