/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.fuels;

import buildcraft.api.core.StackKey;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public final class IronEngineCoolant {
    public static Map<String, Coolant> liquidCoolants = new HashMap<String, Coolant>();
    public static Map<StackKey, FluidStack> solidCoolants = new HashMap<StackKey, FluidStack>();

    private IronEngineCoolant() {
    }

    public static FluidStack getFluidCoolant(ItemStack stack) {
        return solidCoolants.get(new StackKey(stack));
    }

    public static Coolant getCoolant(ItemStack stack) {
        return IronEngineCoolant.getCoolant(IronEngineCoolant.getFluidCoolant(stack));
    }

    public static Coolant getCoolant(FluidStack fluidStack) {
        return fluidStack != null && fluidStack.getFluid() != null ? liquidCoolants.get(fluidStack.getFluid().getName()) : null;
    }

    public static void addCoolant(Fluid fluid, final float degreesCoolingPerMB) {
        if (fluid != null) {
            liquidCoolants.put(fluid.getName(), new Coolant(){

                @Override
                public float getDegreesCoolingPerMB(float currentHeat) {
                    return degreesCoolingPerMB;
                }
            });
        }
    }

    public static void addCoolant(ItemStack stack, FluidStack coolant) {
        if (stack != null && stack.func_77973_b() != null && coolant != null) {
            solidCoolants.put(new StackKey(stack), coolant);
        }
    }

    public static void addCoolant(Item item, int metadata, FluidStack coolant) {
        IronEngineCoolant.addCoolant(new ItemStack(item, 1, metadata), coolant);
    }

    public static void addCoolant(Block block, int metadata, FluidStack coolant) {
        IronEngineCoolant.addCoolant(new ItemStack(block, 1, metadata), coolant);
    }

    public static boolean isCoolant(Fluid fluid) {
        return liquidCoolants.containsKey(fluid.getName());
    }

    public static interface Coolant {
        public float getDegreesCoolingPerMB(float var1);
    }
}

