/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.gates;

import buildcraft.api.gates.IGateExpansion;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class GateExpansions {
    private static final Map<String, IGateExpansion> expansions = new HashMap<String, IGateExpansion>();
    private static final BiMap<Byte, String> serverIDMap = HashBiMap.create();
    private static final BiMap<Byte, String> clientIDMap = HashBiMap.create();
    private static byte nextID = 0;

    private GateExpansions() {
    }

    public static void registerExpansion(IGateExpansion expansion) {
        GateExpansions.registerExpansion(expansion.getUniqueIdentifier(), expansion);
    }

    public static void registerExpansion(String identifier, IGateExpansion expansion) {
        expansions.put(identifier, expansion);
        byte by = nextID;
        nextID = (byte)(by + 1);
        serverIDMap.put((Object)by, (Object)identifier);
    }

    public static IGateExpansion getExpansion(String identifier) {
        return expansions.get(identifier);
    }

    public static IGateExpansion getExpansionClient(int id) {
        if (id < 0 || id >= 128) {
            return null;
        }
        return expansions.get(clientIDMap.get((Object)((byte)id)));
    }

    public static byte getServerExpansionID(String identifier) {
        return (Byte)serverIDMap.inverse().get((Object)identifier);
    }

    public static Set<IGateExpansion> getExpansions() {
        HashSet<IGateExpansion> set = new HashSet<IGateExpansion>();
        set.addAll(expansions.values());
        return set;
    }

    public static BiMap<Byte, String> getServerMap() {
        return serverIDMap;
    }

    public static void setClientMap(BiMap<Byte, String> map) {
        clientIDMap.clear();
        clientIDMap.putAll(map);
    }
}

