/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.BuildCraftBuilders;
import buildcraft.builders.ItemBlueprint;
import buildcraft.builders.ItemBlueprintStandard;
import buildcraft.builders.ItemBlueprintTemplate;
import buildcraft.builders.blueprints.BlueprintId;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.blueprints.BlueprintBase;
import buildcraft.core.inventory.SimpleInventory;
import buildcraft.core.network.RPC;
import buildcraft.core.network.RPCHandler;
import buildcraft.core.network.RPCSide;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;

public class TileBlueprintLibrary
extends TileBuildCraft
implements IInventory {
    private static final int PROGRESS_TIME = 100;
    public SimpleInventory inv = new SimpleInventory(4, "Blueprint Library", 1);
    public int progressIn = 0;
    public int progressOut = 0;
    public ArrayList<BlueprintId> currentPage;
    public int selected = -1;
    public EntityPlayer uploadingPlayer = null;
    public EntityPlayer downloadingPlayer = null;
    public int pageId = 0;

    @Override
    public void initialize() {
        super.initialize();
        if (this.field_145850_b.field_72995_K) {
            this.setCurrentPage(BuildCraftBuilders.clientDB.getPage(this.pageId));
        }
    }

    public void setCurrentPage(ArrayList<BlueprintId> newPage) {
        this.currentPage = newPage;
        this.selected = -1;
    }

    public void pageNext() {
        if (this.pageId < BuildCraftBuilders.clientDB.getPageNumber() - 1) {
            ++this.pageId;
        }
        this.setCurrentPage(BuildCraftBuilders.clientDB.getPage(this.pageId));
    }

    public void pagePrev() {
        if (this.pageId > 0) {
            --this.pageId;
        }
        this.setCurrentPage(BuildCraftBuilders.clientDB.getPage(this.pageId));
    }

    public void deleteSelectedBpt() {
        if (this.selected != -1) {
            BuildCraftBuilders.clientDB.deleteBlueprint(this.currentPage.get(this.selected));
            if (this.pageId > BuildCraftBuilders.clientDB.getPageNumber() - 1 && this.pageId > 0) {
                --this.pageId;
            }
            this.setCurrentPage(BuildCraftBuilders.clientDB.getPage(this.pageId));
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.inv.readFromNBT(nbttagcompound);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        this.inv.writeToNBT(nbttagcompound);
    }

    public int func_70302_i_() {
        return 4;
    }

    public ItemStack func_70301_a(int i) {
        return this.inv.func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int j) {
        ItemStack result = this.inv.func_70298_a(i, j);
        if (i == 0 && this.func_70301_a(0) == null) {
            this.progressIn = 0;
        }
        if (i == 2 && this.func_70301_a(2) == null) {
            this.progressOut = 0;
        }
        return result;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inv.func_70299_a(i, itemstack);
        if (i == 0) {
            this.progressIn = this.func_70301_a(0) != null && this.func_70301_a(0).func_77973_b() instanceof ItemBlueprint ? 1 : 0;
        }
        if (i == 2) {
            this.progressOut = this.func_70301_a(2) != null && this.func_70301_a(2).func_77973_b() instanceof ItemBlueprint ? 1 : 0;
        }
    }

    public ItemStack func_70304_b(int slot) {
        return this.inv.func_70304_b(slot);
    }

    public String func_145825_b() {
        return "";
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return false;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.progressIn > 0 && this.progressIn < 100) {
            ++this.progressIn;
        }
        if (this.progressOut > 0 && this.progressOut < 100) {
            ++this.progressOut;
        }
        if (this.progressIn == 100 && this.func_70301_a(1) == null) {
            this.func_70299_a(1, this.func_70301_a(0));
            this.func_70299_a(0, null);
            BlueprintBase bpt = ItemBlueprint.loadBlueprint(this.func_70301_a(1));
            if (bpt != null && this.uploadingPlayer != null) {
                RPCHandler.rpcPlayer(this, "downloadBlueprintToClient", this.uploadingPlayer, bpt.id, bpt.getData());
                this.uploadingPlayer = null;
            }
        }
        if (this.progressOut == 100 && this.func_70301_a(3) == null) {
            RPCHandler.rpcPlayer(this, "requestSelectedBlueprint", this.downloadingPlayer, new Object[0]);
            this.progressOut = 0;
        }
    }

    public boolean func_145818_k_() {
        return false;
    }

    @RPC(value=RPCSide.CLIENT)
    public void requestSelectedBlueprint() {
        if (this.isOuputConsistent()) {
            if (this.selected > -1 && this.selected < this.currentPage.size()) {
                BlueprintBase bpt = BuildCraftBuilders.clientDB.load(this.currentPage.get(this.selected));
                RPCHandler.rpcServer(this, "uploadBlueprintToServer", bpt.id, bpt.getData());
            } else {
                RPCHandler.rpcServer(this, "uploadBlueprintToServer", null, null);
            }
        }
    }

    @RPC(value=RPCSide.SERVER)
    public void uploadBlueprintToServer(BlueprintId id, byte[] data) {
        try {
            if (data != null) {
                NBTTagCompound nbt = CompressedStreamTools.func_152457_a((byte[])data, (NBTSizeTracker)NBTSizeTracker.field_152451_a);
                BlueprintBase bpt = BlueprintBase.loadBluePrint(nbt);
                bpt.setData(data);
                bpt.id = id;
                BuildCraftBuilders.serverDB.add(bpt);
                this.func_70299_a(3, bpt.getStack());
            } else {
                this.func_70299_a(3, this.func_70301_a(2));
            }
            this.func_70299_a(2, null);
            this.downloadingPlayer = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @RPC(value=RPCSide.CLIENT)
    public void downloadBlueprintToClient(BlueprintId id, byte[] data) {
        try {
            NBTTagCompound nbt = CompressedStreamTools.func_152457_a((byte[])data, (NBTSizeTracker)NBTSizeTracker.field_152451_a);
            BlueprintBase bpt = BlueprintBase.loadBluePrint(nbt);
            bpt.setData(data);
            bpt.id = id;
            BuildCraftBuilders.clientDB.add(bpt);
            this.setCurrentPage(BuildCraftBuilders.clientDB.getPage(this.pageId));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void selectBlueprint(int index) {
        this.selected = index;
    }

    private boolean isOuputConsistent() {
        if (this.selected == -1 || this.func_70301_a(2) == null) {
            return false;
        }
        return this.func_70301_a(2).func_77973_b() instanceof ItemBlueprintStandard && this.currentPage.get((int)this.selected).kind == BlueprintId.Kind.Blueprint || this.func_70301_a(2).func_77973_b() instanceof ItemBlueprintTemplate && this.currentPage.get((int)this.selected).kind == BlueprintId.Kind.Template;
    }
}

