/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.gui;

import buildcraft.builders.TileBuilder;
import buildcraft.builders.gui.ContainerBuilder;
import buildcraft.core.DefaultProps;
import buildcraft.core.gui.AdvancedSlot;
import buildcraft.core.gui.GuiAdvancedInterface;
import buildcraft.core.utils.StringUtils;
import java.util.Collection;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiBuilder
extends GuiAdvancedInterface {
    private static final ResourceLocation TEXTURE = new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_GUI + "/builder.png");
    private static final ResourceLocation BLUEPRINT_TEXTURE = new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_GUI + "/builder_blueprint.png");
    private IInventory playerInventory;
    private TileBuilder builder;
    private int inventoryRows = 6;

    public GuiBuilder(IInventory playerInventory, TileBuilder builder) {
        super(new ContainerBuilder(playerInventory, builder), builder, TEXTURE);
        this.playerInventory = playerInventory;
        this.builder = builder;
        this.field_146999_f = 176;
        this.field_147000_g = 225;
        this.slots = new AdvancedSlot[28];
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.slots[i * 4 + j] = new GuiAdvancedInterface.ItemSlot(this, 179 + j * 18, 18 + i * 18);
            }
        }
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        super.func_146979_b(par1, par2);
        String title = StringUtils.localize("tile.builderBlock.name");
        this.field_146289_q.func_78276_b(title, this.getCenteredOffset(title), 12, 0x404040);
        this.field_146289_q.func_78276_b(StringUtils.localize("gui.building.resources"), 8, 60, 0x404040);
        this.field_146289_q.func_78276_b(StringUtils.localize("gui.inventory"), 8, this.field_147000_g - 97, 0x404040);
        this.field_146289_q.func_78276_b(StringUtils.localize("gui.needed"), 185, 7, 0x404040);
        this.drawForegroundSelection(par1, par2);
    }

    @Override
    protected void func_146976_a(float f, int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int j = (this.field_146294_l - this.field_146999_f) / 2;
        int k = (this.field_146295_m - this.field_147000_g) / 2;
        int realXSize = 0;
        this.field_146297_k.field_71446_o.func_110577_a(BLUEPRINT_TEXTURE);
        realXSize = 256;
        this.func_73729_b(j, k, 0, 0, realXSize, this.field_147000_g);
        for (int s = 0; s < this.slots.length; ++s) {
            ((GuiAdvancedInterface.ItemSlot)this.slots[s]).stack = null;
        }
        Collection<ItemStack> needs = this.builder.getNeededItems();
        if (needs != null) {
            int s = 0;
            for (ItemStack stack : needs) {
                if (s >= this.slots.length) break;
                ((GuiAdvancedInterface.ItemSlot)this.slots[s]).stack = stack.func_77946_l();
                ++s;
            }
        }
        this.drawBackgroundSlots();
    }
}

