/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.api.core.SafeTimeTracker;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public final class TileBuffer {
    private Block block = null;
    private TileEntity tile;
    private final SafeTimeTracker tracker = new SafeTimeTracker(20L, 5L);
    private final World world;
    private final int x;
    private final int y;
    private final int z;
    private final boolean loadUnloaded;

    public TileBuffer(World world, int x, int y, int z, boolean loadUnloaded) {
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.loadUnloaded = loadUnloaded;
        this.refresh();
    }

    public void refresh() {
        this.tile = null;
        this.block = null;
        if (!this.loadUnloaded && !this.world.func_72899_e(this.x, this.y, this.z)) {
            return;
        }
        this.block = this.world.func_147439_a(this.x, this.y, this.z);
        if (this.block != null && this.block.hasTileEntity(this.world.func_72805_g(this.x, this.y, this.z))) {
            this.tile = this.world.func_147438_o(this.x, this.y, this.z);
        }
    }

    public void set(Block block, TileEntity tile) {
        this.block = block;
        this.tile = tile;
        this.tracker.markTime(this.world);
    }

    public Block getBlock() {
        if (this.tile != null && !this.tile.func_145837_r()) {
            return this.block;
        }
        if (this.tracker.markTimeIfDelay(this.world)) {
            this.refresh();
            if (this.tile != null && !this.tile.func_145837_r()) {
                return this.block;
            }
        }
        return null;
    }

    public TileEntity getTile() {
        if (this.tile != null && !this.tile.func_145837_r()) {
            return this.tile;
        }
        if (this.tracker.markTimeIfDelay(this.world)) {
            this.refresh();
            if (this.tile != null && !this.tile.func_145837_r()) {
                return this.tile;
            }
        }
        return null;
    }

    public boolean exists() {
        if (this.tile != null && !this.tile.func_145837_r()) {
            return true;
        }
        return this.world.func_72899_e(this.x, this.y, this.z);
    }

    public static TileBuffer[] makeBuffer(World world, int x, int y, int z, boolean loadUnloaded) {
        TileBuffer[] buffer = new TileBuffer[6];
        for (int i = 0; i < 6; ++i) {
            ForgeDirection d = ForgeDirection.getOrientation((int)i);
            buffer[i] = new TileBuffer(world, x + d.offsetX, y + d.offsetY, z + d.offsetZ, loadUnloaded);
        }
        return buffer;
    }
}

