/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.blueprints;

import buildcraft.BuildCraftBuilders;
import buildcraft.api.blueprints.BuildingPermission;
import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.MappingNotFoundException;
import buildcraft.api.blueprints.SchematicBlock;
import buildcraft.api.blueprints.SchematicEntity;
import buildcraft.api.blueprints.SchematicRegistry;
import buildcraft.api.blueprints.Translation;
import buildcraft.api.core.BCLog;
import buildcraft.builders.blueprints.BlueprintId;
import buildcraft.core.blueprints.BlueprintBase;
import buildcraft.core.blueprints.BptContext;
import buildcraft.core.blueprints.BptError;
import buildcraft.core.utils.NBTUtils;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public class Blueprint
extends BlueprintBase {
    public LinkedList<SchematicEntity> entities = new LinkedList();

    public Blueprint() {
        this.id.kind = BlueprintId.Kind.Blueprint;
    }

    public Blueprint(int sizeX, int sizeY, int sizeZ) {
        super(sizeX, sizeY, sizeZ);
        this.id.kind = BlueprintId.Kind.Blueprint;
    }

    @Override
    public void rotateLeft(BptContext context) {
        for (SchematicEntity e : this.entities) {
            e.rotateLeft(context);
        }
        super.rotateLeft(context);
    }

    @Override
    public void translateToBlueprint(Translation transform) {
        super.translateToBlueprint(transform);
        for (SchematicEntity e : this.entities) {
            e.translateToBlueprint(transform);
        }
    }

    @Override
    public void translateToWorld(Translation transform) {
        super.translateToWorld(transform);
        for (SchematicEntity e : this.entities) {
            e.translateToWorld(transform);
        }
    }

    @Override
    public void readFromWorld(IBuilderContext context, TileEntity anchorTile, int x, int y, int z) {
        BptContext bptContext = (BptContext)context;
        Block block = anchorTile.func_145831_w().func_147439_a(x, y, z);
        if (context.world().func_147437_c(x, y, z)) {
            return;
        }
        SchematicBlock slot = SchematicRegistry.newSchematicBlock(block);
        if (slot == null) {
            return;
        }
        int posX = (int)((double)x - context.surroundingBox().pMin().x);
        int posY = (int)((double)y - context.surroundingBox().pMin().y);
        int posZ = (int)((double)z - context.surroundingBox().pMin().z);
        slot.block = block;
        slot.meta = anchorTile.func_145831_w().func_72805_g(x, y, z);
        if (bptContext.readConfiguration.explicitOnly && !SchematicRegistry.isExplicitlySupported(block)) {
            return;
        }
        if (!bptContext.readConfiguration.readTiles && anchorTile.func_145831_w().func_147438_o(x, y, z) != null) {
            return;
        }
        try {
            slot.writeToBlueprint(context, x, y, z);
            slot.writeRequirementsToBlueprint(context, x, y, z);
            this.contents[posX][posY][posZ] = slot;
        }
        catch (Throwable t) {
            t.printStackTrace();
            BCLog.logger.throwing("BptBlueprint", "readFromWorld", t);
        }
        switch (slot.getBuildingPermission()) {
            case ALL: {
                break;
            }
            case CREATIVE_ONLY: {
                if (this.buildingPermission != BuildingPermission.ALL) break;
                this.buildingPermission = BuildingPermission.CREATIVE_ONLY;
                break;
            }
            case NONE: {
                this.buildingPermission = BuildingPermission.NONE;
            }
        }
    }

    @Override
    public void readEntitiesFromWorld(IBuilderContext context, TileEntity anchorTile) {
        Translation transform = new Translation();
        transform.x = -context.surroundingBox().pMin().x;
        transform.y = -context.surroundingBox().pMin().y;
        transform.z = -context.surroundingBox().pMin().z;
        for (Object o : context.world().field_72996_f) {
            SchematicEntity s;
            Entity e = (Entity)o;
            if (!context.surroundingBox().contains(e.field_70165_t, e.field_70163_u, e.field_70161_v) || (s = SchematicRegistry.newSchematicEntity(e.getClass())) == null) continue;
            s.readFromWorld(context, e);
            this.entities.add(s);
        }
    }

    @Override
    public void saveContents(NBTTagCompound nbt) {
        NBTTagList nbtContents = new NBTTagList();
        for (int x = 0; x < this.sizeX; ++x) {
            for (int y = 0; y < this.sizeY; ++y) {
                for (int z = 0; z < this.sizeZ; ++z) {
                    NBTTagCompound cpt = new NBTTagCompound();
                    if (this.contents[x][y][z] != null) {
                        this.contents[x][y][z].idsToBlueprint(this.mapping);
                        this.contents[x][y][z].writeToNBT(cpt, this.mapping);
                    }
                    nbtContents.func_74742_a((NBTBase)cpt);
                }
            }
        }
        nbt.func_74782_a("contents", (NBTBase)nbtContents);
        NBTTagList entitiesNBT = new NBTTagList();
        for (SchematicEntity s : this.entities) {
            NBTTagCompound subNBT = new NBTTagCompound();
            s.idsToBlueprint(this.mapping);
            s.writeToNBT(subNBT, this.mapping);
            entitiesNBT.func_74742_a((NBTBase)subNBT);
        }
        nbt.func_74782_a("entities", (NBTBase)entitiesNBT);
        NBTTagCompound contextNBT = new NBTTagCompound();
        this.mapping.write(contextNBT);
        nbt.func_74782_a("idMapping", (NBTBase)contextNBT);
    }

    @Override
    public void loadContents(NBTTagCompound nbt) throws BptError {
        this.mapping.read(nbt.func_74775_l("idMapping"));
        NBTTagList nbtContents = nbt.func_150295_c("contents", 10);
        int index = 0;
        for (int x = 0; x < this.sizeX; ++x) {
            for (int y = 0; y < this.sizeY; ++y) {
                for (int z = 0; z < this.sizeZ; ++z) {
                    NBTTagCompound cpt = nbtContents.func_150305_b(index);
                    ++index;
                    if (cpt.func_74764_b("blockId")) {
                        Block block;
                        try {
                            block = this.mapping.getBlockForId(cpt.func_74762_e("blockId"));
                        }
                        catch (MappingNotFoundException e) {
                            block = null;
                            this.buildingPermission = BuildingPermission.CREATIVE_ONLY;
                        }
                        if (block != null) {
                            this.contents[x][y][z] = SchematicRegistry.newSchematicBlock(block);
                            this.contents[x][y][z].readFromNBT(cpt, this.mapping);
                            if (!this.contents[x][y][z].doNotUse()) {
                                this.contents[x][y][z].idsToWorld(this.mapping);
                                switch (this.contents[x][y][z].getBuildingPermission()) {
                                    case ALL: {
                                        break;
                                    }
                                    case CREATIVE_ONLY: {
                                        if (this.buildingPermission != BuildingPermission.ALL) break;
                                        this.buildingPermission = BuildingPermission.CREATIVE_ONLY;
                                        break;
                                    }
                                    case NONE: {
                                        this.buildingPermission = BuildingPermission.NONE;
                                    }
                                }
                                continue;
                            }
                            this.contents[x][y][z] = null;
                            this.isComplete = false;
                            continue;
                        }
                        this.contents[x][y][z] = null;
                        this.isComplete = false;
                        continue;
                    }
                    this.contents[x][y][z] = null;
                }
            }
        }
        NBTTagList entitiesNBT = nbt.func_150295_c("entities", 10);
        for (int i = 0; i < entitiesNBT.func_74745_c(); ++i) {
            Class<? extends Entity> entity;
            NBTTagCompound cpt = entitiesNBT.func_150305_b(i);
            if (!cpt.func_74764_b("entityId")) continue;
            try {
                entity = this.mapping.getEntityForId(cpt.func_74762_e("entityId"));
            }
            catch (MappingNotFoundException e) {
                entity = null;
                this.buildingPermission = BuildingPermission.CREATIVE_ONLY;
            }
            if (entity != null) {
                SchematicEntity s = SchematicRegistry.newSchematicEntity(entity);
                s.readFromNBT(cpt, this.mapping);
                s.idsToWorld(this.mapping);
                this.entities.add(s);
                continue;
            }
            this.isComplete = false;
        }
    }

    @Override
    public ItemStack getStack() {
        ItemStack stack = new ItemStack((Item)BuildCraftBuilders.blueprintItem, 1);
        NBTTagCompound nbt = NBTUtils.getItemData(stack);
        this.id.write(nbt);
        nbt.func_74778_a("author", this.author);
        nbt.func_74778_a("name", this.id.name);
        nbt.func_74774_a("permission", (byte)this.buildingPermission.ordinal());
        nbt.func_74757_a("isComplete", this.isComplete);
        return stack;
    }
}

