/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy;

import buildcraft.BuildCraftEnergy;
import buildcraft.api.core.NetworkData;
import buildcraft.api.gates.IOverrideDefaultTriggers;
import buildcraft.api.gates.ITrigger;
import buildcraft.api.mj.IBatteryObject;
import buildcraft.api.mj.MjAPI;
import buildcraft.api.power.IPowerEmitter;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import buildcraft.core.DefaultProps;
import buildcraft.core.TileBuffer;
import buildcraft.core.TileBuildCraft;
import buildcraft.energy.gui.ContainerEngine;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEngine
extends TileBuildCraft
implements IPowerReceptor,
IPowerEmitter,
IOverrideDefaultTriggers,
IPipeConnection {
    public static final ResourceLocation[] BASE_TEXTURES = new ResourceLocation[]{new ResourceLocation(DefaultProps.TEXTURE_PATH_BLOCKS + "/base_wood.png"), new ResourceLocation(DefaultProps.TEXTURE_PATH_BLOCKS + "/base_stone.png"), new ResourceLocation(DefaultProps.TEXTURE_PATH_BLOCKS + "/base_iron.png"), new ResourceLocation(DefaultProps.TEXTURE_PATH_BLOCKS + "/base_creative.png")};
    public static final ResourceLocation[] CHAMBER_TEXTURES = new ResourceLocation[]{new ResourceLocation(DefaultProps.TEXTURE_PATH_BLOCKS + "/chamber_wood.png"), new ResourceLocation(DefaultProps.TEXTURE_PATH_BLOCKS + "/chamber_stone.png"), new ResourceLocation(DefaultProps.TEXTURE_PATH_BLOCKS + "/chamber_iron.png"), new ResourceLocation(DefaultProps.TEXTURE_PATH_BLOCKS + "/chamber_creative.png")};
    public static final ResourceLocation[] TRUNK_TEXTURES = new ResourceLocation[]{new ResourceLocation(DefaultProps.TEXTURE_PATH_BLOCKS + "/trunk_wood.png"), new ResourceLocation(DefaultProps.TEXTURE_PATH_BLOCKS + "/trunk_stone.png"), new ResourceLocation(DefaultProps.TEXTURE_PATH_BLOCKS + "/trunk_iron.png"), new ResourceLocation(DefaultProps.TEXTURE_PATH_BLOCKS + "/trunk_creative.png")};
    public static final ResourceLocation TRUNK_BLUE_TEXTURE = new ResourceLocation(DefaultProps.TEXTURE_PATH_BLOCKS + "/trunk_blue.png");
    public static final ResourceLocation TRUNK_GREEN_TEXTURE = new ResourceLocation(DefaultProps.TEXTURE_PATH_BLOCKS + "/trunk_green.png");
    public static final ResourceLocation TRUNK_YELLOW_TEXTURE = new ResourceLocation(DefaultProps.TEXTURE_PATH_BLOCKS + "/trunk_yellow.png");
    public static final ResourceLocation TRUNK_RED_TEXTURE = new ResourceLocation(DefaultProps.TEXTURE_PATH_BLOCKS + "/trunk_red.png");
    public static final float MIN_HEAT = 20.0f;
    public static final float IDEAL_HEAT = 100.0f;
    public static final float MAX_HEAT = 250.0f;
    public double currentOutput = 0.0;
    public boolean isRedstonePowered = false;
    public float progress;
    public double energy;
    public float heat = 20.0f;
    @NetworkData
    public EnergyStage energyStage = EnergyStage.BLUE;
    @NetworkData
    public ForgeDirection orientation = ForgeDirection.UP;
    protected int progressPart = 0;
    protected boolean lastPower = false;
    protected PowerHandler powerHandler = new PowerHandler(this, PowerHandler.Type.ENGINE);
    private boolean checkOrienation = false;
    private TileBuffer[] tileCache;
    @NetworkData
    private boolean isPumping = false;

    public TileEngine() {
        this.powerHandler.configurePowerPerdition(1, 100);
    }

    @Override
    public void initialize() {
        if (!this.field_145850_b.field_72995_K) {
            this.powerHandler.configure(this.minEnergyReceived(), this.maxEnergyReceived(), 1.0, this.getMaxEnergy());
            this.checkRedstonePower();
        }
    }

    public abstract ResourceLocation getBaseTexture();

    public abstract ResourceLocation getChamberTexture();

    public ResourceLocation getTrunkTexture(EnergyStage stage) {
        switch (stage) {
            case BLUE: {
                return TRUNK_BLUE_TEXTURE;
            }
            case GREEN: {
                return TRUNK_GREEN_TEXTURE;
            }
            case YELLOW: {
                return TRUNK_YELLOW_TEXTURE;
            }
            case RED: {
                return TRUNK_RED_TEXTURE;
            }
        }
        return TRUNK_RED_TEXTURE;
    }

    public boolean onBlockActivated(EntityPlayer player, ForgeDirection side) {
        return false;
    }

    public double getEnergyLevel() {
        return this.energy / this.getMaxEnergy();
    }

    protected EnergyStage computeEnergyStage() {
        float energyLevel = this.getHeatLevel();
        if (energyLevel < 0.25f) {
            return EnergyStage.BLUE;
        }
        if (energyLevel < 0.5f) {
            return EnergyStage.GREEN;
        }
        if (energyLevel < 0.75f) {
            return EnergyStage.YELLOW;
        }
        if (energyLevel < 1.0f) {
            return EnergyStage.RED;
        }
        return EnergyStage.OVERHEAT;
    }

    public final EnergyStage getEnergyStage() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.energyStage == EnergyStage.OVERHEAT) {
                return this.energyStage;
            }
            EnergyStage newStage = this.computeEnergyStage();
            if (this.energyStage != newStage) {
                this.energyStage = newStage;
                this.sendNetworkUpdate();
            }
        }
        return this.energyStage;
    }

    public void updateHeatLevel() {
        this.heat = (float)(230.0 * this.getEnergyLevel()) + 20.0f;
    }

    public float getHeatLevel() {
        return (this.heat - 20.0f) / 230.0f;
    }

    public float getIdealHeatLevel() {
        return this.heat / 100.0f;
    }

    public float getHeat() {
        return this.heat;
    }

    public float getPistonSpeed() {
        if (!this.field_145850_b.field_72995_K) {
            return Math.max(0.16f * this.getHeatLevel(), 0.01f);
        }
        switch (this.getEnergyStage()) {
            case BLUE: {
                return 0.02f;
            }
            case GREEN: {
                return 0.04f;
            }
            case YELLOW: {
                return 0.08f;
            }
            case RED: {
                return 0.16f;
            }
        }
        return 0.0f;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            if (this.progressPart != 0) {
                this.progress += this.getPistonSpeed();
                if (this.progress > 1.0f) {
                    this.progressPart = 0;
                    this.progress = 0.0f;
                }
            } else if (this.isPumping) {
                this.progressPart = 1;
            }
            return;
        }
        if (this.checkOrienation) {
            this.checkOrienation = false;
            if (!this.isOrientationValid()) {
                this.switchOrientation(true);
            }
        }
        if (!this.isRedstonePowered && this.energy > 1.0) {
            this.energy -= 1.0;
        }
        this.updateHeatLevel();
        this.getEnergyStage();
        this.engineUpdate();
        TileEntity tile = this.getTileBuffer(this.orientation).getTile();
        if (this.progressPart != 0) {
            this.progress += this.getPistonSpeed();
            if ((double)this.progress > 0.5 && this.progressPart == 1) {
                this.progressPart = 2;
                this.sendPower();
            } else if (this.progress >= 1.0f) {
                this.progress = 0.0f;
                this.progressPart = 0;
            }
        } else if (this.isRedstonePowered && this.isActive()) {
            if (this.isPoweredTile(tile, this.orientation)) {
                if (this.getPowerToExtract() > 0.0) {
                    this.progressPart = 1;
                    this.setPumping(true);
                } else {
                    this.setPumping(false);
                }
            } else {
                this.setPumping(false);
            }
        } else {
            this.setPumping(false);
        }
        this.burn();
    }

    private double getPowerToExtract() {
        TileEntity tile = this.getTileBuffer(this.orientation).getTile();
        IBatteryObject battery = MjAPI.getMjBattery(tile, "buildcraft.kinesis", this.orientation.getOpposite());
        if (battery != null) {
            return this.extractEnergy(0.0, battery.getEnergyRequested(), false);
        }
        if (tile instanceof IPowerReceptor) {
            PowerHandler.PowerReceiver receptor = ((IPowerReceptor)tile).getPowerReceiver(this.orientation.getOpposite());
            return this.extractEnergy(receptor.getMinEnergyReceived(), receptor.getMaxEnergyReceived(), false);
        }
        return 0.0;
    }

    private void sendPower() {
        TileEntity tile = this.getTileBuffer(this.orientation).getTile();
        if (this.isPoweredTile(tile, this.orientation)) {
            double extracted = this.getPowerToExtract();
            IBatteryObject battery = MjAPI.getMjBattery(tile, "buildcraft.kinesis", this.orientation.getOpposite());
            if (battery != null) {
                battery.addEnergy(this.extractEnergy(0.0, battery.maxReceivedPerCycle(), true));
            } else if (tile instanceof IPowerReceptor) {
                PowerHandler.PowerReceiver receptor = ((IPowerReceptor)tile).getPowerReceiver(this.orientation.getOpposite());
                if (extracted > 0.0) {
                    double needed = receptor.receiveEnergy(PowerHandler.Type.ENGINE, extracted, this.orientation.getOpposite());
                    this.extractEnergy(receptor.getMinEnergyReceived(), needed, true);
                }
            }
        }
    }

    protected void burn() {
    }

    protected void engineUpdate() {
        if (!this.isRedstonePowered) {
            if (this.energy >= 1.0) {
                this.energy -= 1.0;
            } else if (this.energy < 1.0) {
                this.energy = 0.0;
            }
        }
    }

    public boolean isActive() {
        return true;
    }

    protected final void setPumping(boolean isActive) {
        if (this.isPumping == isActive) {
            return;
        }
        this.isPumping = isActive;
        this.sendNetworkUpdate();
    }

    public boolean isOrientationValid() {
        TileEntity tile = this.getTileBuffer(this.orientation).getTile();
        return this.isPoweredTile(tile, this.orientation);
    }

    public boolean switchOrientation(boolean preferPipe) {
        if (preferPipe && this.switchOrientationDo(true)) {
            return true;
        }
        return this.switchOrientationDo(false);
    }

    private boolean switchOrientationDo(boolean pipesOnly) {
        for (int i = this.orientation.ordinal() + 1; i <= this.orientation.ordinal() + 6; ++i) {
            ForgeDirection o = ForgeDirection.VALID_DIRECTIONS[i % 6];
            TileEntity tile = this.getTileBuffer(o).getTile();
            if (pipesOnly && !(tile instanceof IPipeTile) || !this.isPoweredTile(tile, o)) continue;
            this.orientation = o;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
            return true;
        }
        return false;
    }

    public TileBuffer getTileBuffer(ForgeDirection side) {
        if (this.tileCache == null) {
            this.tileCache = TileBuffer.makeBuffer(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, false);
        }
        return this.tileCache[side.ordinal()];
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.tileCache = null;
        this.checkOrienation = true;
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.tileCache = null;
        this.checkOrienation = true;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.orientation = ForgeDirection.getOrientation((int)data.func_74762_e("orientation"));
        this.progress = data.func_74760_g("progress");
        this.energy = data.func_74769_h("energy");
        this.heat = data.func_74760_g("heat");
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        data.func_74768_a("orientation", this.orientation.ordinal());
        data.func_74776_a("progress", this.progress);
        data.func_74780_a("energy", this.energy);
        data.func_74776_a("heat", this.heat);
    }

    public void getGUINetworkData(int id, int value) {
        switch (id) {
            case 0: {
                int iEnergy = (int)Math.round(this.energy * 10.0);
                iEnergy = iEnergy & 0xFFFF0000 | value & 0xFFFF;
                this.energy = iEnergy / 10;
                break;
            }
            case 1: {
                int iEnergy = (int)Math.round(this.energy * 10.0);
                iEnergy = iEnergy & 0xFFFF | (value & 0xFFFF) << 16;
                this.energy = iEnergy / 10;
                break;
            }
            case 2: {
                this.currentOutput = (float)value / 10.0f;
                break;
            }
            case 3: {
                this.heat = (float)value / 100.0f;
            }
        }
    }

    public void sendGUINetworkData(ContainerEngine containerEngine, ICrafting iCrafting) {
        iCrafting.func_71112_a((Container)containerEngine, 0, (int)Math.round(this.energy * 10.0) & 0xFFFF);
        iCrafting.func_71112_a((Container)containerEngine, 1, (int)(Math.round(this.energy * 10.0) & 0xFFFFFFFFFFFF0000L) >> 16);
        iCrafting.func_71112_a((Container)containerEngine, 2, (int)Math.round(this.currentOutput * 10.0));
        iCrafting.func_71112_a((Container)containerEngine, 3, Math.round(this.heat * 100.0f));
    }

    public abstract boolean isBurning();

    public abstract int getScaledBurnTime(int var1);

    @Override
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        return this.powerHandler.getPowerReceiver();
    }

    @Override
    public void doWork(PowerHandler workProvider) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.addEnergy(this.powerHandler.useEnergy(1.0, this.maxEnergyReceived(), true) * (double)0.95f);
    }

    public void addEnergy(double addition) {
        this.energy += addition;
        if (this.getEnergyStage() == EnergyStage.OVERHEAT) {
            this.field_145850_b.func_72876_a(null, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, this.explosionRange(), true);
            this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (this.energy > this.getMaxEnergy()) {
            this.energy = this.getMaxEnergy();
        }
    }

    public double extractEnergy(double min, double max, boolean doExtract) {
        double extracted;
        if (this.energy < min) {
            return 0.0;
        }
        double actualMax = max > this.maxEnergyExtracted() ? this.maxEnergyExtracted() : max;
        if (actualMax < min) {
            return 0.0;
        }
        if (this.energy >= actualMax) {
            extracted = actualMax;
            if (doExtract) {
                this.energy -= actualMax;
            }
        } else {
            extracted = this.energy;
            if (doExtract) {
                this.energy = 0.0;
            }
        }
        return extracted;
    }

    public boolean isPoweredTile(TileEntity tile, ForgeDirection side) {
        if (tile == null) {
            return false;
        }
        if (MjAPI.getMjBattery(tile, "buildcraft.kinesis", this.orientation.getOpposite()) != null) {
            return true;
        }
        if (tile instanceof IPowerReceptor) {
            return ((IPowerReceptor)tile).getPowerReceiver(side.getOpposite()) != null;
        }
        return false;
    }

    public abstract double getMaxEnergy();

    public double minEnergyReceived() {
        return 2.0;
    }

    public abstract double maxEnergyReceived();

    public abstract double maxEnergyExtracted();

    public abstract float explosionRange();

    public double getEnergyStored() {
        return this.energy;
    }

    public abstract double getCurrentOutput();

    @Override
    public LinkedList<ITrigger> getTriggers() {
        LinkedList<ITrigger> triggers = new LinkedList<ITrigger>();
        triggers.add(BuildCraftEnergy.triggerBlueEngineHeat);
        triggers.add(BuildCraftEnergy.triggerGreenEngineHeat);
        triggers.add(BuildCraftEnergy.triggerYellowEngineHeat);
        triggers.add(BuildCraftEnergy.triggerRedEngineHeat);
        return triggers;
    }

    @Override
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection with) {
        if (type == IPipeTile.PipeType.POWER) {
            return IPipeConnection.ConnectOverride.DEFAULT;
        }
        if (with == this.orientation) {
            return IPipeConnection.ConnectOverride.DISCONNECT;
        }
        return IPipeConnection.ConnectOverride.DEFAULT;
    }

    @Override
    public boolean canEmitPowerFrom(ForgeDirection side) {
        return side == this.orientation;
    }

    public void checkRedstonePower() {
        this.isRedstonePowered = this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public static enum EnergyStage {
        BLUE,
        GREEN,
        YELLOW,
        RED,
        OVERHEAT;

        public static final EnergyStage[] VALUES;

        static {
            VALUES = EnergyStage.values();
        }
    }
}

