/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon;

import buildcraft.api.recipes.BuildcraftRecipes;
import buildcraft.api.recipes.IIntegrationRecipeManager;
import buildcraft.core.inventory.ITransactor;
import buildcraft.core.inventory.InventoryMapper;
import buildcraft.core.inventory.SimpleInventory;
import buildcraft.core.inventory.StackHelper;
import buildcraft.core.inventory.Transactor;
import buildcraft.core.triggers.ActionMachineControl;
import buildcraft.core.utils.StringUtils;
import buildcraft.core.utils.Utils;
import buildcraft.silicon.TileLaserTableBase;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class TileIntegrationTable
extends TileLaserTableBase
implements ISidedInventory {
    public static final int SLOT_INPUT_A = 0;
    public static final int SLOT_INPUT_B = 1;
    public static final int SLOT_OUTPUT = 2;
    private static final int CYCLE_LENGTH = 32;
    private static final int[] SLOTS = Utils.createSlotArray(0, 3);
    private static final int[] SLOT_COMPONENTS = Utils.createSlotArray(3, 9);
    private int tick = 0;
    private SimpleInventory invRecipeOutput = new SimpleInventory(1, "integrationOutput", 64);
    private InventoryMapper invOutput = new InventoryMapper(this.inv, 2, 1, false);
    private IIntegrationRecipeManager.IIntegrationRecipe currentRecipe;
    private boolean canCraft = false;

    public IInventory getRecipeOutput() {
        return this.invRecipeOutput;
    }

    private ItemStack[] getComponents() {
        ItemStack[] components = new ItemStack[9];
        for (int i = 3; i < 12; ++i) {
            components[i - 2 - 1] = this.inv.func_70301_a(i);
        }
        return components;
    }

    private boolean containsComponents(IIntegrationRecipeManager.IIntegrationRecipe recipe) {
        if (recipe == null) {
            return false;
        }
        ItemStack[] components = recipe.getComponents();
        if (components == null || components.length == 0) {
            return true;
        }
        for (ItemStack stack : components) {
            int found = 0;
            for (int i = 3; i < 12; ++i) {
                ItemStack stack1 = this.inv.func_70301_a(i);
                if (stack1 == null || !StackHelper.isMatchingItem(stack, stack1, true, false)) continue;
                found += stack1.field_77994_a;
            }
            if (found != 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ++this.tick;
        if (this.tick % 32 != 0) {
            return;
        }
        this.canCraft = false;
        this.currentRecipe = this.findMatchingRecipe();
        if (this.currentRecipe == null) {
            this.setEnergy(0.0);
            return;
        }
        ItemStack inputA = this.inv.func_70301_a(0);
        ItemStack inputB = this.inv.func_70301_a(1);
        ItemStack[] components = this.getComponents();
        ItemStack output = this.currentRecipe.getOutputForInputs(inputA, inputB, components);
        this.invRecipeOutput.func_70299_a(0, output);
        if (!this.isRoomForOutput(output)) {
            this.setEnergy(0.0);
            return;
        }
        this.canCraft = true;
        if (this.getEnergy() >= this.currentRecipe.getEnergyCost() && this.lastMode != ActionMachineControl.Mode.Off) {
            this.setEnergy(0.0);
            this.inv.func_70298_a(0, 1);
            this.inv.func_70298_a(1, 1);
            block0: for (ItemStack stack : this.currentRecipe.getComponents()) {
                for (int i = 3; i < 12; ++i) {
                    ItemStack stack1 = this.inv.func_70301_a(i);
                    if (stack1 == null || !StackHelper.isMatchingItem(stack, stack1, true, false)) continue;
                    this.inv.func_70298_a(i, 1);
                    continue block0;
                }
            }
            ITransactor trans = Transactor.getTransactorFor(this.invOutput);
            trans.add(output, ForgeDirection.UP, true);
        }
    }

    private IIntegrationRecipeManager.IIntegrationRecipe findMatchingRecipe() {
        ItemStack inputA = this.inv.func_70301_a(0);
        ItemStack inputB = this.inv.func_70301_a(1);
        for (IIntegrationRecipeManager.IIntegrationRecipe iIntegrationRecipe : BuildcraftRecipes.integrationTable.getRecipes()) {
            if (!iIntegrationRecipe.isValidInputA(inputA) || !iIntegrationRecipe.isValidInputB(inputB) || !this.containsComponents(iIntegrationRecipe)) continue;
            return iIntegrationRecipe;
        }
        return null;
    }

    private boolean isRoomForOutput(ItemStack output) {
        ItemStack existingOutput = this.inv.func_70301_a(2);
        if (existingOutput == null) {
            return true;
        }
        return StackHelper.canStacksMerge(output, existingOutput) && output.field_77994_a + existingOutput.field_77994_a <= output.func_77976_d();
    }

    @Override
    public double getRequiredEnergy() {
        if (this.currentRecipe != null) {
            return this.currentRecipe.getEnergyCost();
        }
        return 0.0;
    }

    @Override
    public boolean canCraft() {
        return this.canCraft && this.isActive();
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        switch (slot) {
            case 0: {
                return this.isValidInputA(stack);
            }
            case 1: {
                return this.isValidInputB(stack);
            }
        }
        return false;
    }

    private boolean isValidInputA(ItemStack stack) {
        ItemStack inputB = this.inv.func_70301_a(1);
        for (IIntegrationRecipeManager.IIntegrationRecipe iIntegrationRecipe : BuildcraftRecipes.integrationTable.getRecipes()) {
            if (!iIntegrationRecipe.isValidInputA(stack) || inputB != null && !iIntegrationRecipe.isValidInputB(inputB)) continue;
            return true;
        }
        return false;
    }

    private boolean isValidInputB(ItemStack stack) {
        ItemStack inputA = this.inv.func_70301_a(0);
        for (IIntegrationRecipeManager.IIntegrationRecipe iIntegrationRecipe : BuildcraftRecipes.integrationTable.getRecipes()) {
            if (!iIntegrationRecipe.isValidInputB(stack) || inputA != null && !iIntegrationRecipe.isValidInputA(inputA)) continue;
            return true;
        }
        return false;
    }

    public int[] func_94128_d(int side) {
        return SLOTS;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 2;
    }

    public int func_70302_i_() {
        return 12;
    }

    public String func_145825_b() {
        return StringUtils.localize("tile.integrationTableBlock.name");
    }

    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public boolean isActive() {
        return this.currentRecipe != null && super.isActive();
    }
}

