/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.recipes;

import buildcraft.api.gates.IGateExpansion;
import buildcraft.api.recipes.IIntegrationRecipeManager;
import buildcraft.core.inventory.StackHelper;
import buildcraft.transport.gates.ItemGate;
import net.minecraft.item.ItemStack;

public class GateExpansionRecipe
implements IIntegrationRecipeManager.IIntegrationRecipe {
    private final IGateExpansion expansion;
    private final ItemStack chipset;
    private final ItemStack[] exampleA;
    private final ItemStack[] exampleB;

    public GateExpansionRecipe(IGateExpansion expansion, ItemStack chipset) {
        this.expansion = expansion;
        this.chipset = chipset.func_77946_l();
        this.exampleA = ItemGate.getGateVarients();
        this.exampleB = new ItemStack[]{chipset};
    }

    @Override
    public double getEnergyCost() {
        return 10000.0;
    }

    @Override
    public boolean isValidInputA(ItemStack inputA) {
        if (inputA == null) {
            return false;
        }
        if (!(inputA.func_77973_b() instanceof ItemGate)) {
            return false;
        }
        return !ItemGate.hasGateExpansion(inputA, this.expansion);
    }

    @Override
    public boolean isValidInputB(ItemStack inputB) {
        return StackHelper.isMatchingItem(inputB, this.chipset);
    }

    @Override
    public ItemStack getOutputForInputs(ItemStack inputA, ItemStack inputB, ItemStack[] components) {
        if (!this.isValidInputA(inputA)) {
            return null;
        }
        if (!this.isValidInputB(inputB)) {
            return null;
        }
        ItemStack output = inputA.func_77946_l();
        output.field_77994_a = 1;
        ItemGate.addGateExpansion(output, this.expansion);
        return output;
    }

    @Override
    public ItemStack[] getComponents() {
        return new ItemStack[0];
    }

    @Override
    public ItemStack[] getExampleInputsA() {
        return this.exampleA;
    }

    @Override
    public ItemStack[] getExampleInputsB() {
        return this.exampleB;
    }
}

