/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.core.network.IClientState;
import buildcraft.transport.utils.ConnectionMatrix;
import buildcraft.transport.utils.FacadeMatrix;
import buildcraft.transport.utils.TextureMatrix;
import buildcraft.transport.utils.WireMatrix;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.util.IIcon;

public class PipeRenderState
implements IClientState {
    public final ConnectionMatrix pipeConnectionMatrix = new ConnectionMatrix();
    public final TextureMatrix textureMatrix = new TextureMatrix();
    public final WireMatrix wireMatrix = new WireMatrix();
    public final ConnectionMatrix plugMatrix = new ConnectionMatrix();
    public final ConnectionMatrix robotStationMatrix = new ConnectionMatrix();
    public final FacadeMatrix facadeMatrix = new FacadeMatrix();
    @SideOnly(value=Side.CLIENT)
    public IIcon currentTexture;
    @SideOnly(value=Side.CLIENT)
    public IIcon[] textureArray;
    private boolean dirty = true;
    private boolean isGateLit = false;
    private boolean isGatePulsing = false;
    private int gateIconIndex = 0;

    public void setIsGateLit(boolean value) {
        if (this.isGateLit != value) {
            this.isGateLit = value;
            this.dirty = true;
        }
    }

    public boolean isGateLit() {
        return this.isGateLit;
    }

    public void setIsGatePulsing(boolean value) {
        if (this.isGatePulsing != value) {
            this.isGatePulsing = value;
            this.dirty = true;
        }
    }

    public boolean isGatePulsing() {
        return this.isGatePulsing;
    }

    public void clean() {
        this.dirty = false;
        this.pipeConnectionMatrix.clean();
        this.textureMatrix.clean();
        this.facadeMatrix.clean();
        this.wireMatrix.clean();
        this.plugMatrix.clean();
        this.robotStationMatrix.clean();
    }

    public boolean isDirty() {
        return this.dirty || this.pipeConnectionMatrix.isDirty() || this.textureMatrix.isDirty() || this.wireMatrix.isDirty() || this.facadeMatrix.isDirty() || this.plugMatrix.isDirty() || this.robotStationMatrix.isDirty();
    }

    public boolean needsRenderUpdate() {
        return this.pipeConnectionMatrix.isDirty() || this.textureMatrix.isDirty() || this.facadeMatrix.isDirty() || this.plugMatrix.isDirty() || this.robotStationMatrix.isDirty();
    }

    @Override
    public void writeData(ByteBuf data) {
        data.writeBoolean(this.isGateLit);
        data.writeBoolean(this.isGatePulsing);
        data.writeInt(this.gateIconIndex);
        this.pipeConnectionMatrix.writeData(data);
        this.textureMatrix.writeData(data);
        this.wireMatrix.writeData(data);
        this.facadeMatrix.writeData(data);
        this.plugMatrix.writeData(data);
        this.robotStationMatrix.writeData(data);
    }

    @Override
    public void readData(ByteBuf data) {
        this.isGateLit = data.readBoolean();
        this.isGatePulsing = data.readBoolean();
        this.gateIconIndex = data.readInt();
        this.pipeConnectionMatrix.readData(data);
        this.textureMatrix.readData(data);
        this.wireMatrix.readData(data);
        this.facadeMatrix.readData(data);
        this.plugMatrix.readData(data);
        this.robotStationMatrix.readData(data);
    }
}

