/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.gates;

import buildcraft.BuildCraftTransport;
import buildcraft.api.gates.GateExpansionController;
import buildcraft.api.gates.IAction;
import buildcraft.api.gates.IGateExpansion;
import buildcraft.api.mj.IBatteryObject;
import buildcraft.api.mj.MjAPI;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.gates.GateExpansionBuildcraft;
import buildcraft.transport.triggers.ActionEnergyPulsar;
import buildcraft.transport.triggers.ActionSingleEnergyPulse;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public final class GateExpansionPulsar
extends GateExpansionBuildcraft
implements IGateExpansion {
    public static GateExpansionPulsar INSTANCE = new GateExpansionPulsar();

    private GateExpansionPulsar() {
        super("pulsar");
    }

    @Override
    public GateExpansionController makeController(TileEntity pipeTile) {
        return new GateExpansionControllerPulsar(pipeTile);
    }

    private class GateExpansionControllerPulsar
    extends GateExpansionController {
        private static final int PULSE_PERIOD = 10;
        private boolean isActive;
        private boolean singlePulse;
        private boolean hasPulsed;
        private int pulseCount;
        private int tick;

        public GateExpansionControllerPulsar(TileEntity pipeTile) {
            super(GateExpansionPulsar.this, pipeTile);
            this.tick = (int)Math.random() * 10;
        }

        @Override
        public void startResolution() {
            if (this.isActive()) {
                this.disablePulse();
            }
        }

        @Override
        public boolean resolveAction(IAction action, int count) {
            if (action instanceof ActionEnergyPulsar) {
                this.enablePulse(count);
                return true;
            }
            if (action instanceof ActionSingleEnergyPulse) {
                this.enableSinglePulse(count);
                return true;
            }
            return false;
        }

        @Override
        public void addActions(List<IAction> list) {
            super.addActions(list);
            list.add(BuildCraftTransport.actionEnergyPulser);
            list.add(BuildCraftTransport.actionSingleEnergyPulse);
        }

        @Override
        public void tick() {
            if (!this.isActive && this.hasPulsed) {
                this.hasPulsed = false;
            }
            if (this.tick++ % 10 != 0) {
                return;
            }
            if (!this.isActive) {
                ((TileGenericPipe)this.pipeTile).pipe.gate.setPulsing(false);
                return;
            }
            IBatteryObject battery = MjAPI.getMjBattery(this.pipeTile);
            if (!(battery == null || this.singlePulse && this.hasPulsed)) {
                ((TileGenericPipe)this.pipeTile).pipe.gate.setPulsing(true);
                battery.addEnergy((float)Math.min(1 << this.pulseCount - 1, 64) * 1.01f);
                this.hasPulsed = true;
            } else {
                ((TileGenericPipe)this.pipeTile).pipe.gate.setPulsing(true);
            }
        }

        private void enableSinglePulse(int count) {
            this.singlePulse = true;
            this.isActive = true;
            this.pulseCount = count;
        }

        private void enablePulse(int count) {
            this.isActive = true;
            this.singlePulse = false;
            this.pulseCount = count;
        }

        private void disablePulse() {
            if (!this.isActive) {
                this.hasPulsed = false;
            }
            this.isActive = false;
            this.pulseCount = 0;
        }

        @Override
        public boolean isActive() {
            return this.isActive;
        }

        @Override
        public void writeToNBT(NBTTagCompound nbt) {
            nbt.func_74757_a("singlePulse", this.singlePulse);
            nbt.func_74757_a("isActive", this.isActive);
            nbt.func_74757_a("hasPulsed", this.hasPulsed);
            nbt.func_74768_a("pulseCount", this.pulseCount);
            nbt.func_74768_a("tick", this.tick);
        }

        @Override
        public void readFromNBT(NBTTagCompound nbt) {
            this.isActive = nbt.func_74767_n("isActive");
            this.singlePulse = nbt.func_74767_n("singlePulse");
            this.hasPulsed = nbt.func_74767_n("hasPulsed");
            this.pulseCount = nbt.func_74762_e("pulseCount");
            this.tick = nbt.func_74762_e("tick");
        }
    }
}

