/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.gates;

import buildcraft.api.gates.GateExpansionController;
import buildcraft.api.gates.GateExpansions;
import buildcraft.api.gates.IGateExpansion;
import buildcraft.transport.Gate;
import buildcraft.transport.Pipe;
import buildcraft.transport.gates.GateDefinition;
import buildcraft.transport.gates.GateExpansionPulsar;
import buildcraft.transport.gates.ItemGate;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public final class GateFactory {
    private GateFactory() {
    }

    public static Gate makeGate(Pipe pipe, GateDefinition.GateMaterial material, GateDefinition.GateLogic logic) {
        return new Gate(pipe, material, logic);
    }

    public static Gate makeGate(Pipe pipe, ItemStack stack) {
        if (stack == null || stack.field_77994_a <= 0 || !(stack.func_77973_b() instanceof ItemGate)) {
            return null;
        }
        Gate gate = GateFactory.makeGate(pipe, ItemGate.getMaterial(stack), ItemGate.getLogic(stack));
        for (IGateExpansion expansion : ItemGate.getInstalledExpansions(stack)) {
            gate.addGateExpansion(expansion);
        }
        return gate;
    }

    public static Gate makeGate(Pipe pipe, NBTTagCompound nbt) {
        GateDefinition.GateMaterial material = GateDefinition.GateMaterial.REDSTONE;
        GateDefinition.GateLogic logic = GateDefinition.GateLogic.AND;
        if (nbt.func_74764_b("Kind")) {
            int kind = nbt.func_74762_e("Kind");
            switch (kind) {
                case 1: 
                case 2: {
                    material = GateDefinition.GateMaterial.IRON;
                    break;
                }
                case 3: 
                case 4: {
                    material = GateDefinition.GateMaterial.GOLD;
                    break;
                }
                case 5: 
                case 6: {
                    material = GateDefinition.GateMaterial.DIAMOND;
                }
            }
            switch (kind) {
                case 2: 
                case 4: 
                case 6: {
                    logic = GateDefinition.GateLogic.OR;
                }
            }
        }
        if (nbt.func_74764_b("material")) {
            try {
                material = GateDefinition.GateMaterial.valueOf(nbt.func_74779_i("material"));
            }
            catch (IllegalArgumentException ex) {
                return null;
            }
        }
        if (nbt.func_74764_b("logic")) {
            try {
                logic = GateDefinition.GateLogic.valueOf(nbt.func_74779_i("logic"));
            }
            catch (IllegalArgumentException ex) {
                return null;
            }
        }
        Gate gate = GateFactory.makeGate(pipe, material, logic);
        gate.readFromNBT(nbt);
        if (nbt.func_74764_b("Pulser")) {
            NBTTagCompound pulsarTag = nbt.func_74775_l("Pulser");
            GateExpansionController pulsarCon = GateExpansionPulsar.INSTANCE.makeController(pipe.container);
            pulsarCon.readFromNBT(pulsarTag);
            gate.expansions.put((Object)GateExpansionPulsar.INSTANCE, (Object)pulsarCon);
        }
        NBTTagList exList = nbt.func_150295_c("expansions", 10);
        for (int i = 0; i < exList.func_74745_c(); ++i) {
            NBTTagCompound conNBT = exList.func_150305_b(i);
            IGateExpansion ex = GateExpansions.getExpansion(conNBT.func_74779_i("type"));
            if (ex == null) continue;
            GateExpansionController con = ex.makeController(pipe.container);
            con.readFromNBT(conNBT.func_74775_l("data"));
            gate.expansions.put((Object)ex, (Object)con);
        }
        return gate;
    }
}

