/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.network;

import buildcraft.core.network.BuildCraftPacket;
import buildcraft.core.utils.EnumColor;
import buildcraft.transport.TravelingItem;
import io.netty.buffer.ByteBuf;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

public class PacketPipeTransportTraveler
extends BuildCraftPacket {
    public int posX;
    public int posY;
    public int posZ;
    private TravelingItem item;
    private boolean forceStackRefresh;
    private int entityId;
    private ForgeDirection input;
    private ForgeDirection output;
    private EnumColor color;
    private float itemX;
    private float itemY;
    private float itemZ;
    private float speed;

    public PacketPipeTransportTraveler() {
    }

    public PacketPipeTransportTraveler(TravelingItem item, boolean forceStackRefresh) {
        this.item = item;
        this.forceStackRefresh = forceStackRefresh;
    }

    @Override
    public void writeData(ByteBuf data) {
        data.writeFloat((float)this.item.xCoord);
        data.writeFloat((float)this.item.yCoord);
        data.writeFloat((float)this.item.zCoord);
        data.writeShort(this.item.id);
        data.writeByte((int)((byte)this.item.input.ordinal()));
        data.writeByte((int)((byte)this.item.output.ordinal()));
        data.writeByte(this.item.color != null ? this.item.color.ordinal() : -1);
        data.writeFloat(this.item.getSpeed());
        data.writeBoolean(this.forceStackRefresh);
    }

    @Override
    public void readData(ByteBuf data) {
        this.itemX = data.readFloat();
        this.itemY = data.readFloat();
        this.itemZ = data.readFloat();
        this.posX = MathHelper.func_76141_d((float)this.itemX);
        this.posY = MathHelper.func_76141_d((float)this.itemY);
        this.posZ = MathHelper.func_76141_d((float)this.itemZ);
        this.entityId = data.readShort();
        this.input = ForgeDirection.getOrientation((int)data.readByte());
        this.output = ForgeDirection.getOrientation((int)data.readByte());
        byte c = data.readByte();
        if (c != -1) {
            this.color = EnumColor.fromId(c);
        }
        this.speed = data.readFloat();
        this.forceStackRefresh = data.readBoolean();
    }

    public int getTravelingEntityId() {
        return this.entityId;
    }

    public ForgeDirection getInputOrientation() {
        return this.input;
    }

    public ForgeDirection getOutputOrientation() {
        return this.output;
    }

    public EnumColor getColor() {
        return this.color;
    }

    public double getItemX() {
        return this.itemX;
    }

    public double getItemY() {
        return this.itemY;
    }

    public double getItemZ() {
        return this.itemZ;
    }

    public float getSpeed() {
        return this.speed;
    }

    public boolean forceStackRefresh() {
        return this.forceStackRefresh;
    }

    @Override
    public int getID() {
        return 2;
    }
}

