/*
 * Decompiled with CFR 0.152.
 */
package RCM.Entities;

import RCM.RCM_Main;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class PhysicsHelper {
    private List<Vector3f> forcePositions = new ArrayList<Vector3f>();
    private List<Vector3f> forces = new ArrayList<Vector3f>();
    private List<AxisAngle4f> propAngles = new ArrayList<AxisAngle4f>();
    private List<Vector3f> propFlowDirection = new ArrayList<Vector3f>();
    private List<Vector3f> wheelLocations = new ArrayList<Vector3f>();
    private float[] forecMagnitude;
    private int[] torques;
    private float[] torqueMagnitude;

    public void loadForce(String name) throws FileNotFoundException, IOException {
        String line;
        URL url = this.getClass().getResource(RCM_Main.propertiesFilePath + name);
        InputStream inputstream = url.openStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream));
        int row = 0;
        while ((line = reader.readLine()) != null) {
            float z;
            float y;
            if (line.startsWith("en ")) {
                int engineNumber = Integer.valueOf(line.split(" ")[1]);
                this.torques = new int[engineNumber];
            }
            if (line.startsWith("p ")) {
                float x = Float.valueOf(line.split(" ")[1]).floatValue();
                y = Float.valueOf(line.split(" ")[2]).floatValue();
                z = Float.valueOf(line.split(" ")[3]).floatValue();
                this.forcePositions.add(new Vector3f(x, y, z));
                continue;
            }
            if (line.startsWith("t ")) {
                int torque;
                this.torques[row] = torque = Integer.valueOf(line.split(" ")[1]).intValue();
                ++row;
                continue;
            }
            if (!line.startsWith("Wheel_position_")) continue;
            float x = Float.valueOf(line.split(" ")[1]).floatValue();
            y = Float.valueOf(line.split(" ")[2]).floatValue();
            z = Float.valueOf(line.split(" ")[3]).floatValue();
            this.wheelLocations.add(new Vector3f(x, y, z));
        }
        this.forecMagnitude = new float[this.forcePositions.size()];
        this.torqueMagnitude = new float[this.torques.length];
        reader.close();
    }

    public void setPropAngles(float angle) {
        this.propAngles.add(new AxisAngle4f(0.0f, 0.0f, -1.0f, angle));
        this.propAngles.add(new AxisAngle4f(1.0f, 0.0f, 0.0f, angle));
        this.propAngles.add(new AxisAngle4f(0.0f, 0.0f, 1.0f, angle));
        this.propAngles.add(new AxisAngle4f(-1.0f, 0.0f, 0.0f, angle));
    }

    public AxisAngle4f getBladeAngle(int place) {
        return this.propAngles.get(place);
    }

    public void resetPropAngles() {
        this.propAngles.removeAll(this.propAngles);
    }

    public void setPropFlowDirection(float i) {
        this.propFlowDirection.add(new Vector3f(i, 0.0f, 0.0f));
        this.propFlowDirection.add(new Vector3f(0.0f, 0.0f, i));
        this.propFlowDirection.add(new Vector3f(-i, 0.0f, 0.0f));
        this.propFlowDirection.add(new Vector3f(0.0f, 0.0f, -i));
    }

    public Vector3f getPropFlowDirection(int place) {
        return this.propFlowDirection.get(place);
    }

    public void resetPropFlowDirection() {
        this.propFlowDirection.removeAll(this.propFlowDirection);
    }

    public int getForceQuant() {
        return this.forces.size();
    }

    public Vector3f getForce(int place, Quat4f localQuat) {
        Vector3f force = new Vector3f();
        force = this.forces.get(place);
        force = this.rotateVector(localQuat, force);
        force.scale(this.forecMagnitude[place]);
        return force;
    }

    public Vector3f getForceDirc(int place, Quat4f localQuat) {
        Vector3f force = new Vector3f();
        force = this.forces.get(place);
        force = this.rotateVector(localQuat, force);
        return force;
    }

    public float getForceMagnitude(int place) {
        float force = this.forecMagnitude[place];
        return force;
    }

    public void addForce(Vector3f force) {
        this.forces.add(force);
    }

    public int getTorqueQuant() {
        return this.torques.length;
    }

    public Vector3f getPosition(int place, Quat4f localQuat) {
        Vector3f position = new Vector3f();
        position = this.forcePositions.get(place);
        position = this.rotateVector(localQuat, position);
        return position;
    }

    public Vector3f getTorque(int place, Quat4f localQuat) {
        Vector3f torque = new Vector3f();
        torque = this.forces.get(place);
        torque = this.rotateVector(localQuat, torque);
        torque.scale(this.torqueMagnitude[place] * (float)this.torques[place]);
        return torque;
    }

    public int getTorqueDirection(int place) {
        return this.torques[place];
    }

    public void setForceMagnitude(int place, float magnitude) {
        this.forecMagnitude[place] = magnitude;
    }

    public void setTorqueMagnitude(int place, float magnitude) {
        this.torqueMagnitude[place] = magnitude;
    }

    public Vector3f getWheelPosition(int place, Quat4f localQuat) {
        Vector3f position = new Vector3f();
        position = this.wheelLocations.get(place);
        position = this.rotateVector(localQuat, position);
        return position;
    }

    public int getNumberOfWheels() {
        return this.wheelLocations.size();
    }

    public Vector3f getVelocityAtPoint(int place, Quat4f localQuat, Vector3f linearVel, Vector3f rotationalVel) {
        Vector3f velocityAtPoint = new Vector3f();
        velocityAtPoint.cross(rotationalVel, this.getPosition(place, localQuat));
        velocityAtPoint.add((Tuple3f)linearVel);
        return velocityAtPoint;
    }

    public Vector3f getVelocityAtPoint(Quat4f localQuat, Vector3f linearVel, Vector3f rotationalVel, Vector3f point) {
        Vector3f velocityAtPoint = new Vector3f();
        velocityAtPoint.cross(rotationalVel, this.rotateVector(localQuat, point));
        velocityAtPoint.add((Tuple3f)linearVel);
        return velocityAtPoint;
    }

    public float getDirVelocity(int place, Quat4f localQuat, Vector3f linearVel, Vector3f rotationalVel) {
        Vector3f VelcDir = new Vector3f();
        VelcDir = this.forces.get(place);
        VelcDir = this.rotateVector(localQuat, VelcDir);
        Vector3f velocityAtPoint = new Vector3f();
        velocityAtPoint.cross(rotationalVel, this.getPosition(place, localQuat));
        velocityAtPoint.add((Tuple3f)linearVel);
        float VelcDirMag = VelcDir.dot(velocityAtPoint);
        return VelcDirMag;
    }

    public float getPropAoA(Quat4f localQuat, Vector3f airVect) {
        Vector3f refVect = new Vector3f(0.0f, 1.0f, 0.0f);
        refVect = this.rotateVector(localQuat, refVect);
        float angleOfAtt = 0.0f;
        if (airVect.length() > 0.0f) {
            angleOfAtt = -refVect.angle(airVect) + 1.5707964f;
        }
        return angleOfAtt;
    }

    public float getAoA(int place, Quat4f localQuat, Vector3f airVect) {
        Vector3f refVect = new Vector3f(this.forces.get(place));
        refVect = this.rotateVector(localQuat, refVect);
        float angleOfAtt = 0.0f;
        if (airVect.length() > 0.0f) {
            angleOfAtt = -refVect.angle(airVect) + 1.5707964f;
        }
        return angleOfAtt;
    }

    public float getAoA(Vector3f lift, Quat4f localQuat, Vector3f airVect) {
        Vector3f refVect = new Vector3f(lift);
        refVect = this.rotateVector(localQuat, refVect);
        float angleOfAtt = 0.0f;
        if (airVect.length() > 0.0f) {
            angleOfAtt = -refVect.angle(airVect) + 1.5707964f;
        }
        return angleOfAtt;
    }

    public Vector3f getDrag(Vector3f airflow, float dragCoeff, float density, float area) {
        Vector3f drag = new Vector3f();
        Vector3f airflowDirect = new Vector3f(0.0f, 0.0f, 0.0f);
        if (airflow.length() > 0.0f) {
            airflowDirect.normalize(airflow);
            airflowDirect.scale(-1.0f);
        }
        drag.x = dragCoeff * 0.5f * density * (float)Math.pow(airflow.x, 2.0) * area * airflowDirect.x;
        drag.y = dragCoeff * 0.5f * density * (float)Math.pow(airflow.y, 2.0) * area * airflowDirect.y;
        drag.z = dragCoeff * 0.5f * density * (float)Math.pow(airflow.z, 2.0) * area * airflowDirect.z;
        return drag;
    }

    public Vector3f rotateVector(Quat4f LocalQuat, Vector3f vect) {
        Matrix4f quatMatrix = new Matrix4f();
        quatMatrix.set(LocalQuat);
        Vector3f vert = new Vector3f();
        vert.x = quatMatrix.m00 * vect.x + quatMatrix.m01 * vect.y + quatMatrix.m02 * vect.z;
        vert.y = quatMatrix.m10 * vect.x + quatMatrix.m11 * vect.y + quatMatrix.m12 * vect.z;
        vert.z = quatMatrix.m20 * vect.x + quatMatrix.m21 * vect.y + quatMatrix.m22 * vect.z;
        return vert;
    }
}

