/*
 * Decompiled with CFR 0.152.
 */
package RCM.Models;

import RCM.Models.Model;
import RCM.Models.ModelFace;
import RCM.Reader.FileReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector3f;

public class ModelLoader {
    public static Model loadModel(String path, String name) throws FileNotFoundException, IOException {
        String line;
        FileReader reader = new FileReader(path);
        boolean flag = false;
        Model m = new Model();
        while (!((line = reader.readLine()) == null || line.startsWith("o ") && line.contains(name))) {
        }
        line = reader.readLine();
        while (line != null && !line.startsWith("e ")) {
            if (line.startsWith("v ")) {
                float x = Float.valueOf(line.split(" ")[1]).floatValue();
                float y = Float.valueOf(line.split(" ")[2]).floatValue();
                float z = Float.valueOf(line.split(" ")[3]).floatValue();
                m.vertices.add(new Vector3f(x, y, z));
            } else if (line.startsWith("t ")) {
                float x = Float.valueOf(line.split(" ")[1]).floatValue();
                float y = -Float.valueOf(line.split(" ")[2]).floatValue();
                m.textureCoordinates.add(new Vector2f(x, y));
            } else if (line.startsWith("n ")) {
                float x = Float.valueOf(line.split(" ")[1]).floatValue();
                float y = Float.valueOf(line.split(" ")[2]).floatValue();
                float z = Float.valueOf(line.split(" ")[3]).floatValue();
                m.normals.add(new Vector3f(x, y, z));
            } else if (line.startsWith("f ")) {
                Vector3f vertexIndices = new Vector3f(Float.valueOf(line.split(" ")[1].split("/")[0]).floatValue(), Float.valueOf(line.split(" ")[2].split("/")[0]).floatValue(), Float.valueOf(line.split(" ")[3].split("/")[0]).floatValue());
                Vector3f textureCoordinateIndices = new Vector3f(Float.valueOf(line.split(" ")[1].split("/")[1]).floatValue(), Float.valueOf(line.split(" ")[2].split("/")[1]).floatValue(), Float.valueOf(line.split(" ")[3].split("/")[1]).floatValue());
                Vector3f normalIndices = new Vector3f(Float.valueOf(line.split(" ")[1].split("/")[2]).floatValue(), Float.valueOf(line.split(" ")[2].split("/")[2]).floatValue(), Float.valueOf(line.split(" ")[3].split("/")[2]).floatValue());
                m.faces.add(new ModelFace(vertexIndices, normalIndices, textureCoordinateIndices));
            }
            line = reader.readLine();
        }
        return m;
    }
}

