/*
 * Decompiled with CFR 0.152.
 */
package RCM.Packets;

import RCM.Entities.GlobalEntity;
import RCM.RCM_Main;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.List;
import javax.vecmath.Quat4f;
import net.minecraft.entity.Entity;

public class MessageGlobalEntity
implements IMessage,
IMessageHandler<MessageGlobalEntity, IMessage> {
    public int ID;
    public Quat4f rotateQuat;
    public float posX;
    public float posY;
    public float posZ;
    public float throttle;
    public boolean damaged;

    public MessageGlobalEntity() {
    }

    public MessageGlobalEntity(int entityID, float pX, float pY, float pZ, Quat4f quat, float entityThrottle, boolean damage) {
        this.ID = entityID;
        this.posX = pX;
        this.posY = pY;
        this.posZ = pZ;
        this.rotateQuat = new Quat4f(quat);
        this.throttle = entityThrottle;
        this.damaged = damage;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.ID);
        buf.writeFloat(this.posX);
        buf.writeFloat(this.posY);
        buf.writeFloat(this.posZ);
        buf.writeFloat(this.rotateQuat.x);
        buf.writeFloat(this.rotateQuat.y);
        buf.writeFloat(this.rotateQuat.z);
        buf.writeFloat(this.rotateQuat.w);
        buf.writeFloat(this.throttle);
        buf.writeBoolean(this.damaged);
    }

    public void fromBytes(ByteBuf buf) {
        this.ID = buf.readInt();
        this.posX = buf.readFloat();
        this.posY = buf.readFloat();
        this.posZ = buf.readFloat();
        this.rotateQuat = new Quat4f(buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat());
        this.throttle = buf.readFloat();
        this.damaged = buf.readBoolean();
    }

    public IMessage onMessage(MessageGlobalEntity message, MessageContext ctx) {
        List entityList = null;
        Entity entity = null;
        GlobalEntity nwEntity = null;
        if (ctx.side.isClient()) {
            entityList = RCM_Main.proxy.getClientWorld().field_72996_f;
        } else if (ctx.side.isServer()) {
            entityList = RCM_Main.proxy.getServerWorld().field_72996_f;
        }
        for (int i = 0; i < entityList.size(); ++i) {
            entity = (Entity)entityList.get(i);
            if (entity.func_145782_y() != message.ID) continue;
            nwEntity = (GlobalEntity)entity;
            nwEntity.packetUpdate(message.posX, message.posY, message.posZ, message.rotateQuat, message.throttle, message.damaged);
        }
        return null;
    }
}

