/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;
import schmoller.tubes.api.Payload;
import schmoller.tubes.api.SizeMode;
import schmoller.tubes.api.TubeItem;
import schmoller.tubes.api.helpers.CommonHelper;
import schmoller.tubes.api.helpers.RenderHelper;
import schmoller.tubes.api.interfaces.IFilter;

public class ColorFilter
implements IFilter {
    public static ResourceLocation baseTexture = new ResourceLocation("tubes", "textures/gui/iconColorPallet.png");
    public static ResourceLocation centerTexture = new ResourceLocation("tubes", "textures/gui/iconColorPalletCenter.png");
    private int mColor;

    public ColorFilter(int color) {
        this.mColor = color;
    }

    @Override
    public String getType() {
        return "color";
    }

    @Override
    public Class<? extends Payload> getPayloadType() {
        return null;
    }

    @Override
    public boolean matches(Payload payload, SizeMode mode) {
        return true;
    }

    @Override
    public boolean matches(TubeItem item, SizeMode mode) {
        return this.mColor == item.colour;
    }

    @Override
    public void increase(boolean useMax, boolean shift) {
    }

    @Override
    public void decrease(boolean shift) {
    }

    @Override
    public int getMax() {
        return 1;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderFilter(int x, int y) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(baseTexture);
        RenderHelper.renderRect(x, y, 16, 16, 0.0f, 0.0f, 1.0f, 1.0f);
        if (this.mColor != -1) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(centerTexture);
            Tessellator.field_78398_a.func_78378_d(CommonHelper.getDyeColor(this.mColor));
            int color = CommonHelper.getDyeColor(this.mColor);
            GL11.glColor3f((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f));
            RenderHelper.renderRect(x, y, 16, 16, 0.0f, 0.0f, 1.0f, 1.0f);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Override
    public void write(NBTTagCompound tag) {
        tag.func_74768_a("Color", this.mColor);
    }

    @Override
    public void write(MCDataOutput output) {
        output.writeShort(this.mColor);
    }

    public static ColorFilter from(NBTTagCompound tag) {
        return new ColorFilter(tag.func_74762_e("Color"));
    }

    public static ColorFilter from(MCDataInput input) {
        return new ColorFilter(input.readShort());
    }

    @Override
    public IFilter copy() {
        return new ColorFilter(this.mColor);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<String> getTooltip(List<String> current) {
        return Arrays.asList(this.mColor == -1 ? StatCollector.func_74838_a((String)"gui.colors.any") : CommonHelper.getDyeName(this.mColor));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ColorFilter)) {
            return false;
        }
        return this.mColor == ((ColorFilter)obj).mColor;
    }
}

